/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.search.internal.ui.text;

import java.util.ArrayList;
import java.util.Enumeration;
import org.eclipse.core.resources.IResource;
import org.eclipse.search.internal.ui.text.FileMatch;
import org.eclipse.search.ui.text.AbstractTextSearchResult;
import org.eclipse.search.ui.text.Match;

public class LineElement {
    private final IResource fParent;
    private final int fLineNumber;
    private final int fLineStartOffset;
    private final String fLineContents;

    public LineElement(IResource parent, int lineNumber, int lineStartOffset, String lineContents) {
        this.fParent = parent;
        this.fLineNumber = lineNumber;
        this.fLineStartOffset = lineStartOffset;
        this.fLineContents = lineContents;
    }

    public IResource getParent() {
        return this.fParent;
    }

    public int getLine() {
        return this.fLineNumber;
    }

    public String getContents() {
        return this.fLineContents;
    }

    public int getOffset() {
        return this.fLineStartOffset;
    }

    public boolean contains(int offset) {
        return this.fLineStartOffset <= offset && offset < this.fLineStartOffset + this.fLineContents.length();
    }

    public int getLength() {
        return this.fLineContents.length();
    }

    public FileMatch[] getMatches(AbstractTextSearchResult result) {
        ArrayList<FileMatch> res = new ArrayList<FileMatch>();
        Enumeration<Match> matches = result.getMatchSet(this.fParent);
        while (matches.hasMoreElements()) {
            FileMatch curr = (FileMatch)matches.nextElement();
            if (curr.getLineElement() != this) continue;
            res.add(curr);
        }
        return res.toArray(new FileMatch[res.size()]);
    }

    public int getNumberOfMatches(AbstractTextSearchResult result) {
        int count = 0;
        Enumeration<Match> matches = result.getMatchSet(this.fParent);
        while (matches.hasMoreElements()) {
            FileMatch curr = (FileMatch)matches.nextElement();
            if (curr.getLineElement() != this) continue;
            ++count;
        }
        return count;
    }

    public boolean hasMatches(AbstractTextSearchResult result) {
        Enumeration<Match> matches = result.getMatchSet(this.fParent);
        while (matches.hasMoreElements()) {
            FileMatch curr = (FileMatch)matches.nextElement();
            if (curr.getLineElement() != this) continue;
            return true;
        }
        return false;
    }
}

