/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui;

import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.jface.fieldassist.ContentProposal;
import org.eclipse.jface.fieldassist.IContentProposal;
import org.eclipse.jface.fieldassist.IContentProposalProvider;
import org.eclipse.mylyn.internal.tasks.ui.editors.LabelsAttributeEditor;

public class OptionsProposalProvider
implements IContentProposalProvider {
    private static final String VALUE_SEPARATOR = ",";
    private final Set<String> proposals;
    private final boolean isMultiSelect;

    public OptionsProposalProvider(Map<String, String> proposals, boolean isMultiSelect) {
        this.proposals = proposals.keySet();
        this.isMultiSelect = isMultiSelect;
    }

    public IContentProposal[] getProposals(String contents, int position) {
        HashSet<String> filteredProposals = new HashSet<String>(this.proposals);
        filteredProposals.remove("");
        String lastValue = "";
        if (this.isMultiSelect) {
            String[] contentsArray = contents.split(VALUE_SEPARATOR, -1);
            if (contentsArray.length > 0) {
                List<String> trimmedContents = LabelsAttributeEditor.getTrimmedValues(contentsArray);
                filteredProposals.removeAll(trimmedContents);
                lastValue = contentsArray[contentsArray.length - 1].trim();
            }
        } else {
            lastValue = contents;
        }
        if (!lastValue.isEmpty()) {
            Iterator iterator = filteredProposals.iterator();
            while (iterator.hasNext()) {
                String proposal = (String)iterator.next();
                if (proposal.toLowerCase().contains(lastValue.toLowerCase())) continue;
                iterator.remove();
            }
        }
        String existingValues = contents.substring(0, contents.length() - lastValue.length());
        return (IContentProposal[])filteredProposals.stream().sorted(String.CASE_INSENSITIVE_ORDER).map(p -> new ContentProposal(existingValues + p, p, null)).collect(Collectors.toList()).toArray(IContentProposal[]::new);
    }

    public boolean isMultiSelect() {
        return this.isMultiSelect;
    }
}

