/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.model.tools.internal.representation;

import java.util.HashMap;
import java.util.Optional;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.notify.impl.NotificationImpl;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.ECrossReferenceAdapter;
import org.eclipse.sirius.business.api.resource.ResourceDescriptor;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.eclipse.sirius.viewpoint.DRepresentationDescriptor;
import org.eclipse.sirius.viewpoint.ViewpointPackage;

public class DRepresentationDescriptorToDRepresentationLinkManager {
    private DRepresentationDescriptor repDescriptor;

    public DRepresentationDescriptorToDRepresentationLinkManager(DRepresentationDescriptor repDescriptor) {
        this.repDescriptor = repDescriptor;
    }

    public void setRepresentation(DRepresentation representation) {
        if (representation != null) {
            String iD = representation.getUid();
            Optional.ofNullable(representation.eResource()).map(resource -> resource.getURI().appendFragment(iD)).ifPresent(uri -> this.repDescriptor.setRepPath(new ResourceDescriptor((URI)uri)));
        } else {
            this.repDescriptor.setRepPath(null);
        }
    }

    public Optional<DRepresentation> getRepresentation(boolean loadOnDemand) {
        Optional<DRepresentation> representation = this.getRepresentationInternal(false);
        if (loadOnDemand && !representation.isPresent()) {
            representation = this.getRepresentationInternal(true);
            representation.ifPresent(rep -> Optional.ofNullable(ECrossReferenceAdapter.getCrossReferenceAdapter((Notifier)this.repDescriptor.eResource())).ifPresent(crossRef -> {
                crossRef.setTarget((Notifier)this.repDescriptor);
                rep.eAdapters().add(crossRef);
            }));
            if (representation.isPresent()) {
                NotificationImpl setRepresentationNotification = new NotificationImpl(9, null, representation.get()){

                    public Object getNotifier() {
                        return DRepresentationDescriptorToDRepresentationLinkManager.this.repDescriptor;
                    }

                    public Object getFeature() {
                        return ViewpointPackage.eINSTANCE.getDRepresentationDescriptor_Representation();
                    }
                };
                this.repDescriptor.eNotify((Notification)setRepresentationNotification);
            }
        }
        return representation;
    }

    private Optional<DRepresentation> getRepresentationInternal(boolean loadOnDemand) {
        Optional<DRepresentation> dRepresentationOpt = Optional.empty();
        ResourceDescriptor resourceDescriptor = this.repDescriptor.getRepPath();
        Resource resource = this.repDescriptor.eResource();
        Optional<URI> uri = Optional.ofNullable(resourceDescriptor).map(desc -> desc.getResourceURI());
        if (uri.isPresent()) {
            URI repResourceURI = uri.get().trimFragment();
            Optional<Resource> representationResource = Optional.ofNullable(resource).map(rsr -> rsr.getResourceSet()).filter(resourceSet -> !loadOnDemand || resourceSet.getURIConverter().exists(repResourceURI, new HashMap())).map(resourceSet -> {
                Resource res = null;
                try {
                    res = resourceSet.getResource(repResourceURI, loadOnDemand);
                }
                catch (RuntimeException runtimeException) {}
                return res;
            });
            String repId = uri.get().fragment();
            if (representationResource.isPresent() && repId != null) {
                try {
                    dRepresentationOpt = representationResource.get().getContents().stream().filter(DRepresentation.class::isInstance).map(DRepresentation.class::cast).filter(dRepresentation -> repId.equals(dRepresentation.getUid())).findFirst();
                }
                catch (NullPointerException nullPointerException) {}
            }
        }
        return dRepresentationOpt;
    }
}

