/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.sequence.ui.tool.internal.util;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.Request;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.gef.requests.CreateConnectionRequest;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateUnspecifiedTypeConnectionRequest;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.AbstractNodeEvent;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.Execution;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.ISequenceElementAccessor;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.ISequenceEvent;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.InstanceRole;
import org.eclipse.sirius.diagram.sequence.description.BasicMessageMapping;
import org.eclipse.sirius.diagram.sequence.description.CreationMessageMapping;
import org.eclipse.sirius.diagram.sequence.description.DestructionMessageMapping;
import org.eclipse.sirius.diagram.sequence.description.tool.MessageCreationTool;
import org.eclipse.sirius.diagram.sequence.ui.tool.internal.edit.part.ExecutionEditPart;
import org.eclipse.sirius.diagram.sequence.ui.tool.internal.edit.part.GateEditPart;
import org.eclipse.sirius.ext.base.Option;

public class RequestQuery
extends org.eclipse.sirius.diagram.ui.business.internal.query.RequestQuery {
    public static final String IS_MOVED_BY_PARENT_EXECUTION = "isMovedByParentExecution";

    public RequestQuery(Request request) {
        super(request);
    }

    public Rectangle getFinalBounds(ExecutionEditPart self) {
        Rectangle bounds = self.getFigure().getBounds().getCopy();
        return this.getLogicalTransformedRectangle(bounds);
    }

    public Rectangle getFinalBounds(GateEditPart self) {
        Rectangle bounds = self.getFigure().getBounds().getCopy();
        return this.getLogicalTransformedRectangle(bounds);
    }

    public Set<AbstractNodeEvent> getAbstractNodeEvent() {
        List editParts = this.getEditParts();
        if (editParts.isEmpty()) {
            return Collections.emptySet();
        }
        HashSet<AbstractNodeEvent> result = new HashSet<AbstractNodeEvent>();
        for (IGraphicalEditPart part : editParts) {
            Option execution = ISequenceElementAccessor.getAbstractNodeEvent((View)part.getNotationView());
            if (!execution.some()) continue;
            result.add((AbstractNodeEvent)execution.get());
        }
        return result;
    }

    public Set<Execution> getExecutions() {
        List editParts = this.getEditParts();
        if (editParts.isEmpty()) {
            return Collections.emptySet();
        }
        HashSet<Execution> result = new HashSet<Execution>();
        for (IGraphicalEditPart part : editParts) {
            Option execution = ISequenceElementAccessor.getExecution((View)part.getNotationView());
            if (!execution.some()) continue;
            result.add((Execution)execution.get());
        }
        return result;
    }

    public Set<ISequenceEvent> getISequenceEvents() {
        List editParts = this.getEditParts();
        if (editParts.isEmpty()) {
            return Collections.emptySet();
        }
        HashSet<ISequenceEvent> result = new HashSet<ISequenceEvent>();
        for (IGraphicalEditPart part : editParts) {
            Option ise = ISequenceElementAccessor.getISequenceEvent((View)part.getNotationView());
            if (!ise.some()) continue;
            result.add((ISequenceEvent)ise.get());
        }
        return result;
    }

    public List<InstanceRole> getInstanceRoles() {
        List editParts = this.getEditParts();
        if (editParts.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<InstanceRole> instanceRoles = new ArrayList<InstanceRole>();
        for (IGraphicalEditPart part : editParts) {
            Option instanceRole = ISequenceElementAccessor.getInstanceRole((View)part.getNotationView());
            if (!instanceRole.some()) continue;
            instanceRoles.add((InstanceRole)instanceRole.get());
        }
        return instanceRoles;
    }

    public boolean isExecutionMovedIndirectly() {
        Map extData = this.request.getExtendedData();
        if (this.request instanceof ChangeBoundsRequest && extData != null && extData.get(IS_MOVED_BY_PARENT_EXECUTION) instanceof Boolean) {
            Boolean value = (Boolean)extData.get(IS_MOVED_BY_PARENT_EXECUTION);
            return value;
        }
        return false;
    }

    public boolean isCreateMessageCreation() {
        return this.isSequenceMessageCreation((Predicate<Object>)Predicates.instanceOf(CreationMessageMapping.class));
    }

    public boolean isDestroyMessageCreation() {
        return this.isSequenceMessageCreation((Predicate<Object>)Predicates.instanceOf(DestructionMessageMapping.class));
    }

    public boolean isStandardMessageCreation() {
        return this.isSequenceMessageCreation((Predicate<Object>)Predicates.instanceOf(BasicMessageMapping.class));
    }

    public boolean isSequenceMessageCreation() {
        return this.isSequenceMessageCreation(null);
    }

    private boolean isSequenceMessageCreation(Predicate<Object> expectedMessageCreationToolMappingTypes) {
        boolean result = false;
        if (!this.isNoteAttachmentCreationRequest() && this.request instanceof CreateConnectionRequest) {
            CreateConnectionRequest createRequest = (CreateConnectionRequest)this.request;
            if (!(this.request instanceof CreateUnspecifiedTypeConnectionRequest) && createRequest.getNewObject() instanceof MessageCreationTool) {
                if (expectedMessageCreationToolMappingTypes != null) {
                    MessageCreationTool messageCreationTool = (MessageCreationTool)createRequest.getNewObject();
                    result = Iterables.any((Iterable)messageCreationTool.getEdgeMappings(), expectedMessageCreationToolMappingTypes);
                } else {
                    result = true;
                }
            }
        }
        return result;
    }

    public boolean isDirectedByMessage() {
        Object object = this.request.getExtendedData().get("org.eclipse.sirius.sequence.resize.execution.from.bendpoint.request");
        return object instanceof Boolean && Boolean.TRUE.equals(object);
    }

    public Optional<Integer> getObliqueMoveType() {
        Object object = this.request.getExtendedData().get("org.eclipse.sirius.sequence.resize.execution.from.bendpoint.request.oblique.move.type");
        if (object instanceof Integer) {
            Integer i = (Integer)object;
            return Optional.ofNullable(i);
        }
        return Optional.empty();
    }

    public Map getExtendedData() {
        return this.request.getExtendedData();
    }
}

