/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.bnd.ui.dnd;

import aQute.bnd.service.RepositoryPlugin;
import java.util.Objects;
import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.pde.bnd.ui.model.repo.RepositoryBundle;
import org.eclipse.pde.bnd.ui.model.repo.RepositoryBundleVersion;
import org.eclipse.pde.bnd.ui.model.repo.RepositoryResourceElement;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.osgi.resource.Resource;

public abstract class GAVDropTargetListener
implements DropTargetListener {
    private volatile boolean alternateSyntaxEnabled = false;
    private final TextTransfer textTransfer = TextTransfer.getInstance();
    private final LocalSelectionTransfer localSelectionTransfer = LocalSelectionTransfer.getTransfer();
    private final StyledText styledText;

    public GAVDropTargetListener(StyledText styledText) {
        this.styledText = Objects.requireNonNull(styledText);
        this.addAlternateSyntaxKeyListener((Control)this.styledText);
    }

    abstract void format(FormatEvent var1);

    public StyledText getStyledText() {
        return this.styledText;
    }

    abstract boolean hasAlternateSyntax();

    public final boolean isAlternateSyntaxEnabled() {
        return this.alternateSyntaxEnabled;
    }

    public void drop(DropTargetEvent event) {
        if (this.textTransfer.isSupportedType(event.currentDataType)) {
            this.styledText.invokeAction(0x1000008);
            ISelection selection = this.localSelectionTransfer.getSelection();
            for (Object item : (IStructuredSelection)selection) {
                if (item instanceof RepositoryBundle) {
                    RepositoryBundle rb = (RepositoryBundle)item;
                    this.format(new FormatEvent(rb.getResource(), rb.getRepo(), true, this.isAlternateSyntaxEnabled()));
                    break;
                }
                if (item instanceof RepositoryBundleVersion) {
                    RepositoryBundleVersion rbv = (RepositoryBundleVersion)item;
                    this.format(new FormatEvent(rbv.getResource(), rbv.getRepo(), false, this.isAlternateSyntaxEnabled()));
                    break;
                }
                if (!(item instanceof RepositoryResourceElement)) continue;
                RepositoryResourceElement rbe = (RepositoryResourceElement)item;
                RepositoryBundleVersion rbv = rbe.getRepositoryBundleVersion();
                this.format(new FormatEvent(rbv.getResource(), rbv.getRepo(), true, this.isAlternateSyntaxEnabled()));
                break;
            }
        }
    }

    public void dragEnter(DropTargetEvent event) {
        if (event.detail == 16) {
            event.detail = (event.operations & 1) != 0 ? 1 : 0;
        }
    }

    public void dragLeave(DropTargetEvent event) {
    }

    public void dragOperationChanged(DropTargetEvent event) {
    }

    public void dragOver(DropTargetEvent event) {
    }

    public void dropAccept(DropTargetEvent event) {
    }

    public static String indent(boolean tabs, int size) {
        return new String(new char[size]).replace("\u0000", tabs ? "\t" : " ");
    }

    private void addAlternateSyntaxKeyListener(Control control) {
        if (!this.hasAlternateSyntax()) {
            return;
        }
        Display display = control.getDisplay();
        display.addFilter(1, event -> {
            if (event.keyCode == 65536) {
                this.alternateSyntaxEnabled = true;
            }
        });
        display.addFilter(2, event -> {
            if (event.keyCode == 65536) {
                this.alternateSyntaxEnabled = false;
            }
        });
    }

    public class FormatEvent {
        private final Resource resource;
        private final RepositoryPlugin repositoryPlugin;
        private final boolean noVersion;
        private final boolean useAlternateSyntax;

        public FormatEvent(Resource resource, RepositoryPlugin repositoryPlugin, boolean noVersion, boolean useAlternateSyntax) {
            this.resource = resource;
            this.repositoryPlugin = repositoryPlugin;
            this.noVersion = noVersion;
            this.useAlternateSyntax = useAlternateSyntax;
        }

        public Resource getResource() {
            return this.resource;
        }

        public RepositoryPlugin getRepositoryPlugin() {
            return this.repositoryPlugin;
        }

        public boolean isNoVersion() {
            return this.noVersion;
        }

        public boolean useAlternateSyntax() {
            return this.useAlternateSyntax;
        }

        public String getLineAtInsertionPoint() {
            return GAVDropTargetListener.this.styledText.getLine(GAVDropTargetListener.this.styledText.getLineAtOffset(GAVDropTargetListener.this.styledText.getCaretOffset()));
        }

        public String getIndentPrefix() {
            return GAVDropTargetListener.this.styledText.getLine(GAVDropTargetListener.this.styledText.getLineAtOffset(GAVDropTargetListener.this.styledText.getCaretOffset())).split("\\S", 2)[0];
        }
    }
}

