/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.emf.core.util;

import java.lang.ref.WeakReference;
import java.util.HashSet;
import java.util.Map;
import java.util.WeakHashMap;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gmf.runtime.emf.core.internal.util.MetamodelManager;
import org.eclipse.gmf.runtime.emf.core.util.Util;

public class PackageUtil {
    private static final Map NAME_ATTRIBUTES = new WeakHashMap();
    private static final Map QNAME_ATTRIBUTES = new WeakHashMap();

    public static String getID(ENamedElement element) {
        return MetamodelManager.getID(element);
    }

    public static ENamedElement getElement(String id) {
        return MetamodelManager.getElement(id);
    }

    public static String getLocalizedName(ENamedElement element) {
        return MetamodelManager.getLocalName(element);
    }

    public static String getDisplayName(ENamedElement element) {
        return MetamodelManager.getDisplayName(element);
    }

    public static boolean canContain(EClass class1, EClass class2, boolean recursive) {
        return Util.canContain(class1, class2, recursive ? new HashSet() : null);
    }

    public static boolean canContain(EClass class1, EReference reference, EClass class2, boolean recursive) {
        EClass eType;
        if (reference.isContainment() && class1.getEAllReferences().contains((Object)reference) && ((eType = (EClass)reference.getEType()).equals(class2) || eType.isSuperTypeOf(class2))) {
            return true;
        }
        return recursive && reference.isContainment() && PackageUtil.canContain(eType = (EClass)reference.getEType(), class2, true);
    }

    public static boolean canReference(EClass class1, EClass class2) {
        for (EReference reference : class1.getEAllReferences()) {
            EClass eType;
            if (reference.isContainment() || !(eType = (EClass)reference.getEType()).equals(class2) && !eType.isSuperTypeOf(class2)) continue;
            return true;
        }
        return false;
    }

    public static boolean canReference(EClass class1, EReference reference, EClass class2) {
        EClass eType;
        return !reference.isContainment() && class1.getEAllReferences().contains((Object)reference) && ((eType = (EClass)reference.getEType()).equals(class2) || eType.isSuperTypeOf(class2));
    }

    public static EReference findFeature(EClass container, EClass eClass) {
        for (EReference reference : container.getEAllReferences()) {
            if (!PackageUtil.canContain(container, reference, eClass, false)) continue;
            return reference;
        }
        return null;
    }

    public static EAttribute getNameAttribute(EClass eClass) {
        EAttribute nameAttribute = null;
        WeakReference ref = (WeakReference)NAME_ATTRIBUTES.get(eClass);
        if (ref != null) {
            nameAttribute = (EAttribute)ref.get();
        } else {
            EClassifier type;
            EStructuralFeature feature = eClass.getEStructuralFeature("name");
            if (feature != null && feature instanceof EAttribute && (type = feature.getEType()) != null && type.getInstanceClass() == String.class) {
                nameAttribute = (EAttribute)feature;
            }
            NAME_ATTRIBUTES.put(eClass, new WeakReference<EAttribute>(nameAttribute));
        }
        return nameAttribute;
    }

    public static EAttribute getQualifiedNameAttribute(EClass eClass) {
        EAttribute nameAttribute = null;
        WeakReference ref = (WeakReference)QNAME_ATTRIBUTES.get(eClass);
        if (ref != null) {
            nameAttribute = (EAttribute)ref.get();
        } else {
            EStructuralFeature feature = eClass.getEStructuralFeature("qualifiedName");
            if (feature != null && feature instanceof EAttribute && feature.getEType().getInstanceClass() == String.class) {
                nameAttribute = (EAttribute)feature;
            }
            QNAME_ATTRIBUTES.put(eClass, new WeakReference<EAttribute>(nameAttribute));
        }
        return nameAttribute;
    }

    private PackageUtil() {
    }
}

