/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.ui;

import org.eclipse.jface.dialogs.DialogTray;
import org.eclipse.jface.dialogs.IPageChangedListener;
import org.eclipse.jface.dialogs.PageChangedEvent;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.oomph.internal.ui.AccessUtil;
import org.eclipse.oomph.ui.HelpSupport;
import org.eclipse.oomph.ui.OomphDialog;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Widget;

public class OomphWizardDialog
extends WizardDialog
implements HelpSupport.HelpProvider {
    private HelpSupport helpSupport;
    private IPageChangedListener pageChangedListener;

    public OomphWizardDialog(Shell parentShell, IWizard wizard, boolean helpAvailable) {
        super(parentShell, wizard);
        if (helpAvailable) {
            this.helpSupport = new HelpSupport((TitleAreaDialog)this){

                @Override
                protected void handleInactivity(Display display, boolean inactive) {
                    OomphWizardDialog.this.handleInactivity(display, inactive);
                }
            };
            this.pageChangedListener = new IPageChangedListener(){

                public void pageChanged(PageChangedEvent event) {
                    if (OomphWizardDialog.this.helpSupport != null) {
                        OomphWizardDialog.this.helpSupport.updateHelp();
                    }
                }
            };
            this.addPageChangedListener(this.pageChangedListener);
        }
    }

    public final HelpSupport getHelpSupport() {
        return this.helpSupport;
    }

    @Override
    public String getHelpPath() {
        HelpSupport.HelpProvider helpProvider;
        String helpPath;
        IWizardPage page = this.getCurrentPage();
        if (page instanceof HelpSupport.HelpProvider && (helpPath = (helpProvider = (HelpSupport.HelpProvider)page).getHelpPath()) != null) {
            return helpPath;
        }
        return null;
    }

    public boolean close() {
        if (this.helpSupport != null) {
            this.helpSupport.dispose();
            this.helpSupport = null;
        }
        return super.close();
    }

    public void openTray(DialogTray tray) throws IllegalStateException, UnsupportedOperationException {
        super.openTray(tray);
        OomphDialog.hookTray((TrayDialog)this);
    }

    protected Control createHelpControl(Composite parent) {
        ToolBar toolBar = (ToolBar)super.createHelpControl(parent);
        if (this.helpSupport != null) {
            ToolItem helpButton = toolBar.getItems()[0];
            AccessUtil.setKey((Widget)helpButton, "help");
            this.helpSupport.hook(helpButton);
        }
        this.createToolItemsForToolBar(toolBar);
        return toolBar;
    }

    protected void createToolItemsForToolBar(ToolBar toolBar) {
    }

    protected Control createContents(Composite parent) {
        Control contents = super.createContents(parent);
        OomphDialog.fixTitleImageLayout((TitleAreaDialog)this);
        return contents;
    }

    protected void handleInactivity(Display display, boolean inactive) {
    }

    public void setTitleImage(Image newTitleImage) {
        super.setTitleImage(newTitleImage);
        OomphDialog.fixTitleImageLayout((TitleAreaDialog)this);
    }

    public int openInBackground() {
        this.create();
        this.constrainShellSize();
        return this.getReturnCode();
    }
}

