/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.diagram.ui.geoshapes.internal.draw2d.figures;

import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.geometry.PrecisionPoint;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gmf.runtime.diagram.ui.geoshapes.internal.draw2d.figures.GeoShapeFigure;
import org.eclipse.gmf.runtime.draw2d.ui.figures.IOvalAnchorableFigure;
import org.eclipse.gmf.runtime.gef.ui.figures.SlidableOvalAnchor;
import org.eclipse.swt.graphics.Path;

public class GeoShapeEllipseFigure
extends GeoShapeFigure
implements IOvalAnchorableFigure {
    public GeoShapeEllipseFigure(int width, int height, int spacing) {
        super(width, height, spacing);
    }

    protected void paintFigure(Graphics g) {
        Rectangle r = this.getOvalBounds().getCopy();
        r.shrink(this.getLineWidth() / 2, this.getLineWidth() / 2);
        g.pushState();
        this.applyTransparency(g);
        if (!this.isUsingGradient()) {
            g.fillOval(r);
        } else {
            this.fillGradient(g);
        }
        g.popState();
        g.setLineStyle(this.getLineStyle());
        g.setLineWidth(this.getLineWidth());
        g.drawOval(r);
    }

    public Rectangle getOvalBounds() {
        Rectangle r = this.getBounds();
        Rectangle ovalRect = new Rectangle(r);
        ovalRect.setSize(r.width - 1, r.height - 1);
        return ovalRect;
    }

    protected ConnectionAnchor createAnchor(PrecisionPoint p) {
        if (p == null) {
            return this.createDefaultAnchor();
        }
        return new SlidableOvalAnchor((IOvalAnchorableFigure)this, p);
    }

    protected ConnectionAnchor createDefaultAnchor() {
        return new SlidableOvalAnchor((IOvalAnchorableFigure)this);
    }

    protected Path getPath() {
        Path path = new Path(null);
        Rectangle r = this.getOvalBounds().getCopy();
        r.shrink(this.getLineWidth() / 2, this.getLineWidth() / 2);
        path.addArc((float)r.x, (float)r.y, (float)r.width, (float)r.height, 0.0f, 360.0f);
        return path;
    }
}

