/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.tools.api.format;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.sirius.diagram.ContainerStyle;
import org.eclipse.sirius.diagram.DDiagramElementContainer;
import org.eclipse.sirius.diagram.DEdge;
import org.eclipse.sirius.diagram.DNode;
import org.eclipse.sirius.diagram.DNodeListElement;
import org.eclipse.sirius.diagram.EdgeStyle;
import org.eclipse.sirius.diagram.NodeStyle;
import org.eclipse.sirius.tools.internal.SiriusCopierHelper;
import org.eclipse.sirius.viewpoint.Customizable;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;
import org.eclipse.sirius.viewpoint.Style;
import org.eclipse.sirius.viewpoint.ViewpointPackage;

public interface SiriusStyleApplicator {
    default public void applySiriusStyle(DSemanticDecorator semanticDecorator, Style siriusStyle) {
        Style copyOfSiriusStyle = (Style)SiriusCopierHelper.copyWithNoUidDuplication((EObject)siriusStyle);
        if ((semanticDecorator instanceof DNode || semanticDecorator instanceof DNodeListElement) && copyOfSiriusStyle instanceof NodeStyle) {
            if (semanticDecorator instanceof DNode) {
                this.computeCustomFeatures((Style)((DNode)semanticDecorator).getOwnedStyle(), copyOfSiriusStyle);
                ((DNode)semanticDecorator).setOwnedStyle((NodeStyle)copyOfSiriusStyle);
            } else {
                this.computeCustomFeatures((Style)((DNodeListElement)semanticDecorator).getOwnedStyle(), copyOfSiriusStyle);
                ((DNodeListElement)semanticDecorator).setOwnedStyle((NodeStyle)copyOfSiriusStyle);
            }
        } else if (semanticDecorator instanceof DDiagramElementContainer && copyOfSiriusStyle instanceof ContainerStyle) {
            if (((DDiagramElementContainer)semanticDecorator).getOwnedStyle() != null) {
                this.computeCustomFeatures((Style)((DDiagramElementContainer)semanticDecorator).getOwnedStyle(), copyOfSiriusStyle);
            }
            ((DDiagramElementContainer)semanticDecorator).setOwnedStyle((ContainerStyle)copyOfSiriusStyle);
        } else if (semanticDecorator instanceof DEdge && copyOfSiriusStyle instanceof EdgeStyle) {
            this.computeCustomFeatures((Style)((DEdge)semanticDecorator).getOwnedStyle(), copyOfSiriusStyle);
            ((DEdge)semanticDecorator).setOwnedStyle((EdgeStyle)copyOfSiriusStyle);
        } else {
            this.applySiriusStyleAtBest(semanticDecorator, siriusStyle);
        }
    }

    private void applySiriusStyleAtBest(DSemanticDecorator targetSemanticDecorator, Style siriusSourceStyle) {
        if (!(siriusSourceStyle instanceof EdgeStyle)) {
            for (Customizable targetStyle : this.getStyle(targetSemanticDecorator)) {
                this.addNewValueAndSetCustomFeaturesAtBest((Customizable)siriusSourceStyle, targetStyle);
            }
        }
    }

    private void addNewValueAndSetCustomFeaturesAtBest(Customizable sourceStyle, Customizable targetStyleToChange) {
        EAttribute[] exceptionAttributes = new EAttribute[]{ViewpointPackage.Literals.IDENTIFIED_ELEMENT__UID, ViewpointPackage.Literals.CUSTOMIZABLE__CUSTOM_FEATURES, ViewpointPackage.Literals.BASIC_LABEL_STYLE__SHOW_ICON, ViewpointPackage.Literals.BASIC_LABEL_STYLE__ICON_PATH};
        for (EAttribute targetStyleAttribute : targetStyleToChange.eClass().getEAllAttributes()) {
            EAttribute sourceStyleAttribute;
            if (Arrays.asList(exceptionAttributes).contains(targetStyleAttribute) || (sourceStyleAttribute = this.getCorrespondingEAttribute(targetStyleAttribute, sourceStyle)) == null || targetStyleToChange.eGet((EStructuralFeature)targetStyleAttribute).equals(sourceStyle.eGet((EStructuralFeature)sourceStyleAttribute))) continue;
            targetStyleToChange.getCustomFeatures().add((Object)targetStyleAttribute.getName());
            targetStyleToChange.eSet((EStructuralFeature)targetStyleAttribute, sourceStyle.eGet((EStructuralFeature)sourceStyleAttribute));
        }
    }

    private List<Customizable> getStyle(DSemanticDecorator semanticDecorator) {
        DEdge edge;
        EdgeStyle ownedStyle;
        ArrayList<Customizable> styles = new ArrayList<Customizable>();
        if (semanticDecorator instanceof DNode) {
            DNode node = (DNode)semanticDecorator;
            styles.add((Customizable)node.getOwnedStyle());
        } else if (semanticDecorator instanceof DNodeListElement) {
            DNodeListElement listElement = (DNodeListElement)semanticDecorator;
            styles.add((Customizable)listElement.getOwnedStyle());
        } else if (semanticDecorator instanceof DDiagramElementContainer) {
            DDiagramElementContainer container = (DDiagramElementContainer)semanticDecorator;
            styles.add((Customizable)container.getOwnedStyle());
        } else if (semanticDecorator instanceof DEdge && (ownedStyle = (edge = (DEdge)semanticDecorator).getOwnedStyle()) instanceof EdgeStyle) {
            EdgeStyle edgeStyle = ownedStyle;
            Arrays.asList(edgeStyle.getCenterLabelStyle(), edgeStyle.getBeginLabelStyle(), edgeStyle.getEndLabelStyle()).stream().filter(Objects::nonNull).forEach(styles::add);
        }
        return styles;
    }

    private void computeCustomFeatures(Style oldStyle, Style newStyle) {
        EAttribute[] exceptionAttributes = new EAttribute[]{ViewpointPackage.Literals.IDENTIFIED_ELEMENT__UID, ViewpointPackage.Literals.CUSTOMIZABLE__CUSTOM_FEATURES};
        for (EAttribute attribute : newStyle.eClass().getEAllAttributes()) {
            EAttribute attributeOfOldStyle;
            if (Arrays.asList(exceptionAttributes).contains(attribute) || (attributeOfOldStyle = this.getCorrespondingEAttribute(attribute, (Customizable)oldStyle)) == null) continue;
            if (newStyle.eIsSet((EStructuralFeature)attribute)) {
                if (newStyle.eGet((EStructuralFeature)attribute).equals(oldStyle.eGet((EStructuralFeature)attributeOfOldStyle))) continue;
                newStyle.getCustomFeatures().add((Object)attributeOfOldStyle.getName());
                continue;
            }
            if (!oldStyle.eIsSet((EStructuralFeature)attributeOfOldStyle)) continue;
            newStyle.getCustomFeatures().add((Object)attributeOfOldStyle.getName());
        }
    }

    private EAttribute getCorrespondingEAttribute(EAttribute attribute, Customizable style) {
        EAttribute result = null;
        if (style.eClass().getFeatureID((EStructuralFeature)attribute) != -1) {
            result = attribute;
        } else {
            EStructuralFeature structuralFeature = style.eClass().getEStructuralFeature(attribute.getName());
            if (structuralFeature instanceof EAttribute) {
                result = (EAttribute)structuralFeature;
            } else if ("color".equals(attribute.getName())) {
                structuralFeature = style.eClass().getEStructuralFeature("backgroundColor");
                if (structuralFeature instanceof EAttribute) {
                    result = (EAttribute)structuralFeature;
                }
            } else if ("backgroundColor".equals(attribute.getName()) || "foregroundColor".equals(attribute.getName())) {
                structuralFeature = style.eClass().getEStructuralFeature("color");
                if (structuralFeature instanceof EAttribute) {
                    result = (EAttribute)structuralFeature;
                }
            } else if ("width".equals(attribute.getName())) {
                structuralFeature = style.eClass().getEStructuralFeature("horizontalDiameter");
                if (structuralFeature instanceof EAttribute) {
                    result = (EAttribute)structuralFeature;
                }
            } else if ("horizontalDiameter".equals(attribute.getName())) {
                structuralFeature = style.eClass().getEStructuralFeature("width");
                if (structuralFeature instanceof EAttribute) {
                    result = (EAttribute)structuralFeature;
                }
            } else if ("height".equals(attribute.getName())) {
                structuralFeature = style.eClass().getEStructuralFeature("verticalDiameter");
                if (structuralFeature instanceof EAttribute) {
                    result = (EAttribute)structuralFeature;
                }
            } else if ("verticalDiameter".equals(attribute.getName()) && (structuralFeature = style.eClass().getEStructuralFeature("height")) instanceof EAttribute) {
                result = (EAttribute)structuralFeature;
            }
        }
        return result;
    }
}

