/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.tools.internal.ui;

import java.text.MessageFormat;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.sirius.tools.api.Messages;
import org.eclipse.sirius.tools.api.SiriusPlugin;
import org.eclipse.sirius.tools.api.ui.IExternalJavaAction;

public class ExternalJavaActionDescriptor {
    public static final String CLASS_ATTRIBUTE = "actionClass";
    private static final String ID_ATTRIBUTE = "id";
    private final String actionClass;
    private IConfigurationElement element;

    public ExternalJavaActionDescriptor(IConfigurationElement element) {
        this.element = element;
        this.actionClass = element.getAttribute(CLASS_ATTRIBUTE);
    }

    public IExternalJavaAction createJavaActionMenuItem() {
        try {
            return (IExternalJavaAction)this.element.createExecutableExtension(CLASS_ATTRIBUTE);
        }
        catch (CoreException e) {
            SiriusPlugin.getDefault().error(MessageFormat.format(Messages.ExternalJavaActionDescriptor_actionCreationErrorMsg, this.element.getAttribute(CLASS_ATTRIBUTE)), e);
        }
        catch (ClassCastException e) {
            SiriusPlugin.getDefault().error(MessageFormat.format(Messages.ExternalJavaActionDescriptor_actionCreationErrorMsg, this.element.getAttribute(CLASS_ATTRIBUTE)), e);
        }
        return null;
    }

    public String getActionClass() {
        return this.actionClass;
    }

    public String getId() {
        return this.element.getAttribute(ID_ATTRIBUTE);
    }
}

