/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.signal;

import java.io.PrintStream;
import java.util.Arrays;
import java.util.HashMap;
import org.eclipse.net4j.signal.ISignalProtocol;
import org.eclipse.net4j.signal.Signal;
import org.eclipse.net4j.signal.SignalFinishedEvent;
import org.eclipse.net4j.util.collection.HashBag;
import org.eclipse.net4j.util.event.IEvent;
import org.eclipse.net4j.util.event.IListener;

public final class SignalCounter
implements IListener {
    private static final boolean fullyQualifiedNames = Boolean.getBoolean("org.eclipse.net4j.signal.SignalCounter.fullyQualifiedNames");
    private HashBag<Class<? extends Signal>> signals = new HashBag();
    private final ISignalProtocol<?> protocol;

    public SignalCounter() {
        this.protocol = null;
    }

    public SignalCounter(ISignalProtocol<?> protocol) {
        this.protocol = protocol;
        if (protocol != null) {
            protocol.addListener(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HashBag<Class<? extends Signal>> getSignals() {
        HashBag<Class<? extends Signal>> hashBag = this.signals;
        synchronized (hashBag) {
            return new HashBag(this.signals);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getCountForSignalTypes() {
        HashBag<Class<? extends Signal>> hashBag = this.signals;
        synchronized (hashBag) {
            return this.signals.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getCountFor(Class<? extends Signal> signal) {
        HashBag<Class<? extends Signal>> hashBag = this.signals;
        synchronized (hashBag) {
            return this.signals.getCounterFor(signal);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int removeCountFor(Class<? extends Signal> signal) {
        HashBag<Class<? extends Signal>> hashBag = this.signals;
        synchronized (hashBag) {
            return this.signals.removeCounterFor(signal);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearCounts() {
        HashBag<Class<? extends Signal>> hashBag = this.signals;
        synchronized (hashBag) {
            this.signals.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dump(PrintStream out, boolean clearCountsWhenDone) {
        HashBag<Class<? extends Signal>> hashBag = this.signals;
        synchronized (hashBag) {
            HashMap<String, Class> signalTypes = new HashMap<String, Class>();
            for (Class signalType : this.signals) {
                String name = fullyQualifiedNames ? signalType.getName() : signalType.getSimpleName();
                signalTypes.put(name, signalType);
            }
            Object[] names = signalTypes.keySet().toArray(new String[signalTypes.size()]);
            Arrays.sort(names);
            Object[] objectArray = names;
            int n = names.length;
            int n2 = 0;
            while (n2 < n) {
                Object name = objectArray[n2];
                Class signalType = (Class)signalTypes.get(name);
                out.println(String.valueOf(name) + " = " + this.signals.getCounterFor((Object)signalType));
                ++n2;
            }
            if (clearCountsWhenDone) {
                this.clearCounts();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyEvent(IEvent event) {
        if (event instanceof SignalFinishedEvent) {
            SignalFinishedEvent e = (SignalFinishedEvent)event;
            HashBag<Class<? extends Signal>> hashBag = this.signals;
            synchronized (hashBag) {
                this.signals.add(e.getSignal().getClass());
            }
        }
    }

    public void dispose() {
        if (this.protocol != null) {
            this.protocol.removeListener(this);
        }
    }
}

