/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.diagram.ide.ui.sirius.internal.tools.actions;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.emf.compare.diagram.ide.ui.internal.contentmergeviewer.diagram.DiagramContentMergeViewer;
import org.eclipse.emf.compare.diagram.ide.ui.sirius.CompareDiagramIDEUISiriusPlugin;
import org.eclipse.emf.compare.diagram.ide.ui.sirius.internal.tools.actions.ExportComparisonAction;
import org.eclipse.emf.compare.diagram.ide.ui.sirius.internal.tools.dialog.ExportComparisonDialog;
import org.eclipse.gef.RootEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramRootEditPart;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.sirius.ui.tools.api.actions.export.SizeTooLargeException;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class SiriusComparisonAsImageFileAction
extends Action {
    private DiagramContentMergeViewer contentMergeViewer;
    private DiagramEditPart leftDiagramEditPart;
    private DiagramEditPart rightDiagramEditPart;

    public SiriusComparisonAsImageFileAction(DiagramContentMergeViewer mergeViewer) {
        super("Export diagram comparison as image", CompareDiagramIDEUISiriusPlugin.getImageDescriptor("icons/screenshot.gif"));
        this.contentMergeViewer = mergeViewer;
    }

    public void run() {
        this.setEditParts();
        this.exportRepresentation();
    }

    private void setEditParts() {
        RootEditPart leftRootEP = this.contentMergeViewer.getLeftMergeViewer().getGraphicalViewer().getRootEditPart();
        RootEditPart rightRootEP = this.contentMergeViewer.getRightMergeViewer().getGraphicalViewer().getRootEditPart();
        if (leftRootEP instanceof DiagramRootEditPart && rightRootEP instanceof DiagramRootEditPart) {
            DiagramRootEditPart leftRootEditPart = (DiagramRootEditPart)leftRootEP;
            DiagramRootEditPart rightRootEditPart = (DiagramRootEditPart)rightRootEP;
            if (leftRootEditPart.getContents() instanceof DiagramEditPart && rightRootEditPart.getContents() instanceof DiagramEditPart) {
                this.leftDiagramEditPart = (DiagramEditPart)leftRootEditPart.getContents();
                this.rightDiagramEditPart = (DiagramEditPart)rightRootEditPart.getContents();
            }
        }
    }

    protected void exportRepresentation() {
        Shell shell = Display.getCurrent().getActiveShell();
        ExportComparisonDialog dialog = new ExportComparisonDialog(shell);
        if (dialog.open() == 0) {
            ExportComparisonAction exportAction = new ExportComparisonAction(dialog.getOutputPath(), dialog.getImageFormat(), this.leftDiagramEditPart, this.rightDiagramEditPart, this.contentMergeViewer.getDecoratorsManager().getAllDecorators());
            try (ProgressMonitorDialog pmd = new ProgressMonitorDialog(shell);){
                try {
                    pmd.run(false, false, (IRunnableWithProgress)exportAction);
                }
                catch (InvocationTargetException e) {
                    Throwable cause = e.getCause();
                    if (cause instanceof OutOfMemoryError) {
                        MessageDialog.openError((Shell)shell, (String)"Not enough memory available to create image files", (String)cause.getMessage());
                    } else if (cause instanceof SizeTooLargeException) {
                        MessageDialog.openError((Shell)shell, (String)"Image export impossible", (String)cause.getMessage());
                        CompareDiagramIDEUISiriusPlugin.getDefault().log(cause);
                    } else {
                        MessageDialog.openError((Shell)shell, (String)"Error", (String)cause.getMessage());
                    }
                    pmd.close();
                }
                catch (InterruptedException e) {
                    MessageDialog.openInformation((Shell)shell, (String)"Error", (String)e.getMessage());
                    pmd.close();
                }
            }
        } else {
            dialog.close();
        }
    }
}

