/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.core.ui.internal.components;

import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class TextComboBoxCellEditor
extends CellEditor {
    protected String[] items;
    protected CCombo combo;

    public TextComboBoxCellEditor(Composite parent, int style) {
        super(parent, style);
    }

    protected Control createControl(Composite parent) {
        this.combo = new CCombo(parent, this.getStyle());
        this.combo.setFont(parent.getFont());
        this.combo.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                TextComboBoxCellEditor.this.keyReleaseOccured(e);
            }
        });
        this.combo.addTraverseListener(e -> {
            if (e.detail == 2 || e.detail == 4) {
                e.doit = false;
            }
        });
        this.loadItems();
        return this.combo;
    }

    protected Object doGetValue() {
        Assert.isNotNull((Object)this.combo);
        return this.combo.getText();
    }

    protected void doSetFocus() {
        Assert.isNotNull((Object)this.combo);
        this.combo.setFocus();
    }

    protected void doSetValue(Object value) {
        Assert.isNotNull((Object)this.combo);
        this.combo.setText(String.valueOf(value));
    }

    public String[] getItems() {
        return this.items;
    }

    public void setItems(String[] items) {
        this.items = items;
        this.loadItems();
    }

    protected void loadItems() {
        if (this.combo != null && this.items != null) {
            this.combo.setItems(this.items);
        }
    }

    protected void keyReleaseOccured(KeyEvent keyEvent) {
        if (keyEvent.character == '\u001b') {
            this.fireCancelEditor();
        } else if (keyEvent.character == '\t' || keyEvent.character == '\r') {
            this.focusLost();
        }
    }
}

