/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jem.internal.beaninfo.core;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jem.internal.beaninfo.adapters.IReader;
import org.eclipse.jem.internal.beaninfo.core.BeaninfoEntry;
import org.eclipse.jem.internal.beaninfo.core.IBeaninfosDocEntry;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class SearchpathEntry
implements IBeaninfosDocEntry {
    static final String sSearchpath = "searchpath";
    static final String sPackage = "package";
    protected int kind = -1;
    protected IPath path;
    protected String packageName;
    protected boolean isExported;

    public static SearchpathEntry readEntry(IReader reader, Object element, IProject project, boolean beaninfoChild) {
        String packageName = reader.getAttribute(element, sPackage);
        if (beaninfoChild) {
            return new SearchpathEntry(packageName);
        }
        String elementKind = reader.getAttribute(element, "kind");
        String pathStr = reader.getAttribute(element, "path");
        int kind = BeaninfoEntry.kindFromString(elementKind);
        Path path = null;
        if (pathStr != null) {
            path = new Path(pathStr);
            if (kind != 4 && kind != 5 && !path.isAbsolute()) {
                path = project != null ? project.getFullPath().append((IPath)path) : path.makeAbsolute();
            }
        }
        boolean valid = true;
        switch (kind) {
            case 1: {
                valid = path != null && path.isAbsolute();
                break;
            }
            case 3: {
                if (path == null) {
                    valid = false;
                    break;
                }
                if (!path.isAbsolute()) break;
                String projSegment = path.segment(0);
                if (project != null && projSegment != null && projSegment.equals(project.getName())) break;
                kind = 2;
                break;
            }
            case 4: 
            case 5: {
                break;
            }
            default: {
                valid = false;
            }
        }
        if (valid) {
            return new SearchpathEntry(kind, (IPath)path, packageName);
        }
        return null;
    }

    public SearchpathEntry(int kind, IPath path, String packageName) {
        this.kind = kind;
        this.path = path;
        this.packageName = packageName;
    }

    public SearchpathEntry(String packageName) {
        this.packageName = packageName;
    }

    @Override
    public int getKind() {
        return this.kind;
    }

    @Override
    public IPath getPath() {
        return this.path;
    }

    public String getPackage() {
        return this.packageName;
    }

    @Override
    public Node writeEntry(Document doc, IProject project) {
        Element element = doc.createElement(sSearchpath);
        if (this.kind != -1) {
            element.setAttribute("kind", BeaninfoEntry.kindToString(this.kind));
            IPath tPath = this.path;
            if (this.kind != 4 && this.kind != 5 && tPath.isAbsolute()) {
                if (tPath.segment(0).equals(project.getFullPath().segment(0))) {
                    tPath = tPath.removeFirstSegments(1);
                    tPath = tPath.makeRelative();
                } else {
                    tPath = tPath.makeAbsolute();
                }
            }
            element.setAttribute("path", tPath.toString());
        }
        if (this.packageName != null) {
            element.setAttribute(sPackage, this.packageName);
        }
        return element;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof SearchpathEntry)) {
            return false;
        }
        SearchpathEntry otherEntry = (SearchpathEntry)other;
        if (this.kind != otherEntry.kind) {
            return false;
        }
        if (this.path == null ? otherEntry.path != null : !this.path.equals((Object)otherEntry.path)) {
            return false;
        }
        return !(this.packageName == null ? otherEntry.packageName != null : !this.packageName.equals(otherEntry.packageName));
    }

    public int hashCode() {
        int hashCode = this.kind;
        if (this.path != null) {
            hashCode ^= this.path.hashCode();
        }
        if (this.packageName != null) {
            hashCode ^= this.packageName.hashCode();
        }
        return hashCode;
    }
}

