/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsd.ui.internal.common.properties.sections;

import java.util.Map;
import org.apache.xerces.util.XMLChar;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.xsd.ui.internal.common.properties.sections.SchemaLocationSection;
import org.eclipse.wst.xsd.ui.internal.common.util.XSDDirectivesSchemaLocationUpdater;
import org.eclipse.wst.xsd.ui.internal.editor.XSDEditorPlugin;
import org.eclipse.wst.xsd.ui.internal.util.TypesHelper;
import org.eclipse.xsd.XSDImport;
import org.w3c.dom.Element;

public class XSDImportSection
extends SchemaLocationSection {
    protected Text namespaceText;
    protected Text prefixText;
    protected String oldPrefixValue;

    public void createContents(Composite parent) {
        this.composite = this.getWidgetFactory().createFlatFormComposite(parent);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginTop = 0;
        gridLayout.marginBottom = 0;
        gridLayout.numColumns = 3;
        this.composite.setLayout((Layout)gridLayout);
        GridData data = new GridData();
        CLabel namespaceLabel = this.getWidgetFactory().createCLabel(this.composite, XSDEditorPlugin.getXSDString("_UI_LABEL_NAMESPACE"));
        data.horizontalAlignment = 32;
        data.grabExcessHorizontalSpace = false;
        namespaceLabel.setLayoutData((Object)data);
        this.namespaceText = this.getWidgetFactory().createText(this.composite, "", 0);
        this.namespaceText.setEditable(false);
        data = new GridData();
        data.grabExcessHorizontalSpace = true;
        data.horizontalAlignment = 4;
        this.applyAllListeners((Control)this.namespaceText);
        this.namespaceText.setLayoutData((Object)data);
        data = new GridData();
        data.horizontalAlignment = 32;
        data.grabExcessHorizontalSpace = false;
        this.getWidgetFactory().createCLabel(this.composite, "");
        CLabel prefixLabel = this.getWidgetFactory().createCLabel(this.composite, XSDEditorPlugin.getXSDString("_UI_LABEL_PREFIX"));
        data = new GridData();
        data.horizontalAlignment = 32;
        data.grabExcessHorizontalSpace = false;
        prefixLabel.setLayoutData((Object)data);
        this.prefixText = this.getWidgetFactory().createText(this.composite, "", 0);
        this.prefixText.setEditable(true);
        this.applyAllListeners((Control)this.prefixText);
        data = new GridData();
        data.grabExcessHorizontalSpace = true;
        data.horizontalAlignment = 4;
        this.prefixText.setLayoutData((Object)data);
        data = new GridData();
        data.horizontalAlignment = 32;
        data.grabExcessHorizontalSpace = false;
        this.getWidgetFactory().createCLabel(this.composite, "");
        CLabel schemaLocationLabel = this.getWidgetFactory().createCLabel(this.composite, XSDEditorPlugin.getXSDString("_UI_LABEL_SCHEMA_LOCATION"));
        data = new GridData();
        data.horizontalAlignment = 32;
        data.grabExcessHorizontalSpace = false;
        schemaLocationLabel.setLayoutData((Object)data);
        this.schemaLocationText = this.getWidgetFactory().createText(this.composite, "", 0);
        this.schemaLocationText.setEditable(true);
        this.applyAllListeners((Control)this.schemaLocationText);
        data = new GridData();
        data.grabExcessHorizontalSpace = true;
        data.horizontalAlignment = 4;
        this.schemaLocationText.setLayoutData((Object)data);
        this.wizardButton = this.getWidgetFactory().createButton(this.composite, "", 0);
        this.wizardButton.setImage(XSDEditorPlugin.getXSDImage("icons/browsebutton.gif"));
        data = new GridData();
        data.horizontalAlignment = 32;
        data.grabExcessHorizontalSpace = false;
        this.wizardButton.setLayoutData((Object)data);
        this.wizardButton.addSelectionListener((SelectionListener)this);
        this.errorText = new StyledText(this.composite, 0x800000);
        this.errorText.setEditable(false);
        this.errorText.setEnabled(false);
        this.errorText.setText("");
        data = new GridData();
        data.horizontalAlignment = 4;
        data.horizontalSpan = 3;
        data.grabExcessHorizontalSpace = true;
        this.errorText.setLayoutData((Object)data);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.schemaLocationText, "org.eclipse.wst.xsd.ui.xsdup0370");
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.namespaceText, "org.eclipse.wst.xsd.ui.xsdup0380");
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.prefixText, "org.eclipse.wst.xsd.ui.xsdup0390");
    }

    public void refresh() {
        this.setListenerEnabled(false);
        this.errorText.setText("");
        Element element = null;
        if (this.input instanceof XSDImport) {
            element = ((XSDImport)this.input).getElement();
            String namespace = element.getAttribute("namespace");
            String schemaLocation = element.getAttribute("schemaLocation");
            TypesHelper helper = new TypesHelper(this.xsdSchema);
            String prefix = helper.getPrefix(element.getAttribute("namespace"), false);
            if (namespace == null) {
                namespace = "";
            }
            if (prefix == null) {
                prefix = "";
            }
            if (schemaLocation == null) {
                schemaLocation = "";
            }
            this.namespaceText.setText(namespace);
            this.prefixText.setText(prefix);
            this.schemaLocationText.setText(schemaLocation);
            this.oldPrefixValue = this.prefixText.getText();
        }
        this.setListenerEnabled(true);
    }

    public void widgetSelected(SelectionEvent event) {
        if (event.widget == this.wizardButton) {
            this.setListenerEnabled(false);
            XSDDirectivesSchemaLocationUpdater.updateSchemaLocation(this.xsdSchema, this.input, false);
            this.refresh();
            this.setListenerEnabled(true);
            this.prefixText.addListener(24, (Listener)this);
        }
    }

    public void doHandleEvent(Event event) {
        this.setErrorMessage(null);
        super.doHandleEvent(event);
        if (event.widget == this.prefixText) {
            String newPrefix = this.prefixText.getText();
            if (this.oldPrefixValue.equals(newPrefix) || !this.isValidSchemaLocation) {
                return;
            }
            Map map = this.xsdSchema.getQNamePrefixToNamespaceMap();
            String key = this.prefixText.getText();
            if (key.length() == 0) {
                key = null;
            }
            if (this.validatePrefix(newPrefix) && this.schemaLocationText.getText().trim().length() > 0) {
                if (map.containsKey(key)) {
                    this.setErrorMessage(XSDEditorPlugin.getXSDString("_ERROR_LABEL_PREFIX_EXISTS"));
                } else {
                    Element schemaElement = this.xsdSchema.getElement();
                    if (key != null) {
                        if (this.oldPrefixValue.length() == 0) {
                            schemaElement.removeAttribute("xmlns");
                        } else {
                            schemaElement.removeAttribute("xmlns:" + this.oldPrefixValue);
                        }
                        schemaElement.setAttribute("xmlns:" + newPrefix, this.namespaceText.getText());
                    } else {
                        schemaElement.removeAttribute("xmlns:" + this.oldPrefixValue);
                        schemaElement.setAttribute("xmlns", this.namespaceText.getText());
                    }
                    this.xsdSchema.updateElement();
                    this.setErrorMessage(null);
                    this.oldPrefixValue = newPrefix;
                }
            } else {
                this.setErrorMessage(XSDEditorPlugin.getXSDString("_ERROR_LABEL_INVALID_PREFIX"));
            }
        }
    }

    public void aboutToBeHidden() {
        this.setErrorMessage(null);
        super.aboutToBeHidden();
    }

    protected boolean validatePrefix(String prefix) {
        if (prefix.length() == 0) {
            return true;
        }
        return XMLChar.isValidNCName((String)prefix);
    }
}

