/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.core.s.widgetmap;

import java.nio.file.Path;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import org.eclipse.scout.sdk.core.builder.BuilderContext;
import org.eclipse.scout.sdk.core.builder.IBuilderContext;
import org.eclipse.scout.sdk.core.s.widgetmap.IdObjectTypeMap;
import org.eclipse.scout.sdk.core.s.widgetmap.IdObjectTypeMapUtils;
import org.eclipse.scout.sdk.core.s.widgetmap.Type;
import org.eclipse.scout.sdk.core.typescript.builder.ITypeScriptBuilderContext;
import org.eclipse.scout.sdk.core.typescript.builder.TypeScriptBuilderContext;
import org.eclipse.scout.sdk.core.typescript.builder.imports.IES6ImportCollector;
import org.eclipse.scout.sdk.core.typescript.generator.ITypeScriptElementGenerator;
import org.eclipse.scout.sdk.core.typescript.generator.field.FieldGenerator;
import org.eclipse.scout.sdk.core.typescript.generator.field.IFieldGenerator;
import org.eclipse.scout.sdk.core.typescript.generator.nodeelement.INodeElementGenerator;
import org.eclipse.scout.sdk.core.typescript.model.api.IDataType;
import org.eclipse.scout.sdk.core.typescript.model.api.IES6Class;
import org.eclipse.scout.sdk.core.typescript.model.api.IObjectLiteral;
import org.eclipse.scout.sdk.core.typescript.model.api.Modifier;
import org.eclipse.scout.sdk.core.util.Ensure;
import org.eclipse.scout.sdk.core.util.Strings;

public class WidgetMapCreateOperation {
    private IObjectLiteral m_literal;
    private IES6Class m_mainWidget;
    private String m_modelName;
    private boolean m_isPage;
    private List<CharSequence> m_classSources;
    private Map<String, CharSequence> m_declarationSources;
    private Collection<String> m_declarationsToRemove;
    private List<IES6ImportCollector.ES6ImportDescriptor> m_importsForModel;
    private List<IES6ImportCollector.ES6ImportDescriptor> m_importNamesForDeclarations;

    public void execute() {
        this.validateOperation();
        this.prepareOperation();
        this.executeOperation();
    }

    protected void validateOperation() {
        Ensure.notNull((Object)this.literal(), (CharSequence)"No object-literal provided.", (Object[])new Object[0]);
    }

    protected void prepareOperation() {
        this.setModelName(this.calculateModelName());
        this.setPage(this.calculatePage());
    }

    protected void executeOperation() {
        Stream generators;
        Set<String> expectedDeclarations;
        HashMap<String, String> declarations = new HashMap<String, String>();
        if (this.isPage()) {
            expectedDeclarations = Set.of("detailForm", "detailTable");
            Stream detailFormGenerator = IdObjectTypeMapUtils.createDetailFormGeneratorForPage(this.modelName(), this.literal()).map(gen -> {
                String detailForm = (String)gen.objectType().flatMap(Type::newClassName).orElseThrow();
                declarations.put("detailForm", detailForm);
                return Stream.concat(Stream.of(gen), IdObjectTypeMapUtils.collectAdditionalGenerators(gen));
            }).orElseGet(Stream::empty);
            Stream detailTableGenerator = IdObjectTypeMapUtils.createDetailTableGeneratorForPage(this.modelName(), this.literal()).map(gen -> {
                String detailPage = (String)gen.objectType().flatMap(Type::newClassName).orElseThrow();
                declarations.put("detailTable", detailPage);
                return Stream.concat(Stream.of(gen), IdObjectTypeMapUtils.collectAdditionalGenerators(gen));
            }).orElseGet(Stream::empty);
            generators = Stream.concat(detailFormGenerator, detailTableGenerator);
        } else {
            expectedDeclarations = Set.of("widgetMap");
            generators = IdObjectTypeMapUtils.createWidgetMapGenerator(this.modelName(), this.literal(), this.mainWidget()).map(gen -> {
                IdObjectTypeMap widgetMap = gen.map().orElseThrow();
                declarations.put("widgetMap", widgetMap.name());
                return Stream.concat(Stream.of(gen), IdObjectTypeMapUtils.collectAdditionalGenerators(gen));
            }).orElseGet(Stream::empty);
        }
        AbstractMap.SimpleEntry<Map<String, CharSequence>, List<IES6ImportCollector.ES6ImportDescriptor>> widgetMapSourcesAndImports = WidgetMapCreateOperation.executeGenerators(generators);
        this.setClassSources(new ArrayList<CharSequence>(widgetMapSourcesAndImports.getKey().values()));
        List<IES6ImportCollector.ES6ImportDescriptor> modelImports = widgetMapSourcesAndImports.getValue();
        this.setImportsForModel(modelImports);
        this.buildDeclarations(declarations, expectedDeclarations);
    }

    protected void buildDeclarations(Map<String, String> declarationInfo, Collection<String> expectedDeclarations) {
        Stream<IFieldGenerator> declarationGenerators = declarationInfo.entrySet().stream().map(e -> WidgetMapCreateOperation.createFieldDeclaration((String)e.getKey(), this.literal().spi().createDataType((String)e.getValue()).api()));
        AbstractMap.SimpleEntry<Map<String, CharSequence>, List<IES6ImportCollector.ES6ImportDescriptor>> declarationSourceAndImports = WidgetMapCreateOperation.executeGenerators(declarationGenerators);
        this.setDeclarationSources(declarationSourceAndImports.getKey());
        this.setImportNamesForDeclarations(declarationSourceAndImports.getValue());
        HashSet<String> declarationsToRemove = new HashSet<String>(expectedDeclarations);
        declarationsToRemove.removeAll(this.declarationSources().keySet());
        this.setDeclarationsToRemove(declarationsToRemove);
    }

    protected static AbstractMap.SimpleEntry<Map<String, CharSequence>, List<IES6ImportCollector.ES6ImportDescriptor>> executeGenerators(Stream<? extends INodeElementGenerator<?>> generators) {
        TypeScriptBuilderContext builderContext = new TypeScriptBuilderContext((IBuilderContext)new BuilderContext());
        LinkedHashMap declarationSources = new LinkedHashMap();
        LinkedHashSet imports = new LinkedHashSet();
        generators.forEach(g -> {
            AbstractMap.SimpleEntry<CharSequence, Collection<IES6ImportCollector.ES6ImportDescriptor>> sourceAndImports = WidgetMapCreateOperation.runGenerator(g, (ITypeScriptBuilderContext)builderContext);
            imports.addAll(sourceAndImports.getValue());
            declarationSources.put(g.elementName().orElse(null), sourceAndImports.getKey());
        });
        return new AbstractMap.SimpleEntry<Map<String, CharSequence>, List<IES6ImportCollector.ES6ImportDescriptor>>(declarationSources, new ArrayList(imports));
    }

    protected static AbstractMap.SimpleEntry<CharSequence, Collection<IES6ImportCollector.ES6ImportDescriptor>> runGenerator(ITypeScriptElementGenerator<?> generator, ITypeScriptBuilderContext context) {
        StringBuilder src = generator.toTypeScriptSource(context);
        return new AbstractMap.SimpleEntry<CharSequence, Collection<IES6ImportCollector.ES6ImportDescriptor>>(src, context.importValidator().importCollector().imports());
    }

    protected static IFieldGenerator<?> createFieldDeclaration(String name, IDataType dataType) {
        return ((IFieldGenerator)((IFieldGenerator)FieldGenerator.create().withElementName(name)).withModifier(Modifier.DECLARE)).withDataType(dataType);
    }

    protected String calculateModelName() {
        return this.literal().containingFile().map(Path::getFileName).map(Path::toString).map(filename -> Strings.removeSuffix((String)filename, (CharSequence)".ts")).orElseThrow(() -> Ensure.newFail((CharSequence)"Model name can not be detected.", (Object[])new Object[0]));
    }

    protected boolean calculatePage() {
        if (this.mainWidget() != null) {
            return this.mainWidget().supers().withSuperInterfaces(false).stream().anyMatch(es6Class -> "Page".equals(es6Class.name()));
        }
        String modelName = this.modelName();
        return modelName.endsWith("Page") || modelName.endsWith("PageModel") || modelName.contains("PageWithTable") || modelName.contains("PageWithNodes") || modelName.endsWith("TablePageModel") || modelName.endsWith("NodePageModel");
    }

    public IObjectLiteral literal() {
        return this.m_literal;
    }

    public void setLiteral(IObjectLiteral literal) {
        this.m_literal = literal;
    }

    public IES6Class mainWidget() {
        return this.m_mainWidget;
    }

    public void setMainWidget(IES6Class mainWidget) {
        this.m_mainWidget = mainWidget;
    }

    public String modelName() {
        return this.m_modelName;
    }

    protected void setModelName(String modelName) {
        this.m_modelName = modelName;
    }

    public boolean isPage() {
        return this.m_isPage;
    }

    protected void setPage(boolean page) {
        this.m_isPage = page;
    }

    public List<CharSequence> classSources() {
        return this.m_classSources;
    }

    protected void setClassSources(List<CharSequence> classSources) {
        this.m_classSources = classSources;
    }

    public Map<String, CharSequence> declarationSources() {
        return this.m_declarationSources;
    }

    protected void setDeclarationSources(Map<String, CharSequence> declarationSources) {
        this.m_declarationSources = declarationSources;
    }

    public Collection<String> declarationsToRemove() {
        return this.m_declarationsToRemove;
    }

    protected void setDeclarationsToRemove(Collection<String> declarationsToRemove) {
        this.m_declarationsToRemove = declarationsToRemove;
    }

    public List<IES6ImportCollector.ES6ImportDescriptor> importsForModel() {
        return this.m_importsForModel;
    }

    protected void setImportsForModel(List<IES6ImportCollector.ES6ImportDescriptor> importsForModel) {
        this.m_importsForModel = importsForModel;
    }

    public List<IES6ImportCollector.ES6ImportDescriptor> importNamesForDeclarations() {
        return this.m_importNamesForDeclarations;
    }

    protected void setImportNamesForDeclarations(List<IES6ImportCollector.ES6ImportDescriptor> importNamesForDeclarations) {
        this.m_importNamesForDeclarations = importNamesForDeclarations;
    }
}

