/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.core.s.widgetmap.generator;

import java.util.Optional;
import java.util.function.Predicate;
import org.eclipse.scout.sdk.core.s.widgetmap.IdObjectTypeMap;
import org.eclipse.scout.sdk.core.s.widgetmap.ObjectType;
import org.eclipse.scout.sdk.core.s.widgetmap.Type;
import org.eclipse.scout.sdk.core.typescript.generator.field.FieldGenerator;
import org.eclipse.scout.sdk.core.typescript.generator.field.IFieldGenerator;
import org.eclipse.scout.sdk.core.typescript.generator.type.TypeGenerator;
import org.eclipse.scout.sdk.core.typescript.model.api.IObjectLiteral;
import org.eclipse.scout.sdk.core.typescript.model.api.Modifier;
import org.eclipse.scout.sdk.core.util.Ensure;
import org.eclipse.scout.sdk.core.util.Strings;

public class ObjectTypeGenerator
extends TypeGenerator<ObjectTypeGenerator> {
    private ObjectType m_objectType;

    protected void setup() {
        ObjectType objectType = this.objectType().orElseThrow(() -> Ensure.newFail((CharSequence)"ObjectType missing.", (Object[])new Object[0]));
        String elementName = objectType.newClassName().filter(Predicate.not(Strings::isBlank)).orElseThrow(() -> Ensure.newFail((CharSequence)"Name missing.", (Object[])new Object[0]));
        ((ObjectTypeGenerator)((ObjectTypeGenerator)((ObjectTypeGenerator)this.withModifier(Modifier.EXPORT)).asClass()).withElementName(elementName)).withSuperClass(objectType.es6Class());
        ObjectTypeGenerator objectTypeGenerator = this;
        objectType.widgetMap().map(ObjectTypeGenerator::createWidgetMapField).ifPresent(x$0 -> objectTypeGenerator.withField((IFieldGenerator)x$0, new Object[0]));
        objectTypeGenerator = this;
        objectType.columnMap().map(ObjectTypeGenerator::createColumnMapField).ifPresent(x$0 -> objectTypeGenerator.withField((IFieldGenerator)x$0, new Object[0]));
    }

    protected static IFieldGenerator<?> createIdObjectTypeMapField(IdObjectTypeMap map, String fieldName) {
        IObjectLiteral objectLiteral = map.model();
        String name = Type.ensureValidName(map.name());
        return ((IFieldGenerator)((IFieldGenerator)FieldGenerator.create().withElementName(fieldName)).withModifier(Modifier.DECLARE)).withDataType(objectLiteral.spi().createDataType(name).api());
    }

    protected static IFieldGenerator<?> createWidgetMapField(IdObjectTypeMap map) {
        return ObjectTypeGenerator.createIdObjectTypeMapField(map, "widgetMap");
    }

    protected static IFieldGenerator<?> createColumnMapField(IdObjectTypeMap map) {
        return ObjectTypeGenerator.createIdObjectTypeMapField(map, "columnMap");
    }

    public Optional<ObjectType> objectType() {
        return Optional.ofNullable(this.m_objectType);
    }

    public ObjectTypeGenerator withObjectType(ObjectType objectType) {
        this.m_objectType = objectType;
        return this;
    }
}

