/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.core.java.model.api.internal;

import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.scout.sdk.core.java.JavaTypes;
import org.eclipse.scout.sdk.core.java.generator.method.IMethodGenerator;
import org.eclipse.scout.sdk.core.java.generator.method.MethodGenerator;
import org.eclipse.scout.sdk.core.java.model.api.IAnnotation;
import org.eclipse.scout.sdk.core.java.model.api.IJavaElement;
import org.eclipse.scout.sdk.core.java.model.api.IMethod;
import org.eclipse.scout.sdk.core.java.model.api.IMethodParameter;
import org.eclipse.scout.sdk.core.java.model.api.IType;
import org.eclipse.scout.sdk.core.java.model.api.internal.AbstractMemberImplementor;
import org.eclipse.scout.sdk.core.java.model.api.query.AnnotationQuery;
import org.eclipse.scout.sdk.core.java.model.api.query.MethodParameterQuery;
import org.eclipse.scout.sdk.core.java.model.api.query.SuperMethodQuery;
import org.eclipse.scout.sdk.core.java.model.api.spliterator.WrappingSpliterator;
import org.eclipse.scout.sdk.core.java.model.spi.MethodSpi;
import org.eclipse.scout.sdk.core.java.model.spi.TypeSpi;
import org.eclipse.scout.sdk.core.java.transformer.IWorkingCopyTransformer;
import org.eclipse.scout.sdk.core.util.Ensure;
import org.eclipse.scout.sdk.core.util.SourceRange;

public class MethodImplementor
extends AbstractMemberImplementor<MethodSpi>
implements IMethod {
    public MethodImplementor(MethodSpi spi) {
        super(spi);
    }

    @Override
    public IType requireDeclaringType() {
        return ((MethodSpi)this.m_spi).getDeclaringType().wrap();
    }

    @Override
    public boolean isConstructor() {
        return ((MethodSpi)this.m_spi).isConstructor();
    }

    @Override
    public Optional<IType> returnType() {
        return Optional.ofNullable(((MethodSpi)this.m_spi).getReturnType()).map(TypeSpi::wrap);
    }

    @Override
    public Stream<? extends IJavaElement> children() {
        return Stream.concat(Stream.concat(this.annotations().stream(), this.typeParameters()), this.parameters().stream());
    }

    @Override
    public IType requireReturnType() {
        return this.returnType().orElseThrow(() -> Ensure.newFail((CharSequence)"Method {} in type {} is a constructor and therefore has no return type.", (Object[])new Object[]{this.identifier(), this.requireDeclaringType().name()}));
    }

    @Override
    public Stream<IType> exceptionTypes() {
        return WrappingSpliterator.stream(((MethodSpi)this.m_spi).getExceptionTypes());
    }

    @Override
    public Optional<SourceRange> sourceOfBody() {
        return Optional.ofNullable(((MethodSpi)this.m_spi).getSourceOfBody());
    }

    @Override
    public Optional<SourceRange> sourceOfDeclaration() {
        return Optional.ofNullable(((MethodSpi)this.m_spi).getSourceOfDeclaration());
    }

    @Override
    public SuperMethodQuery superMethods() {
        return new SuperMethodQuery(this);
    }

    @Override
    public AnnotationQuery<IAnnotation> annotations() {
        return new AnnotationQuery<IAnnotation>(this.requireDeclaringType(), this.m_spi);
    }

    @Override
    public MethodParameterQuery parameters() {
        return new MethodParameterQuery((MethodSpi)this.m_spi);
    }

    @Override
    public String identifier(boolean includeTypeArguments) {
        if (!includeTypeArguments) {
            return ((MethodSpi)this.m_spi).getMethodId();
        }
        List parameterTypes = this.parameters().stream().map(IMethodParameter::dataType).map(p -> p.reference(false)).collect(Collectors.toList());
        return JavaTypes.createMethodIdentifier(this.elementName(), parameterTypes);
    }

    @Override
    public String identifier() {
        return this.identifier(false);
    }

    @Override
    public IMethodGenerator<?, ?> toWorkingCopy(IWorkingCopyTransformer transformer) {
        return MethodGenerator.create(this, transformer);
    }

    @Override
    public IMethodGenerator<?, ?> toWorkingCopy() {
        return this.toWorkingCopy(null);
    }
}

