/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.ws.internal.explorer.platform.favorites.actions;

import java.util.Enumeration;
import org.eclipse.wst.ws.internal.explorer.platform.datamodel.TreeElement;
import org.eclipse.wst.ws.internal.explorer.platform.favorites.actions.MultipleLinkAction;
import org.eclipse.wst.ws.internal.explorer.platform.favorites.datamodel.FavoritesElement;
import org.eclipse.wst.ws.internal.explorer.platform.favorites.datamodel.FavoritesFolderElement;
import org.eclipse.wst.ws.internal.explorer.platform.favorites.datamodel.FavoritesMainElement;
import org.eclipse.wst.ws.internal.explorer.platform.favorites.perspective.FavoritesPerspective;
import org.eclipse.wst.ws.internal.explorer.platform.perspective.Controller;
import org.eclipse.wst.ws.internal.explorer.platform.perspective.Node;
import org.eclipse.wst.ws.internal.explorer.platform.perspective.NodeManager;

public class RemoveFavoritesAction
extends MultipleLinkAction {
    public RemoveFavoritesAction(Controller controller) {
        super(controller);
    }

    public static String getActionLink(int nodeID, int toolID, int viewID, int viewToolID) {
        StringBuffer actionLink = new StringBuffer("favorites/actions/RemoveFavoritesActionJSP.jsp?");
        actionLink.append("nodeId");
        actionLink.append('=');
        actionLink.append(nodeID);
        actionLink.append('&');
        actionLink.append("toolId");
        actionLink.append('=');
        actionLink.append(toolID);
        actionLink.append('&');
        actionLink.append("viewId");
        actionLink.append('=');
        actionLink.append(viewID);
        actionLink.append('&');
        actionLink.append("viewToolId");
        actionLink.append('=');
        actionLink.append(viewToolID);
        return actionLink.toString();
    }

    public static String getBaseActionLink() {
        return "favorites/actions/RemoveFavoritesActionJSP.jsp";
    }

    @Override
    protected boolean executeSingleLinkAction() {
        boolean actionResult;
        int nodeID;
        FavoritesPerspective favPerspective = this.controller_.getFavoritesPerspective();
        NodeManager nodeManager = favPerspective.getNodeManager();
        String nodeIDString = (String)this.propertyTable_.get("nodeId");
        try {
            nodeID = Integer.parseInt(nodeIDString);
        }
        catch (NumberFormatException numberFormatException) {
            nodeID = nodeManager.getSelectedNodeId();
        }
        Node selectedNode = nodeManager.getNode(nodeID);
        if (selectedNode == null) {
            return false;
        }
        TreeElement selectedElement = selectedNode.getTreeElement();
        String pluginMetadataDirectory = this.controller_.getServletEngineStateLocation();
        if (selectedElement instanceof FavoritesElement) {
            actionResult = ((FavoritesElement)selectedElement).getParentFolderElement().removeFavoriteByNodeID(nodeID, pluginMetadataDirectory);
        } else if (selectedElement instanceof FavoritesFolderElement) {
            actionResult = ((FavoritesFolderElement)selectedElement).removeAllFavorites(pluginMetadataDirectory);
        } else if (selectedElement instanceof FavoritesMainElement) {
            FavoritesMainElement mainElement = (FavoritesMainElement)selectedElement;
            Enumeration e = mainElement.getElements("relWSILFolderNode");
            actionResult = ((FavoritesFolderElement)((Object)e.nextElement())).removeAllFavorites(pluginMetadataDirectory);
            e = mainElement.getElements("relWSDLServiceFolderNode");
            actionResult = actionResult && ((FavoritesFolderElement)((Object)e.nextElement())).removeAllFavorites(pluginMetadataDirectory);
            e = mainElement.getElements("relUDDIServiceFolderNode");
            actionResult = actionResult && ((FavoritesFolderElement)((Object)e.nextElement())).removeAllFavorites(pluginMetadataDirectory);
            e = mainElement.getElements("relUDDIBusinessFolderNode");
            actionResult = actionResult && ((FavoritesFolderElement)((Object)e.nextElement())).removeAllFavorites(pluginMetadataDirectory);
            e = mainElement.getElements("relUDDIServiceInterfaceFolderNode");
            actionResult = actionResult && ((FavoritesFolderElement)((Object)e.nextElement())).removeAllFavorites(pluginMetadataDirectory);
            e = mainElement.getElements("relUDDIRegistryFolerNode");
            actionResult = actionResult && ((FavoritesFolderElement)((Object)e.nextElement())).removeAllFavorites(pluginMetadataDirectory);
        } else {
            actionResult = false;
        }
        if (actionResult) {
            favPerspective.getMessageQueue().addMessage(this.controller_.getMessage("MSG_INFO_NODE_CLEARED", selectedNode.getNodeName()));
        }
        return actionResult;
    }

    public String getTreeContentVar() {
        return "favNavigatorContent";
    }

    public String getTreeContentPage() {
        return "favorites/fav_navigator_content.jsp";
    }

    public String getPropertiesContainerVar() {
        return "favPropertiesContainer";
    }

    public String getPropertiesContainerPage() {
        return "favorites/fav_properties_container.jsp";
    }

    public String getStatusContentVar() {
        return "favStatusContent";
    }

    public String getStatusContentPage() {
        return "favorites/fav_status_content.jsp";
    }
}

