/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.core.java.ecj;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.ast.TypeParameter;
import org.eclipse.jdt.internal.compiler.lookup.ClassScope;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeConstants;
import org.eclipse.jdt.internal.compiler.lookup.TypeVariableBinding;
import org.eclipse.scout.sdk.core.java.ecj.AbstractJavaElementWithEcj;
import org.eclipse.scout.sdk.core.java.ecj.AbstractMemberWithEcj;
import org.eclipse.scout.sdk.core.java.ecj.JavaEnvironmentWithEcj;
import org.eclipse.scout.sdk.core.java.ecj.SpiWithEcjUtils;
import org.eclipse.scout.sdk.core.java.model.api.ITypeParameter;
import org.eclipse.scout.sdk.core.java.model.api.internal.TypeParameterImplementor;
import org.eclipse.scout.sdk.core.java.model.spi.AbstractJavaEnvironment;
import org.eclipse.scout.sdk.core.java.model.spi.CompilationUnitSpi;
import org.eclipse.scout.sdk.core.java.model.spi.MemberSpi;
import org.eclipse.scout.sdk.core.java.model.spi.TypeParameterSpi;
import org.eclipse.scout.sdk.core.java.model.spi.TypeSpi;
import org.eclipse.scout.sdk.core.util.Ensure;
import org.eclipse.scout.sdk.core.util.FinalValue;
import org.eclipse.scout.sdk.core.util.SourceRange;

public class BindingTypeParameterWithEcj
extends AbstractJavaElementWithEcj<ITypeParameter>
implements TypeParameterSpi {
    private final AbstractMemberWithEcj<?> m_declaringMember;
    private final TypeVariableBinding m_binding;
    private final int m_index;
    private final FinalValue<String> m_name;
    private final FinalValue<List<TypeSpi>> m_bounds;
    private final FinalValue<SourceRange> m_source;

    protected BindingTypeParameterWithEcj(AbstractJavaEnvironment env, AbstractMemberWithEcj<?> declaringMember, TypeVariableBinding binding, int index) {
        super(env);
        this.m_declaringMember = (AbstractMemberWithEcj)((Object)Ensure.notNull(declaringMember));
        this.m_binding = (TypeVariableBinding)Ensure.notNull((Object)binding);
        this.m_index = index;
        this.m_name = new FinalValue();
        this.m_bounds = new FinalValue();
        this.m_source = new FinalValue();
    }

    public TypeParameterSpi internalFindNewElement() {
        MemberSpi newMember = (MemberSpi)this.getDeclaringMember().internalFindNewElement();
        if (newMember != null && newMember.getTypeParameters().size() > this.m_index) {
            return (TypeParameterSpi)newMember.getTypeParameters().get(this.m_index);
        }
        return null;
    }

    protected ITypeParameter internalCreateApi() {
        return new TypeParameterImplementor((TypeParameterSpi)this);
    }

    public TypeVariableBinding getInternalBinding() {
        return this.m_binding;
    }

    public String getElementName() {
        return (String)this.m_name.computeIfAbsentAndGet(() -> new String(this.m_binding.sourceName()));
    }

    protected static ReferenceBinding getSuperClassBinding(BindingTypeParameterWithEcj tp) {
        return tp.m_binding.superclass();
    }

    protected static ReferenceBinding[] getSuperInterfaceBindings(BindingTypeParameterWithEcj tp) {
        return tp.m_binding.superInterfaces();
    }

    public List<TypeSpi> getBounds() {
        return (List)this.m_bounds.computeIfAbsentAndGet(() -> {
            TypeSpi t;
            ReferenceBinding[] superInterfaces;
            ReferenceBinding superclass;
            JavaEnvironmentWithEcj javaEnv = this.javaEnvWithEcj();
            Object object = javaEnv.lock();
            synchronized (object) {
                superclass = BindingTypeParameterWithEcj.getSuperClassBinding(this);
                superInterfaces = BindingTypeParameterWithEcj.getSuperInterfaceBindings(this);
            }
            boolean hasSuperClass = superclass != null && !CharOperation.equals((char[][])superclass.compoundName, (char[][])TypeConstants.JAVA_LANG_OBJECT);
            boolean hasSuperInterfaces = superInterfaces != null && superInterfaces.length > 0;
            int size = 0;
            if (hasSuperClass) {
                ++size;
            }
            if (hasSuperInterfaces) {
                size += superInterfaces.length;
            }
            ArrayList<TypeSpi> bounds = new ArrayList<TypeSpi>(size);
            if (hasSuperClass && (t = SpiWithEcjUtils.bindingToType(javaEnv, (TypeBinding)superclass, () -> (TypeBinding)this.withNewElement(BindingTypeParameterWithEcj::getSuperClassBinding))) != null) {
                bounds.add(t);
            }
            if (hasSuperInterfaces) {
                bounds.addAll(SpiWithEcjUtils.bindingsToTypes(javaEnv, (TypeBinding[])superInterfaces, () -> (TypeBinding[])this.withNewElement(BindingTypeParameterWithEcj::getSuperInterfaceBindings)));
            }
            return bounds;
        });
    }

    public AbstractMemberWithEcj<?> getDeclaringMember() {
        return this.m_declaringMember;
    }

    public SourceRange getSource() {
        return (SourceRange)this.m_source.computeIfAbsentAndGet(() -> {
            ClassScope classScope = SpiWithEcjUtils.classScopeOf(this);
            if (classScope == null) {
                return null;
            }
            TypeParameter decl = classScope.referenceContext.typeParameters[this.m_index];
            if (decl == null) {
                return null;
            }
            CompilationUnitSpi cu = SpiWithEcjUtils.declaringTypeOf(this).getCompilationUnit();
            return this.javaEnvWithEcj().getSource(cu, decl.declarationSourceStart, decl.declarationSourceEnd);
        });
    }
}

