/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.core.typescript.builder.imports;

import java.nio.file.Path;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.eclipse.scout.sdk.core.typescript.builder.imports.IES6ImportCollector;
import org.eclipse.scout.sdk.core.typescript.model.api.IDataType;
import org.eclipse.scout.sdk.core.util.Ensure;
import org.eclipse.scout.sdk.core.util.Strings;

public class ES6ImportCollector
implements IES6ImportCollector {
    private final Map<String, IES6ImportCollector.ES6ImportDescriptor> m_imports = new LinkedHashMap<String, IES6ImportCollector.ES6ImportDescriptor>();
    private final Map<IDataType, IES6ImportCollector.ES6ImportDescriptor> m_descriptors = new HashMap<IDataType, IES6ImportCollector.ES6ImportDescriptor>();

    @Override
    public IES6ImportCollector.ES6ImportDescriptor add(IDataType element, String alias) {
        IES6ImportCollector.ES6ImportDescriptor d = new IES6ImportCollector.ES6ImportDescriptor((IDataType)Ensure.notNull((Object)element), alias);
        IES6ImportCollector.ES6ImportDescriptor previous = this.m_imports.put(d.nameForSource(), d);
        Ensure.isTrue((previous == null ? 1 : 0) != 0);
        this.m_descriptors.put(element, d);
        return d;
    }

    @Override
    public IES6ImportCollector.ES6ImportDescriptor descriptorFor(IDataType element) {
        return this.m_descriptors.get(element);
    }

    @Override
    public Set<String> usedNames() {
        return Collections.unmodifiableSet(this.m_imports.keySet());
    }

    @Override
    public Collection<IES6ImportCollector.ES6ImportDescriptor> imports() {
        return this.m_imports.values().stream().filter(Objects::nonNull).toList();
    }

    @Override
    public void registerReservedName(String name) {
        this.m_imports.put((String)Ensure.notNull((Object)name), null);
    }

    public static String buildRelativeImportPath(Path importer, Path imported) {
        Object from = importer.getParent().relativize(imported).toString().replace('\\', '/');
        if (!Strings.startsWith((CharSequence)from, (char)'.')) {
            from = "./" + (String)from;
        }
        return Strings.removeSuffix((String)Strings.removeSuffix((String)from, (CharSequence)".ts"), (CharSequence)".js");
    }
}

