/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.core.typescript.model.api.query;

import java.util.Collection;
import java.util.Collections;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.eclipse.scout.sdk.core.model.query.AbstractQuery;
import org.eclipse.scout.sdk.core.typescript.model.api.INodeModule;
import org.eclipse.scout.sdk.core.typescript.model.api.spliterator.PackageJsonDependencySpliterator;
import org.eclipse.scout.sdk.core.typescript.model.spi.NodeModuleSpi;
import org.eclipse.scout.sdk.core.util.Ensure;

public class DependencyQuery
extends AbstractQuery<INodeModule> {
    private final NodeModuleSpi m_rootModule;
    private String m_name;
    private boolean m_recursive;
    private boolean m_withSelf;

    public DependencyQuery(NodeModuleSpi start) {
        this.m_rootModule = (NodeModuleSpi)Ensure.notNull((Object)start);
    }

    public DependencyQuery withName(String name) {
        this.m_name = name;
        return this;
    }

    protected String name() {
        return this.m_name;
    }

    public DependencyQuery withSelf(boolean withSelf) {
        this.m_withSelf = withSelf;
        return this;
    }

    protected boolean isWithSelf() {
        return this.m_withSelf;
    }

    public DependencyQuery withRecursive(boolean recursive) {
        this.m_recursive = recursive;
        return this;
    }

    protected boolean isRecursive() {
        return this.m_recursive;
    }

    protected NodeModuleSpi module() {
        return this.m_rootModule;
    }

    protected Stream<INodeModule> createStream() {
        Collection<NodeModuleSpi> startModules = this.isWithSelf() ? Collections.singletonList(this.module()) : this.module().packageJson().dependencies();
        Stream<NodeModuleSpi> stream = StreamSupport.stream(new PackageJsonDependencySpliterator(startModules, this.isRecursive(), this.isWithSelf()), false);
        String name = this.name();
        if (name != null) {
            stream = stream.filter(nodeModule -> name.equals(nodeModule.packageJson().api().name()));
        }
        return stream.map(NodeModuleSpi::api);
    }
}

