/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsp.core.taglib;

import com.ibm.icu.text.Collator;
import com.ibm.icu.util.StringTokenizer;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IResourceProxy;
import org.eclipse.core.resources.IResourceProxyVisitor;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ILock;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jdt.core.IClasspathContainer;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaElementDelta;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jst.jsp.core.internal.Logger;
import org.eclipse.jst.jsp.core.internal.contenttype.DeploymentDescriptorPropertyCache;
import org.eclipse.jst.jsp.core.internal.java.ArrayMap;
import org.eclipse.jst.jsp.core.internal.util.DocumentProvider;
import org.eclipse.jst.jsp.core.internal.util.FacetModuleCoreSupport;
import org.eclipse.jst.jsp.core.taglib.IJarRecord;
import org.eclipse.jst.jsp.core.taglib.ITLDRecord;
import org.eclipse.jst.jsp.core.taglib.ITagDirRecord;
import org.eclipse.jst.jsp.core.taglib.ITaglibDescriptor;
import org.eclipse.jst.jsp.core.taglib.ITaglibRecord;
import org.eclipse.jst.jsp.core.taglib.IURLRecord;
import org.eclipse.jst.jsp.core.taglib.TaglibIndex;
import org.eclipse.jst.jsp.core.taglib.TaglibIndexDelta;
import org.eclipse.wst.common.uriresolver.internal.util.URIHelper;
import org.eclipse.wst.sse.core.internal.util.JarUtilities;
import org.eclipse.wst.sse.core.internal.util.Sorter;
import org.eclipse.wst.sse.core.utils.StringUtils;
import org.eclipse.wst.xml.core.internal.XMLCorePlugin;
import org.eclipse.wst.xml.core.internal.catalog.provisional.ICatalog;
import org.eclipse.wst.xml.core.internal.catalog.provisional.ICatalogEntry;
import org.eclipse.wst.xml.core.internal.catalog.provisional.INextCatalog;
import org.w3c.dom.EntityReference;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

class ProjectDescription {
    static final String EMPTY_STRING = "";
    static boolean _debugIndexCreation = "true".equalsIgnoreCase(Platform.getDebugOption((String)"org.eclipse.jst.jsp.core/taglib/indexcreation"));
    static boolean _debugIndexTime = "true".equalsIgnoreCase(Platform.getDebugOption((String)"org.eclipse.jst.jsp.core/taglib/indextime"));
    private static final String BUILDPATH_DIRTY = "BUILDPATH_DIRTY";
    private static final String BUILDPATH_ENTRIES = "BUILDPATH_ENTRIES";
    private static final String BUILDPATH_PROJECT = "BUILDPATH_PROJECT";
    private static final String SAVE_FORMAT_VERSION = "Tag Library Index 1.1.0";
    private static final String WEB_INF = "WEB-INF";
    private static final IPath WEB_INF_PATH = new Path("WEB-INF");
    private static final String WEB_XML = "web.xml";
    private static final char[] TLD = new char[]{'t', 'T', 'l', 'L', 'd', 'D'};
    boolean fBuildPathIsDirty = false;
    int fBuildPathEntryCount = 0;
    private Collection fCatalogRecords;
    Hashtable fClasspathJars;
    Set<IProject> fClasspathProjects = null;
    Hashtable fClasspathReferences;
    Hashtable fImplicitReferences;
    Hashtable fJARReferences;
    IProject fProject;
    private String fSaveStateFilename;
    Hashtable fTagDirReferences;
    Hashtable fTLDReferences;
    IResourceDeltaVisitor fVisitor;
    Hashtable fWebXMLReferences;
    Map fPackageFragmentRootsAdded = new HashMap();
    Map fPackageFragmentRootsChanged = new HashMap();
    Map fPackageFragmentRootsRemoved = new HashMap();
    ILock LOCK = Job.getJobManager().newLock();
    private long time0;
    private TaglibSorter fTaglibSorter = new TaglibSorter();
    private BuildPathJob fBuildPathJob = new BuildPathJob();
    private static final Map fSharedJarRecords = new Hashtable();

    ProjectDescription(IProject project, String saveStateFile) {
        this.fProject = project;
        this.fSaveStateFilename = saveStateFile;
        this.fClasspathJars = new Hashtable(0);
        this.fJARReferences = new Hashtable(0);
        this.fTagDirReferences = new Hashtable(0);
        this.fTLDReferences = new Hashtable(0);
        this.fWebXMLReferences = new Hashtable(0);
        this.fImplicitReferences = new Hashtable(0);
        this.fClasspathReferences = new Hashtable(0);
        this.fClasspathProjects = new HashSet<IProject>();
        this.restoreReferences();
    }

    private Collection _getJSP11AndWebXMLJarReferences(Collection allJARs) {
        ArrayList<JarRecord> collection = new ArrayList<JarRecord>(allJARs.size());
        for (JarRecord record : allJARs) {
            if (!record.has11TLD && !record.isMappedInWebXML) continue;
            collection.add(record);
        }
        return collection;
    }

    void addBuildPathReferences(Map references, List projectsProcessed, boolean exportedOnly) {
        this.ensureUpTodate();
        Enumeration keys = this.fClasspathReferences.keys();
        while (keys.hasMoreElements()) {
            Object key = keys.nextElement();
            URLRecord urlRecord = (URLRecord)this.fClasspathReferences.get(key);
            if (exportedOnly) {
                if (!urlRecord.isExported) continue;
                references.put(key, urlRecord);
                continue;
            }
            references.put(key, urlRecord);
        }
        IProject[] buildpathProjects = this.fClasspathProjects.toArray(new IProject[this.fClasspathProjects.size()]);
        int i = 0;
        while (i < buildpathProjects.length) {
            if (!projectsProcessed.contains(buildpathProjects[i]) && buildpathProjects[i].isAccessible()) {
                projectsProcessed.add(buildpathProjects[i]);
                ProjectDescription description = TaglibIndex.getInstance().createDescription(buildpathProjects[i]);
                description.addBuildPathReferences(references, projectsProcessed, true);
                Map[] rootReferences = description.fImplicitReferences.values().toArray(new Map[description.fImplicitReferences.size()]);
                int j = 0;
                while (j < rootReferences.length) {
                    for (ITaglibRecord record : rootReferences[j].values()) {
                        if (record.getRecordType() != 1 || ((ITLDRecord)record).getURI() == null || ((ITLDRecord)record).getURI().length() <= 0) continue;
                        references.put(((ITLDRecord)record).getURI(), record);
                    }
                    ++j;
                }
            }
            ++i;
        }
    }

    void clear() {
        this.fClasspathJars = new Hashtable(0);
        this.fJARReferences = new Hashtable(0);
        this.fTagDirReferences = new Hashtable(0);
        this.fTLDReferences = new Hashtable(0);
        this.fWebXMLReferences = new Hashtable(0);
        this.fImplicitReferences = new Hashtable(0);
        this.fClasspathReferences = new Hashtable(0);
    }

    private void closeJarFile(ZipFile file) {
        if (file == null) {
            return;
        }
        try {
            file.close();
        }
        catch (IOException ioe) {
            Logger.logException("TaglibIndex: Could not close zip file " + file.getName(), ioe);
        }
    }

    private ITaglibRecord createCatalogRecord(ICatalogEntry catalogEntry) {
        return this.createCatalogRecord(catalogEntry.getKey(), catalogEntry.getURI());
    }

    private ITaglibRecord createCatalogRecord(String uri, String urlString) {
        ITaglibRecord record = null;
        if (urlString.toLowerCase(Locale.US).endsWith(".jar") && urlString.startsWith("file:")) {
            String fileLocation = null;
            try {
                URL url = new URL(urlString);
                fileLocation = url.getFile();
            }
            catch (MalformedURLException e) {
                Logger.log(204, null, e);
            }
            if (fileLocation != null) {
                JarRecord jarRecord = this.createJARRecord(fileLocation);
                String[] entries = JarUtilities.getEntryNames((String)fileLocation);
                int jEntry = 0;
                while (jEntry < entries.length) {
                    if (entries[jEntry].endsWith(".tld") && entries[jEntry].equals("META-INF/taglib.tld")) {
                        jarRecord.has11TLD = true;
                        InputStream contents = JarUtilities.getInputStream((String)fileLocation, (String)entries[jEntry]);
                        if (contents != null) {
                            TaglibInfo info = this.extractInfo(fileLocation, contents);
                            info.uri = uri;
                            jarRecord.info = info;
                            try {
                                contents.close();
                            }
                            catch (IOException e) {
                                Logger.log(204, null, e);
                            }
                        }
                    }
                    ++jEntry;
                }
                if (jarRecord.has11TLD) {
                    if (_debugIndexCreation) {
                        Logger.log(1, "created catalog record for " + urlString + "@" + String.valueOf(jarRecord.getLocation()));
                    }
                    record = jarRecord;
                }
            }
        } else {
            URL url = null;
            InputStream tldStream = null;
            try {
                url = new URL(urlString);
                tldStream = JarUtilities.getInputStream((URL)url);
            }
            catch (Exception e1) {
                Logger.logException("Exception reading TLD contributed to the XML Catalog", e1);
            }
            if (tldStream != null) {
                URLRecord urlRecord = null;
                TaglibInfo info = this.extractInfo(urlString, tldStream);
                if (info != null) {
                    info.uri = uri;
                    urlRecord = new URLRecord();
                    urlRecord.info = info;
                    urlRecord.baseLocation = urlString;
                    urlRecord.url = url;
                }
                try {
                    tldStream.close();
                }
                catch (IOException e) {
                    Logger.log(204, null, e);
                }
                record = urlRecord;
            }
        }
        return record;
    }

    private JarRecord createJARRecord(IResource jar) {
        IPath location = jar.getLocation();
        JarRecord jarRecord = null;
        if (location != null) {
            jarRecord = this.createJARRecord(location.toString());
        } else if (jar.getLocationURI() != null) {
            jarRecord = this.createJARRecord(jar.getLocationURI().toString());
        }
        return jarRecord;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JarRecord createJARRecord(String fileLocation) {
        Map map = fSharedJarRecords;
        synchronized (map) {
            JarRecord record = (JarRecord)fSharedJarRecords.get(fileLocation);
            if (record == null) {
                record = new JarRecord();
                record.info = new TaglibInfo();
                record.location = new Path(fileLocation);
                record.urlRecords = new HashSet(0);
                fSharedJarRecords.put(fileLocation, record);
            }
            return record;
        }
    }

    private TagDirRecord createTagdirRecord(IContainer tagdir) {
        IPath tagdirPath = tagdir.getFullPath();
        TagDirRecord record = new TagDirRecord();
        record.path = tagdirPath;
        record.info = new TaglibInfo();
        if (tagdir.getName().equals("tags")) {
            record.info.shortName = "tags";
        } else {
            boolean determined = false;
            IPath path = tagdirPath;
            String[] segments = path.segments();
            int i = 1;
            while (i < segments.length) {
                if (segments[i - 1].equals(WEB_INF) && segments[i].equals("tags")) {
                    IPath tagdirLocalPath = path.removeFirstSegments(i + 1);
                    record.info.shortName = StringUtils.replace((String)tagdirLocalPath.toString(), (String)"/", (String)"-");
                    determined = true;
                }
                ++i;
            }
            if (!determined) {
                record.info.shortName = StringUtils.replace((String)tagdirPath.toString(), (String)"/", (String)"-");
            }
        }
        record.info.tlibVersion = "1.0";
        record.info.description = EMPTY_STRING;
        record.info.displayName = EMPTY_STRING;
        record.info.smallIcon = EMPTY_STRING;
        record.info.largeIcon = EMPTY_STRING;
        try {
            IResource[] tagfiles = tagdir.members();
            int i = 0;
            while (i < tagfiles.length) {
                String extension;
                if (tagfiles[i].getType() == 1 && (extension = tagfiles[i].getFileExtension()) != null && (extension.equals("tag") || extension.equals("tagx"))) {
                    record.tags.add(tagfiles[i].getName());
                }
                ++i;
            }
        }
        catch (CoreException e) {
            Logger.logException(e);
        }
        return record;
    }

    private TLDRecord createTLDRecord(IResource tld) {
        TLDRecord record = new TLDRecord();
        record.path = tld.getFullPath();
        InputStream contents = null;
        try {
            try {
                if (tld.isAccessible()) {
                    contents = ((IFile)tld).getContents();
                    String basePath = tld.getFullPath().toString();
                    TaglibInfo info = this.extractInfo(basePath, contents);
                    if (info != null) {
                        record.info = info;
                    }
                }
            }
            catch (CoreException coreException) {
                try {
                    if (contents != null) {
                        contents.close();
                    }
                }
                catch (IOException e) {
                    Logger.log(204, null, e);
                }
            }
        }
        finally {
            try {
                if (contents != null) {
                    contents.close();
                }
            }
            catch (IOException e) {
                Logger.log(204, null, e);
            }
        }
        return record;
    }

    private TLDRecord createTLDRecord(File tld) {
        TLDRecord record = new TLDRecord();
        record.path = new Path(tld.getAbsolutePath());
        InputStream contents = null;
        try {
            try {
                if (tld.exists()) {
                    contents = new FileInputStream(tld);
                    String basePath = tld.getAbsolutePath();
                    TaglibInfo info = this.extractInfo(basePath, contents);
                    if (info != null) {
                        record.info = info;
                    }
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
                try {
                    if (contents != null) {
                        contents.close();
                    }
                }
                catch (IOException e) {
                    Logger.log(204, null, e);
                }
            }
        }
        finally {
            try {
                if (contents != null) {
                    contents.close();
                }
            }
            catch (IOException e) {
                Logger.log(204, null, e);
            }
        }
        return record;
    }

    private void ensureUpTodate() {
        IClasspathEntry[] entries = null;
        try {
            IJavaProject jproject = JavaCore.create((IProject)this.fProject);
            if (jproject != null && jproject.exists()) {
                entries = jproject.getResolvedClasspath(true);
            }
        }
        catch (JavaModelException e) {
            Logger.logException(e);
        }
        if (entries != null) {
            try {
                this.LOCK.acquire();
                boolean bl = this.fBuildPathIsDirty = this.fBuildPathIsDirty || this.fBuildPathEntryCount != entries.length;
                if (this.fBuildPathIsDirty) {
                    this.indexClasspath(entries);
                    this.fBuildPathIsDirty = false;
                } else {
                    PackageFragmentRootDelta[] removes = this.fPackageFragmentRootsRemoved.values().toArray(new PackageFragmentRootDelta[this.fPackageFragmentRootsRemoved.size()]);
                    int i = 0;
                    while (i < removes.length) {
                        this.handleElementChanged(removes[i].elementPath, removes[i].deltaKind, removes[i].isExported);
                        ++i;
                    }
                    PackageFragmentRootDelta[] changes = this.fPackageFragmentRootsChanged.values().toArray(new PackageFragmentRootDelta[this.fPackageFragmentRootsChanged.size()]);
                    int i2 = 0;
                    while (i2 < changes.length) {
                        this.handleElementChanged(changes[i2].elementPath, changes[i2].deltaKind, changes[i2].isExported);
                        ++i2;
                    }
                    PackageFragmentRootDelta[] adds = this.fPackageFragmentRootsAdded.values().toArray(new PackageFragmentRootDelta[this.fPackageFragmentRootsAdded.size()]);
                    int i3 = 0;
                    while (i3 < adds.length) {
                        this.handleElementChanged(adds[i3].elementPath, adds[i3].deltaKind, adds[i3].isExported);
                        ++i3;
                    }
                    this.fPackageFragmentRootsRemoved.clear();
                    this.fPackageFragmentRootsChanged.clear();
                    this.fPackageFragmentRootsAdded.clear();
                }
            }
            finally {
                this.LOCK.release();
            }
        }
    }

    private TaglibInfo extractInfo(String basePath, InputStream tldContents) {
        TaglibInfo info = new TaglibInfo();
        if (tldContents != null) {
            DocumentProvider provider = new DocumentProvider();
            provider.setInputStream(tldContents);
            provider.setValidating(false);
            provider.setRootElementName("taglib");
            provider.setBaseReference(basePath);
            Node child = provider.getRootElement();
            if (child == null || child.getNodeType() != 1 || !child.getNodeName().equals("taglib")) {
                return null;
            }
            child = child.getFirstChild();
            while (child != null) {
                if (child.getNodeType() == 1) {
                    if (child.getNodeName().equals("uri")) {
                        info.uri = this.getTextContents(child);
                    } else if (child.getNodeName().equals("short-name") || child.getNodeName().equals("shortname")) {
                        info.shortName = this.getTextContents(child);
                    } else if (child.getNodeName().equals("description") || child.getNodeName().equals("info")) {
                        info.description = this.getTextContents(child);
                    } else if (child.getNodeName().equals("display-name")) {
                        info.displayName = this.getTextContents(child);
                    } else if (child.getNodeName().equals("jsp-version") || child.getNodeName().equals("jspversion")) {
                        info.jspVersion = this.getTextContents(child);
                    } else if (child.getNodeName().equals("tlib-version") || child.getNodeName().equals("tlibversion")) {
                        info.tlibVersion = this.getTextContents(child);
                    } else if (child.getNodeName().equals("small-icon")) {
                        info.smallIcon = this.getTextContents(child);
                    } else if (child.getNodeName().equals("large-icon")) {
                        info.largeIcon = this.getTextContents(child);
                    }
                }
                child = child.getNextSibling();
            }
        }
        return info;
    }

    List<ITaglibRecord> getAvailableTaglibRecords(IPath path) {
        this.ensureUpTodate();
        HashSet<Object> records = null;
        try {
            IPath localWebXML;
            WebXMLRecord webxmlRecord;
            float jspVersion = DeploymentDescriptorPropertyCache.getInstance().getJSPVersion(path);
            this.LOCK.acquire();
            HashSet implicitReferences = new HashSet(this.getImplicitReferences(path.toString()).values());
            records = new HashSet<Object>(this.fTLDReferences.size() + this.fTagDirReferences.size() + this.fJARReferences.size() + this.fWebXMLReferences.size());
            records.addAll(this.fTLDReferences.values());
            if ((double)jspVersion >= 1.1) {
                records.addAll(this._getJSP11AndWebXMLJarReferences(this.fJARReferences.values()));
            }
            if ((double)jspVersion >= 1.2) {
                records.addAll(implicitReferences);
                HashMap buildPathReferences = new HashMap();
                ArrayList<IProject> projectsProcessed = new ArrayList<IProject>(this.fClasspathProjects.size() + 1);
                projectsProcessed.add(this.fProject);
                this.addBuildPathReferences(buildPathReferences, projectsProcessed, false);
                records.addAll(buildPathReferences.values());
                if (path.segmentCount() > 1) {
                    records.addAll(new HashSet(this.getImplicitReferences(this.fProject.getFullPath().toString()).values()));
                }
            }
            if ((double)jspVersion >= 2.0) {
                records.addAll(this.fTagDirReferences.values());
            }
            if ((webxmlRecord = (WebXMLRecord)this.fWebXMLReferences.get((localWebXML = new Path(this.getLocalRoot(path.toString())).append("/WEB-INF/web.xml")).toString())) != null) {
                records.addAll(webxmlRecord.getTLDRecords());
            }
            records.addAll(this.getCatalogRecords());
        }
        finally {
            this.LOCK.release();
        }
        return new ArrayList<ITaglibRecord>(records);
    }

    private InputStream getCachedInputStream(ZipFile zipFile, ZipEntry zipEntry) {
        ByteArrayInputStream cache = null;
        if (zipFile != null && zipEntry != null) {
            InputStream entryInputStream = null;
            try {
                entryInputStream = zipFile.getInputStream(zipEntry);
            }
            catch (IOException ioExc) {
                Logger.logException("Taglib Index: " + zipFile.getName(), ioExc);
            }
            if (entryInputStream != null) {
                ByteArrayOutputStream buffer = null;
                buffer = zipEntry.getSize() > 0L ? new ByteArrayOutputStream((int)zipEntry.getSize()) : new ByteArrayOutputStream();
                byte[] bytes = new byte[2048];
                try {
                    try {
                        int c;
                        while ((c = entryInputStream.read(bytes)) >= 0) {
                            buffer.write(bytes, 0, c);
                        }
                        cache = new ByteArrayInputStream(buffer.toByteArray());
                    }
                    catch (IOException ioe) {
                        Logger.log(204, null, ioe);
                        try {
                            entryInputStream.close();
                        }
                        catch (IOException e) {
                            Logger.log(204, null, e);
                        }
                    }
                }
                finally {
                    try {
                        entryInputStream.close();
                    }
                    catch (IOException e) {
                        Logger.log(204, null, e);
                    }
                }
            }
        }
        return cache;
    }

    private Collection getCatalogRecords() {
        if (this.fCatalogRecords == null) {
            ArrayList<ITaglibRecord> records = new ArrayList<ITaglibRecord>();
            ICatalog defaultCatalog = XMLCorePlugin.getDefault().getDefaultXMLCatalog();
            if (defaultCatalog != null) {
                ICatalogEntry[] entries = defaultCatalog.getCatalogEntries();
                int entry = 0;
                while (entry < entries.length) {
                    ITaglibRecord record = this.createCatalogRecord(entries[entry]);
                    records.add(record);
                    ++entry;
                }
                INextCatalog[] nextCatalogs = defaultCatalog.getNextCatalogs();
                int nextCatalog = 0;
                while (nextCatalog < nextCatalogs.length) {
                    ICatalog catalog = nextCatalogs[nextCatalog].getReferencedCatalog();
                    ICatalogEntry[] entries2 = catalog.getCatalogEntries();
                    int entry2 = 0;
                    while (entry2 < entries2.length) {
                        ITaglibRecord record;
                        String uri = entries2[entry2].getURI();
                        if (uri != null && ((uri = uri.toLowerCase(Locale.US)).endsWith(".jar") || uri.endsWith(".tld")) && (record = this.createCatalogRecord(entries2[entry2])) != null) {
                            records.add(record);
                        }
                        ++entry2;
                    }
                    ++nextCatalog;
                }
            }
            this.fCatalogRecords = records;
        }
        return this.fCatalogRecords;
    }

    ArrayMap getImplicitReferences(String path) {
        String localRoot = this.getLocalRoot(path);
        ArrayMap implicitReferences = (ArrayMap)this.fImplicitReferences.get(localRoot);
        if (implicitReferences == null) {
            implicitReferences = new ArrayMap(1);
            this.fImplicitReferences.put(localRoot, implicitReferences);
        }
        return implicitReferences;
    }

    IPath getLocalRoot(IPath basePath) {
        IFile[] files;
        IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        IFile file = FileBuffers.getWorkspaceFileAtLocation((IPath)basePath);
        if (file == null && basePath.segmentCount() > 1) {
            file = workspaceRoot.getFolder(basePath);
        }
        if (file != null && !file.exists() && basePath.segmentCount() > 1) {
            file = workspaceRoot.getFile(basePath);
        }
        if (file == null && basePath.segmentCount() == 1) {
            file = workspaceRoot.getProject(basePath.segment(0));
        }
        if (file == null && (files = ResourcesPlugin.getWorkspace().getRoot().findFilesForLocation(basePath)).length > 0) {
            file = files[0];
        }
        while (file != null) {
            IFolder webinf;
            IContainer folder = null;
            folder = (file.getType() & 2) != 0 ? (IContainer)file : file.getParent();
            if (folder != null && (folder.getType() & 8) == 0 && (webinf = folder.getFolder(WEB_INF_PATH)) != null && webinf.exists()) {
                return folder.getFullPath();
            }
            file = file.getParent();
        }
        return this.fProject.getFullPath();
    }

    private String getLocalRoot(String basePath) {
        return this.getLocalRoot((IPath)new Path(basePath)).toString();
    }

    private String getTextContents(Node parent) {
        Node child;
        NodeList children = parent.getChildNodes();
        if (children.getLength() == 1 && (child = children.item(0)).getNodeValue() != null) {
            return child.getNodeValue().trim();
        }
        StringBuffer s = new StringBuffer();
        Node child2 = parent.getFirstChild();
        while (child2 != null) {
            if (child2.getNodeType() == 5) {
                Object reference = ((EntityReference)child2).getNodeValue();
                if (reference == null && child2.getNodeName() != null) {
                    reference = "&" + child2.getNodeName() + ";";
                }
                if (reference != null) {
                    s.append(((String)reference).trim());
                }
            } else if (child2.getNodeValue() != null) {
                s.append(child2.getNodeValue().trim());
            }
            child2 = child2.getNextSibling();
        }
        return s.toString().trim();
    }

    IResourceDeltaVisitor getVisitor() {
        if (this.fVisitor == null) {
            this.fVisitor = new DeltaVisitor();
        }
        return this.fVisitor;
    }

    void handleElementChanged(IPath libraryPath, int deltaKind, boolean exported) {
        IFile file = libraryPath.segmentCount() > 1 ? ResourcesPlugin.getWorkspace().getRoot().getFile(libraryPath) : null;
        String libraryLocation = null;
        libraryLocation = file != null && file.isAccessible() && file.getLocation() != null ? file.getLocation().toString() : libraryPath.toString();
        this.updateClasspathLibrary(libraryLocation, deltaKind, exported);
    }

    void handleElementChanged(IJavaElementDelta delta) {
        if (this.fBuildPathIsDirty) {
            return;
        }
        IJavaElement element = delta.getElement();
        if (element.getElementType() == 2) {
            IJavaElementDelta[] affectedChildren = delta.getAffectedChildren();
            int i = 0;
            while (i < affectedChildren.length) {
                this.handleElementChanged(affectedChildren[i]);
                ++i;
            }
        }
        if (element.getElementType() == 3 && ((IPackageFragmentRoot)element).isArchive()) {
            this.time0 = System.currentTimeMillis();
            if (element.getElementType() == 3) {
                ((IPackageFragmentRoot)element).isExternal();
            }
            String libLocation = null;
            int taglibRecordEventKind = -1;
            if ((delta.getFlags() & 0x40) > 0 || (delta.getFlags() & 0x8000) > 0 || (delta.getFlags() & 0x80) > 0) {
                taglibRecordEventKind = 4;
                if ((delta.getFlags() & 0x40) > 0) {
                    taglibRecordEventKind = 1;
                } else if ((delta.getFlags() & 0x8000) > 0) {
                    taglibRecordEventKind = 4;
                } else if ((delta.getFlags() & 0x80) > 0) {
                    taglibRecordEventKind = 2;
                }
                IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile(element.getPath());
                libLocation = file.isAccessible() && file.getLocation() != null ? file.getLocation().toString() : element.getPath().toString();
            }
            if (libLocation != null) {
                boolean fragmentisExported = true;
                try {
                    IClasspathEntry rawClasspathEntry = ((IPackageFragmentRoot)element).getRawClasspathEntry();
                    if (rawClasspathEntry != null) {
                        fragmentisExported = rawClasspathEntry.isExported();
                    }
                }
                catch (JavaModelException javaModelException) {}
                if ((delta.getFlags() & 0x40) > 0) {
                    ++this.fBuildPathEntryCount;
                } else if ((delta.getFlags() & 0x80) > 0) {
                    --this.fBuildPathEntryCount;
                }
                this.updateClasspathLibrary(libLocation, taglibRecordEventKind, fragmentisExported);
            }
            if (_debugIndexTime) {
                Logger.log(1, "processed build path delta for " + this.fProject.getName() + "(" + String.valueOf(element.getPath()) + ") in " + (System.currentTimeMillis() - this.time0) + "ms");
            }
        }
    }

    void index() {
        this.time0 = System.currentTimeMillis();
        this.fTLDReferences.clear();
        this.fJARReferences.clear();
        this.fTagDirReferences.clear();
        this.fWebXMLReferences.clear();
        try {
            this.fProject.accept((IResourceProxyVisitor)new Indexer(), 0);
        }
        catch (CoreException e) {
            Logger.logException(e);
        }
        if (_debugIndexTime) {
            Logger.log(1, "indexed " + this.fProject.getName() + " contents in " + (System.currentTimeMillis() - this.time0) + "ms");
        }
    }

    void indexClasspath(IClasspathEntry[] entries) {
        if (_debugIndexTime) {
            this.time0 = System.currentTimeMillis();
        }
        this.fClasspathProjects.clear();
        this.fClasspathReferences.clear();
        this.fClasspathJars.clear();
        this.fBuildPathEntryCount = entries.length;
        int i = 0;
        while (i < entries.length) {
            this.indexClasspath(entries[i]);
            ++i;
        }
        if (_debugIndexTime) {
            Logger.log(1, "indexed " + this.fProject.getName() + " classpath in " + (System.currentTimeMillis() - this.time0) + "ms");
        }
    }

    private void indexDirectory(File file, boolean isExported) {
        if (file.exists()) {
            if (file.isDirectory()) {
                File[] files = file.listFiles();
                int i = 0;
                while (i < files.length) {
                    this.indexDirectory(files[i], isExported);
                    ++i;
                }
            } else if (file.getName().endsWith(".tld")) {
                this.updateTLD(file.getAbsolutePath(), this.createTLDRecord(file), 1);
            }
        }
    }

    private void indexClasspath(IClasspathEntry entry) {
        switch (entry.getEntryKind()) {
            case 5: {
                IClasspathContainer container = (IClasspathContainer)entry;
                IClasspathEntry[] containedEntries = container.getClasspathEntries();
                int i = 0;
                while (i < containedEntries.length) {
                    this.indexClasspath(containedEntries[i]);
                    ++i;
                }
                break;
            }
            case 1: {
                IPath libPath = entry.getPath();
                if (this.fClasspathJars.containsKey(libPath.toString())) break;
                File file = libPath.toFile();
                if (file.exists()) {
                    if (file.isDirectory()) {
                        this.indexDirectory(file, entry.isExported());
                        break;
                    }
                    this.updateClasspathLibrary(libPath.toString(), 1, entry.isExported());
                    break;
                }
                IResource resource = ResourcesPlugin.getWorkspace().getRoot().findMember(libPath);
                if (resource == null || !resource.isAccessible()) break;
                if (resource.getType() == 1) {
                    if (resource.getLocation() == null) break;
                    this.updateClasspathLibrary(resource.getLocation().toString(), 1, entry.isExported());
                    break;
                }
                if (resource.getType() != 2) break;
                try {
                    resource.accept((IResourceProxyVisitor)new Indexer(), 0);
                }
                catch (CoreException e) {
                    Logger.logException(e);
                }
                break;
            }
            case 2: {
                IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(entry.getPath().lastSegment());
                if (project == null) break;
                this.fClasspathProjects.add(project);
                break;
            }
            case 3: {
                IPath path = entry.getPath();
                try {
                    IResource sourceFolder = ResourcesPlugin.getWorkspace().getRoot().findMember(path);
                    if (sourceFolder == null) break;
                    sourceFolder.accept((IResourceProxyVisitor)new Indexer(), 0);
                }
                catch (CoreException e) {
                    Logger.logException(e);
                }
                break;
            }
            case 4: {
                IPath libPath = JavaCore.getResolvedVariablePath((IPath)entry.getPath());
                if (libPath == null) break;
                File file = libPath.toFile();
                if (file.exists() && !file.isDirectory()) {
                    this.updateClasspathLibrary(libPath.toString(), 1, entry.isExported());
                    break;
                }
                IFile jarFile = ResourcesPlugin.getWorkspace().getRoot().getFile(libPath);
                if (!jarFile.isAccessible() || jarFile.getType() != 1 || jarFile.getLocation() == null) break;
                String jarPathString = jarFile.getLocation().toString();
                this.updateClasspathLibrary(jarPathString, 1, entry.isExported());
            }
        }
    }

    void queueElementChanged(IJavaElementDelta delta) {
        block13: {
            try {
                this.LOCK.acquire();
                IJavaElement element = delta.getElement();
                if (element.getElementType() == 2) {
                    IJavaElementDelta[] affectedChildren = delta.getAffectedChildren();
                    int i = 0;
                    while (i < affectedChildren.length) {
                        this.queueElementChanged(affectedChildren[i]);
                        ++i;
                    }
                }
                if (element.getElementType() != 3 || !((IPackageFragmentRoot)element).isArchive()) break block13;
                IPath path = element.getPath();
                boolean fragmentisExported = true;
                try {
                    IClasspathEntry rawClasspathEntry = ((IPackageFragmentRoot)element).getRawClasspathEntry();
                    if (rawClasspathEntry != null) {
                        fragmentisExported = rawClasspathEntry.isExported();
                    }
                }
                catch (JavaModelException javaModelException) {}
                String key = path.toString();
                if ((delta.getFlags() & 0x40) > 0) {
                    this.fPackageFragmentRootsAdded.put(key, new PackageFragmentRootDelta(path, 1, fragmentisExported));
                    this.fPackageFragmentRootsChanged.remove(key);
                    this.fPackageFragmentRootsRemoved.remove(key);
                    ++this.fBuildPathEntryCount;
                } else if ((delta.getFlags() & 0x8000) > 0) {
                    this.fPackageFragmentRootsChanged.put(key, new PackageFragmentRootDelta(path, 4, fragmentisExported));
                } else if ((delta.getFlags() & 0x80) > 0 && (delta.getFlags() & 0x100) == 0) {
                    this.fPackageFragmentRootsAdded.remove(key);
                    this.fPackageFragmentRootsChanged.remove(key);
                    this.fPackageFragmentRootsRemoved.put(key, new PackageFragmentRootDelta(path, 2, fragmentisExported));
                    --this.fBuildPathEntryCount;
                }
            }
            finally {
                this.LOCK.release();
            }
        }
        this.fBuildPathJob.cancel();
        this.fBuildPathJob.schedule(2000L);
    }

    private String readTextofChild(Node node, String childName) {
        NodeList children = node.getChildNodes();
        int i = 0;
        while (i < children.getLength()) {
            Node child = children.item(i);
            if (child.getNodeType() == 1 && child.getNodeName().equals(childName)) {
                return this.getTextContents(child);
            }
            ++i;
        }
        return EMPTY_STRING;
    }

    void removeJAR(IResource jar) {
        JarRecord record;
        if (_debugIndexCreation) {
            Logger.log(1, "removing records for JAR " + String.valueOf(jar.getFullPath()));
        }
        if ((record = (JarRecord)this.fJARReferences.remove(jar.getFullPath().toString())) != null) {
            URLRecord[] records = record.getURLRecords().toArray(new URLRecord[0]);
            int i = 0;
            while (i < records.length) {
                TaglibIndex.getInstance().addDelta(new TaglibIndexDelta(this.fProject, records[i], 2));
                this.getImplicitReferences(jar.getFullPath().toString()).removeFirstPair(records[i].getURI(), records[i]);
                ++i;
            }
            if (record.has11TLD) {
                TaglibIndex.getInstance().addDelta(new TaglibIndexDelta(this.fProject, record, 2));
            }
        }
    }

    void removeTag(IResource resource) {
        TagDirRecord record = (TagDirRecord)this.fTagDirReferences.get(resource.getParent().getFullPath().toString());
        if (record != null) {
            record.tags.remove(resource.getName());
            TaglibIndex.getInstance().addDelta(new TaglibIndexDelta(this.fProject, record, 4));
        }
    }

    void removeTagDir(IResource tagdir) {
        ITaglibRecord record;
        IPath tagdirPath = tagdir.getFullPath();
        if (_debugIndexCreation) {
            Logger.log(1, "removing record for " + String.valueOf(tagdirPath));
        }
        if ((record = (ITaglibRecord)this.fTagDirReferences.remove(tagdirPath.toString())) != null) {
            TaglibIndex.getInstance().addDelta(new TaglibIndexDelta(this.fProject, record, 2));
        }
    }

    void removeTLD(IResource tld) {
        TLDRecord record;
        if (_debugIndexCreation) {
            Logger.log(1, "removing record for " + String.valueOf(tld.getFullPath()));
        }
        if ((record = (TLDRecord)this.fTLDReferences.remove(tld.getFullPath().toString())) != null) {
            if (record.getURI() != null) {
                this.getImplicitReferences(tld.getFullPath().toString()).removeFirstPair(record.getURI(), record);
            }
            TaglibIndex.getInstance().addDelta(new TaglibIndexDelta(this.fProject, record, 2));
        }
    }

    void removeWebXML(IResource webxml) {
        WebXMLRecord record;
        if (_debugIndexCreation) {
            Logger.log(1, "removing records for " + String.valueOf(webxml.getFullPath()));
        }
        if ((record = (WebXMLRecord)this.fWebXMLReferences.remove(webxml.getFullPath().toString())) != null) {
            TLDRecord[] records = record.getTLDRecords().toArray(new TLDRecord[0]);
            int i = 0;
            while (i < records.length) {
                if (_debugIndexCreation) {
                    Logger.log(1, "removed record for " + records[i].getURI() + "@" + String.valueOf(records[i].path));
                }
                this.getImplicitReferences(webxml.getFullPath().toString()).removeFirstPair(records[i].getURI(), records[i]);
                TaglibIndex.getInstance().addDelta(new TaglibIndexDelta(this.fProject, records[i], 2));
                ++i;
            }
        }
    }

    private boolean requestedRefresh() {
        boolean requested = false;
        String[] commandLineArgs = Platform.getCommandLineArgs();
        int i = 0;
        while (i < commandLineArgs.length) {
            requested = requested || "-refresh".equals(commandLineArgs[i]);
            ++i;
        }
        return requested;
    }

    ITaglibRecord resolve(String basePath, String reference) {
        this.ensureUpTodate();
        ITaglibRecord record = null;
        Object path = null;
        try {
            ICatalog catalog;
            Object[] records;
            IPath localWebXML;
            WebXMLRecord webxmlRecord;
            float jspVersion = DeploymentDescriptorPropertyCache.getInstance().getJSPVersion((IPath)new Path(basePath));
            IPath resourcePath = FacetModuleCoreSupport.resolve((IPath)new Path(basePath), reference);
            if (resourcePath.segmentCount() > 1) {
                IFile file;
                String fileExtension = resourcePath.getFileExtension();
                if (fileExtension != null && fileExtension.toLowerCase(Locale.US).equals("tld")) {
                    file = ResourcesPlugin.getWorkspace().getRoot().getFile(resourcePath);
                    if (file.isAccessible()) {
                        path = resourcePath.toString();
                    }
                } else if (fileExtension != null && fileExtension.toLowerCase(Locale.US).equals("jar")) {
                    file = ResourcesPlugin.getWorkspace().getRoot().getFile(resourcePath);
                    if (file.isAccessible()) {
                        path = resourcePath.toString();
                    }
                } else {
                    IFolder folder = ResourcesPlugin.getWorkspace().getRoot().getFolder(resourcePath);
                    if (folder.isAccessible()) {
                        path = resourcePath.toString();
                    }
                }
            }
            this.LOCK.acquire();
            String localRoot = this.getLocalRoot(basePath);
            if (path == null) {
                path = reference.startsWith("/") ? localRoot + reference : URIHelper.normalize((String)reference, (String)basePath, (String)localRoot);
            }
            if ((webxmlRecord = (WebXMLRecord)this.fWebXMLReferences.get((localWebXML = new Path(localRoot).append("/WEB-INF/web.xml")).toString())) != null) {
                int i = 0;
                while (i < webxmlRecord.tldRecords.size()) {
                    ITaglibRecord record2 = (ITaglibRecord)webxmlRecord.tldRecords.get(i);
                    ITaglibDescriptor descriptor = record2.getDescriptor();
                    if (reference.equals(descriptor.getURI())) {
                        record = record2;
                    }
                    ++i;
                }
            }
            if (record == null) {
                record = (ITaglibRecord)this.fJARReferences.get(path);
                if ((double)jspVersion < 1.1 || record instanceof JarRecord && !((JarRecord)record).has11TLD) {
                    record = null;
                }
            }
            if (record == null) {
                record = (ITaglibRecord)this.fTLDReferences.get(path);
            }
            if (record == null && (double)jspVersion >= 1.2 && (records = (Object[])this.getImplicitReferences(basePath).get(reference)) != null && records.length > 0) {
                if (records.length > 1) {
                    records = this.fTaglibSorter.sort(records);
                }
                record = (ITaglibRecord)records[records.length - 1];
            }
            if (record == null && (double)jspVersion >= 2.0) {
                record = (ITaglibRecord)this.fTagDirReferences.get(path);
            }
            if (record == null && (double)jspVersion >= 1.2) {
                record = (ITaglibRecord)this.fClasspathReferences.get(reference);
            }
            if (record == null && (double)jspVersion >= 1.2) {
                HashMap buildPathReferences = new HashMap();
                ArrayList<IProject> projectsProcessed = new ArrayList<IProject>(this.fClasspathProjects.size() + 1);
                projectsProcessed.add(this.fProject);
                this.addBuildPathReferences(buildPathReferences, projectsProcessed, false);
                record = (ITaglibRecord)buildPathReferences.get(reference);
            }
            if (record == null && (catalog = XMLCorePlugin.getDefault().getDefaultXMLCatalog()) != null) {
                String resolvedString = null;
                try {
                    resolvedString = catalog.resolveSystem(reference);
                    if (resolvedString == null || resolvedString.trim().length() == 0) {
                        resolvedString = catalog.resolveURI(reference);
                    }
                    if (resolvedString == null || resolvedString.trim().length() == 0) {
                        resolvedString = catalog.resolvePublic(reference, basePath);
                    }
                }
                catch (Exception e) {
                    Logger.logException(e);
                }
                if (resolvedString != null && resolvedString.trim().length() > 0) {
                    record = this.createCatalogRecord(reference, resolvedString);
                }
            }
            if (record == null && this.fProject.getFullPath().toString().equals(localRoot)) {
                WebXMLRecord[] webxmls = this.fWebXMLReferences.values().toArray(new WebXMLRecord[0]);
                int i = 0;
                while (i < webxmls.length) {
                    Object[] records2;
                    if (record == null && (records2 = (Object[])this.getImplicitReferences(webxmls[i].path.toString()).get(reference)) != null && records2.length > 0) {
                        if (records2.length > 1) {
                            records2 = this.fTaglibSorter.sort(records2);
                        }
                        record = (ITaglibRecord)records2[records2.length - 1];
                    }
                    ++i;
                }
            }
            if (record == null && (double)jspVersion >= 1.2 && (records = (Object[])this.getImplicitReferences(this.fProject.getFullPath().toString()).get(reference)) != null && records.length > 0) {
                if (records.length > 1) {
                    records = this.fTaglibSorter.sort(records);
                }
                record = (ITaglibRecord)records[records.length - 1];
            }
        }
        finally {
            this.LOCK.release();
        }
        return record;
    }

    private void restoreReferences() {
        if (TaglibIndex.ENABLED) {
            boolean restored;
            block51: {
                this.index();
                restored = false;
                File savedState = new File(this.fSaveStateFilename);
                if (savedState.exists() && !this.requestedRefresh()) {
                    Reader reader = null;
                    try {
                        try {
                            this.time0 = System.currentTimeMillis();
                            reader = new InputStreamReader((InputStream)new BufferedInputStream(new FileInputStream(savedState)), "UTF-16");
                            StringBuffer buffer = new StringBuffer();
                            char[] array = new char[2048];
                            int charsRead = 0;
                            while ((charsRead = reader.read(array)) != -1) {
                                if (charsRead <= 0) continue;
                                buffer.append(array, 0, charsRead);
                            }
                            Document doc = new Document();
                            doc.set(buffer.toString());
                            int lines = doc.getNumberOfLines();
                            if (lines > 0) {
                                IRegion line = doc.getLineInformation(0);
                                String lineText = doc.get(line.getOffset(), line.getLength());
                                JarRecord libraryRecord = null;
                                if (SAVE_FORMAT_VERSION.equals(lineText.trim())) {
                                    IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
                                    int i = 1;
                                    while (i < lines && !this.fBuildPathIsDirty) {
                                        line = doc.getLineInformation(i);
                                        lineText = doc.get(line.getOffset(), line.getLength());
                                        StringTokenizer toker = new StringTokenizer(lineText, "|");
                                        if (toker.hasMoreTokens()) {
                                            TaglibInfo info;
                                            String tokenType = toker.nextToken();
                                            if ("JAR".equalsIgnoreCase(tokenType)) {
                                                InputStream contents;
                                                boolean has11TLD = Boolean.valueOf(toker.nextToken());
                                                boolean exported = Boolean.valueOf(toker.nextToken());
                                                Object libraryLocation = toker.nextToken();
                                                while (toker.hasMoreTokens()) {
                                                    libraryLocation = (String)libraryLocation + "|" + toker.nextToken();
                                                }
                                                libraryLocation = ((String)libraryLocation).trim();
                                                if (libraryRecord != null) {
                                                    TaglibIndex.getInstance().addDelta(new TaglibIndexDelta(this.fProject, libraryRecord, 1));
                                                }
                                                libraryRecord = this.createJARRecord((String)libraryLocation);
                                                libraryRecord.has11TLD = has11TLD;
                                                libraryRecord.isExported = exported;
                                                if (has11TLD && (contents = JarUtilities.getInputStream((String)libraryLocation, (String)"META-INF/taglib.tld")) != null) {
                                                    info = this.extractInfo((String)libraryLocation, contents);
                                                    if (info != null && info.uri != null && info.uri.length() > 0) {
                                                        URLRecord urlRecord = new URLRecord();
                                                        urlRecord.info = info;
                                                        urlRecord.isExported = exported;
                                                        urlRecord.baseLocation = libraryLocation;
                                                        try {
                                                            urlRecord.url = new URL("jar:file:" + (String)libraryLocation + "!/META-INF/taglib.tld");
                                                            libraryRecord.urlRecords.add(urlRecord);
                                                            this.fClasspathReferences.put(urlRecord.getURI(), urlRecord);
                                                            if (_debugIndexCreation) {
                                                                Logger.log(1, "created record for " + urlRecord.getURI() + "@" + String.valueOf(urlRecord.getURL()));
                                                            }
                                                        }
                                                        catch (MalformedURLException e) {
                                                            Logger.logException(e);
                                                        }
                                                    }
                                                    try {
                                                        contents.close();
                                                    }
                                                    catch (IOException e) {
                                                        Logger.log(204, null, e);
                                                    }
                                                }
                                                this.fClasspathJars.put(libraryLocation, libraryRecord);
                                            } else if ("URL".equalsIgnoreCase(tokenType) && libraryRecord != null) {
                                                boolean exported = Boolean.valueOf(toker.nextToken());
                                                Object urlString = toker.nextToken();
                                                while (toker.hasMoreTokens()) {
                                                    urlString = (String)urlString + "|" + toker.nextToken();
                                                }
                                                urlString = ((String)urlString).trim();
                                                URLRecord urlRecord = new URLRecord();
                                                urlRecord.url = new URL((String)urlString);
                                                urlRecord.isExported = exported;
                                                urlRecord.baseLocation = libraryRecord.location.toString();
                                                InputStream tldStream = JarUtilities.getInputStream((URL)urlRecord.url);
                                                if (tldStream != null) {
                                                    info = this.extractInfo(urlRecord.url.toString(), tldStream);
                                                    if (info != null) {
                                                        urlRecord.info = info;
                                                    }
                                                    libraryRecord.urlRecords.add(urlRecord);
                                                    try {
                                                        tldStream.close();
                                                    }
                                                    catch (IOException e) {
                                                        Logger.log(204, null, e);
                                                    }
                                                    if (urlRecord.getURI() != null && urlRecord.getURI().length() > 0) {
                                                        this.fClasspathReferences.put(urlRecord.getURI(), urlRecord);
                                                    }
                                                }
                                            } else if (BUILDPATH_PROJECT.equalsIgnoreCase(tokenType)) {
                                                IProject project;
                                                String projectName = toker.nextToken();
                                                if (Path.ROOT.isValidSegment(projectName) && (project = workspaceRoot.getProject(projectName)) != null) {
                                                    this.fClasspathProjects.add(project);
                                                }
                                            } else if (BUILDPATH_DIRTY.equalsIgnoreCase(tokenType)) {
                                                this.fBuildPathIsDirty = Boolean.valueOf(toker.nextToken());
                                            } else if (BUILDPATH_ENTRIES.equalsIgnoreCase(tokenType)) {
                                                this.fBuildPathEntryCount = Integer.valueOf(toker.nextToken());
                                            }
                                        }
                                        if (libraryRecord != null) {
                                            TaglibIndex.getInstance().addDelta(new TaglibIndexDelta(this.fProject, libraryRecord, 1));
                                        }
                                        ++i;
                                    }
                                    restored = true;
                                } else {
                                    Logger.log(201, "Tag Library Index: different cache format found, was \"" + lineText + "\", supports \"Tag Library Index 1.1.0\", reindexing build path");
                                }
                            }
                            if (_debugIndexTime) {
                                Logger.log(1, "time spent reloading " + this.fProject.getName() + " build path: " + (System.currentTimeMillis() - this.time0));
                            }
                        }
                        catch (Exception e) {
                            restored = false;
                            if (_debugIndexTime) {
                                Logger.log(1, "failure reloading " + this.fProject.getName() + " build path index", e);
                            }
                            if (reader != null) {
                                try {
                                    reader.close();
                                }
                                catch (IOException e2) {
                                    Logger.log(204, null, e2);
                                }
                            }
                            break block51;
                        }
                    }
                    catch (Throwable throwable) {
                        if (reader != null) {
                            try {
                                reader.close();
                            }
                            catch (IOException e) {
                                Logger.log(204, null, e);
                            }
                        }
                        throw throwable;
                    }
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (IOException e) {
                            Logger.log(204, null, e);
                        }
                    }
                }
            }
            if (!restored) {
                this.setBuildPathIsDirty();
            }
        }
    }

    void saveReferences() {
        block18: {
            this.time0 = System.currentTimeMillis();
            Writer writer = null;
            try {
                try {
                    writer = new OutputStreamWriter((OutputStream)new FileOutputStream(this.fSaveStateFilename), "UTF-16");
                    writer.write(SAVE_FORMAT_VERSION);
                    writer.write(10);
                    writer.write("BUILDPATH_DIRTY|" + this.fBuildPathIsDirty);
                    writer.write(10);
                    writer.write("BUILDPATH_ENTRIES|" + this.fBuildPathEntryCount);
                    writer.write(10);
                    IProject[] projects = this.fClasspathProjects.toArray(new IProject[0]);
                    int i = 0;
                    while (i < projects.length) {
                        writer.write(BUILDPATH_PROJECT);
                        writer.write("|");
                        writer.write(projects[i].getName());
                        writer.write(10);
                        ++i;
                    }
                    Enumeration jars = this.fClasspathJars.keys();
                    while (jars.hasMoreElements()) {
                        String jarPath = jars.nextElement().toString();
                        JarRecord jarRecord = (JarRecord)this.fClasspathJars.get(jarPath);
                        writer.write("JAR|");
                        writer.write(Boolean.toString(jarRecord.has11TLD));
                        writer.write(124);
                        writer.write(Boolean.toString(jarRecord.isExported));
                        writer.write(124);
                        writer.write(jarPath);
                        writer.write(10);
                        for (URLRecord urlRecord : jarRecord.urlRecords) {
                            writer.write("URL|");
                            writer.write(String.valueOf(urlRecord.isExported));
                            writer.write("|");
                            writer.write(urlRecord.getURL().toExternalForm());
                            writer.write(10);
                        }
                    }
                }
                catch (IOException e) {
                    Logger.log(204, null, e);
                    try {
                        if (writer != null) {
                            writer.close();
                        }
                        break block18;
                    }
                    catch (Exception e2) {
                        Logger.log(204, null, e2);
                    }
                    break block18;
                }
            }
            catch (Throwable throwable) {
                try {
                    if (writer != null) {
                        writer.close();
                    }
                }
                catch (Exception e) {
                    Logger.log(204, null, e);
                }
                throw throwable;
            }
            try {
                if (writer != null) {
                    writer.close();
                }
            }
            catch (Exception e) {
                Logger.log(204, null, e);
            }
        }
        if (_debugIndexTime) {
            Logger.log(1, "time spent saving index for " + this.fProject.getName() + ": " + (System.currentTimeMillis() - this.time0));
        }
    }

    void setBuildPathIsDirty() {
        this.fBuildPathIsDirty = true;
        if (_debugIndexTime) {
            Logger.log(1, "marking build path information for " + this.fProject.getName() + " as dirty");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateClasspathLibrary(String libraryLocation, int deltaKind, boolean isExported) {
        JarRecord libraryRecord = null;
        if (deltaKind == 2 || deltaKind == 4) {
            libraryRecord = (JarRecord)this.fClasspathJars.remove(libraryLocation);
            Map map = fSharedJarRecords;
            synchronized (map) {
                fSharedJarRecords.remove(libraryLocation);
            }
            if (libraryRecord != null) {
                IURLRecord[] urlRecords = libraryRecord.urlRecords.toArray(new IURLRecord[0]);
                int i = 0;
                while (i < urlRecords.length) {
                    ITaglibRecord record = (ITaglibRecord)this.fClasspathReferences.remove(urlRecords[i].getURI());
                    if (record != null) {
                        TaglibIndex.getInstance().addDelta(new TaglibIndexDelta(this.fProject, record, 2));
                    }
                    ++i;
                }
            }
        }
        if (deltaKind == 1 || deltaKind == 4) {
            libraryRecord = this.createJARRecord(libraryLocation);
            ArrayList<TaglibIndexDelta> tempDeltas = new ArrayList<TaglibIndexDelta>();
            JarRecord i = libraryRecord;
            synchronized (i) {
                block31: {
                    if (libraryRecord.isConsistent) {
                        this.fClasspathJars.put(libraryLocation, libraryRecord);
                        for (URLRecord record : libraryRecord.urlRecords) {
                            int urlDeltaKind = 1;
                            if (this.fClasspathReferences.containsKey(record.getURI())) {
                                urlDeltaKind = 4;
                            }
                            this.fClasspathReferences.put(record.getURI(), record);
                            tempDeltas.add(new TaglibIndexDelta(this.fProject, record, urlDeltaKind));
                            this.fClasspathReferences.put(record.info.uri, record);
                        }
                        return;
                    }
                    libraryRecord.isExported = isExported;
                    this.fClasspathJars.put(libraryLocation, libraryRecord);
                    ZipFile jarfile = null;
                    try {
                        jarfile = new ZipFile(libraryLocation);
                        Enumeration<? extends ZipEntry> entries = jarfile.entries();
                        while (entries.hasMoreElements()) {
                            InputStream contents;
                            ZipEntry z = entries.nextElement();
                            if (z.isDirectory() || !this.isTLD(z.getName())) continue;
                            if (z.getName().equals("META-INF/taglib.tld")) {
                                libraryRecord.has11TLD = true;
                            }
                            if ((contents = this.getCachedInputStream(jarfile, z)) == null) continue;
                            TaglibInfo info = this.extractInfo(libraryLocation, contents);
                            if (info != null && info.uri != null && info.uri.length() > 0) {
                                URLRecord urlRecord = new URLRecord();
                                urlRecord.info = info;
                                urlRecord.baseLocation = libraryLocation;
                                try {
                                    urlRecord.isExported = isExported;
                                    urlRecord.url = new URL("jar:file:" + libraryLocation + "!/" + z.getName());
                                    libraryRecord.urlRecords.add(urlRecord);
                                    int urlDeltaKind = 1;
                                    if (this.fClasspathReferences.containsKey(urlRecord.getURI())) {
                                        urlDeltaKind = 4;
                                    }
                                    this.fClasspathReferences.put(urlRecord.getURI(), urlRecord);
                                    tempDeltas.add(new TaglibIndexDelta(this.fProject, urlRecord, urlDeltaKind));
                                    this.fClasspathReferences.put(info.uri, urlRecord);
                                    if (_debugIndexCreation) {
                                        Logger.log(1, "created record for " + urlRecord.getURI() + "@" + String.valueOf(urlRecord.getURL()));
                                    }
                                }
                                catch (MalformedURLException e) {
                                    Logger.logException(e);
                                }
                            }
                            try {
                                contents.close();
                            }
                            catch (IOException e) {
                                Logger.log(204, null, e);
                            }
                        }
                    }
                    catch (ZipException zExc) {
                        Logger.log(2, "Taglib Index ZipException: " + libraryLocation + " " + zExc.getMessage());
                        this.closeJarFile(jarfile);
                        break block31;
                    }
                    catch (IOException ioExc) {
                        try {
                            Logger.log(2, "Taglib Index IOException: " + libraryLocation + " " + ioExc.getMessage());
                            this.closeJarFile(jarfile);
                            break block31;
                        }
                        catch (Throwable throwable) {
                            this.closeJarFile(jarfile);
                            throw throwable;
                        }
                    }
                    this.closeJarFile(jarfile);
                }
                libraryRecord.isConsistent = true;
            }
            Iterator it = tempDeltas.iterator();
            while (it.hasNext()) {
                TaglibIndex.getInstance().addDelta((TaglibIndexDelta)it.next());
            }
        }
        if (libraryRecord != null) {
            TaglibIndex.getInstance().addDelta(new TaglibIndexDelta(this.fProject, libraryRecord, deltaKind));
        }
    }

    private boolean isTLD(String name) {
        if (name == null) {
            return false;
        }
        int length = name.length();
        if (length < 4) {
            return false;
        }
        if (name.charAt(length - 4) != '.') {
            return false;
        }
        int i = length - 3;
        int j = 0;
        while (i < length) {
            char c = name.charAt(i);
            if (c != TLD[2 * j] && c != TLD[2 * j + 1]) {
                return false;
            }
            ++i;
            ++j;
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void updateJAR(IResource jar, int deltaKind) {
        JarRecord jarRecord;
        block18: {
            if (_debugIndexCreation) {
                Logger.log(1, "creating records for JAR " + String.valueOf(jar.getFullPath()));
            }
            String jarLocationString = null;
            jarLocationString = jar.getLocation() != null ? jar.getLocation().toString() : jar.getLocationURI().toString();
            jarRecord = this.createJARRecord(jar);
            this.fJARReferences.put(jar.getFullPath().toString(), jarRecord);
            ZipInputStream zip = this.getZipInputStream(jar);
            if (zip != null) {
                try {
                    try {
                        ZipEntry entry;
                        while ((entry = zip.getNextEntry()) != null) {
                            InputStream contents;
                            if (!this.isTLD(entry.getName())) continue;
                            if (entry.getName().equals("META-INF/taglib.tld")) {
                                jarRecord.has11TLD = true;
                            }
                            if ((contents = this.copyZipEntry(zip)) != null) {
                                TaglibInfo info = this.extractInfo(jarLocationString, contents);
                                if (info != null && info.uri != null && info.uri.length() > 0) {
                                    URLRecord record = new URLRecord();
                                    record.info = info;
                                    record.baseLocation = jarLocationString;
                                    try {
                                        record.url = new URL("jar:file:" + jarLocationString + "!/" + entry.getName());
                                        jarRecord.urlRecords.add(record);
                                        int taglibDeltaKind = 1;
                                        ArrayMap table = this.getImplicitReferences(jar.getFullPath().toString());
                                        if (table != null && table.get(record.getURI()) != null) {
                                            taglibDeltaKind = 4;
                                        }
                                        this.getImplicitReferences(jar.getFullPath().toString()).put(info.uri, record);
                                        TaglibIndex.getInstance().addDelta(new TaglibIndexDelta(this.fProject, record, taglibDeltaKind));
                                        if (_debugIndexCreation) {
                                            Logger.log(1, "created record for " + record.getURI() + "@" + String.valueOf(record.getURL()));
                                        }
                                    }
                                    catch (MalformedURLException e) {
                                        Logger.logException(e);
                                    }
                                }
                                try {
                                    contents.close();
                                }
                                catch (IOException e) {
                                    Logger.log(204, null, e);
                                }
                                continue;
                            }
                            Logger.log(204, this.getClass().getName() + "could not read resource " + String.valueOf(jar.getFullPath()));
                        }
                    }
                    catch (IOException iOException) {
                        this.closeInputStream(zip);
                        break block18;
                    }
                }
                catch (Throwable throwable) {
                    this.closeInputStream(zip);
                    throw throwable;
                }
                this.closeInputStream(zip);
            }
        }
        if (jarRecord.has11TLD) {
            TaglibIndex.getInstance().addDelta(new TaglibIndexDelta(this.fProject, jarRecord, deltaKind));
        }
    }

    private InputStream copyZipEntry(ZipInputStream stream) {
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        ByteArrayInputStream copy = null;
        if (stream != null) {
            byte[] bytes = new byte[2048];
            try {
                int c;
                while ((c = stream.read(bytes)) >= 0) {
                    buffer.write(bytes, 0, c);
                }
                copy = new ByteArrayInputStream(buffer.toByteArray());
                this.closeZipEntry(stream);
            }
            catch (IOException iOException) {}
        }
        return copy;
    }

    private ZipInputStream getZipInputStream(IResource jar) {
        if (jar == null || jar.getType() != 1 || !jar.isAccessible()) {
            return null;
        }
        try {
            InputStream zipStream = ((IFile)jar).getContents();
            return new ZipInputStream(zipStream);
        }
        catch (CoreException coreException) {
            return null;
        }
    }

    private void closeInputStream(InputStream stream) {
        if (stream != null) {
            try {
                stream.close();
            }
            catch (IOException iOException) {}
        }
    }

    private void closeZipEntry(ZipInputStream zis) {
        if (zis != null) {
            try {
                zis.closeEntry();
            }
            catch (IOException iOException) {
                System.out.println("Error");
            }
        }
    }

    void updateTag(IResource resource, int kind) {
        TagDirRecord record = (TagDirRecord)this.fTagDirReferences.get(resource.getParent().getFullPath().toString());
        if (record == null) {
            record = this.createTagdirRecord(resource.getParent());
            this.fTagDirReferences.put(resource.getParent().getFullPath().toString(), record);
            TaglibIndex.getInstance().addDelta(new TaglibIndexDelta(this.fProject, record, 1));
        } else {
            if (!record.tags.contains(resource.getName())) {
                record.tags.add(resource.getName());
            }
            TaglibIndex.getInstance().addDelta(new TaglibIndexDelta(this.fProject, record, 4));
        }
    }

    void updateTagDir(IResource tagdirResource, int deltaKind) {
        if ((tagdirResource.getType() & 2) != 0) {
            TagDirRecord record;
            if (_debugIndexCreation) {
                Logger.log(1, "creating record for directory " + String.valueOf(tagdirResource.getFullPath()));
            }
            if ((record = (TagDirRecord)this.fTagDirReferences.get(tagdirResource.getFullPath().toString())) == null) {
                record = this.createTagdirRecord((IContainer)((IFolder)tagdirResource));
                this.fTagDirReferences.put(tagdirResource.getFullPath().toString(), record);
                TaglibIndex.getInstance().addDelta(new TaglibIndexDelta(this.fProject, record, deltaKind));
            }
        }
    }

    void updateTLD(String fullpath, TLDRecord record, int deltaKind) {
        if (_debugIndexCreation) {
            Logger.log(1, "creating record for " + fullpath);
        }
        this.fTLDReferences.put(fullpath, record);
        if (record.getURI() != null && record.getURI().length() > 0) {
            this.getImplicitReferences(fullpath).put(record.getURI(), record);
        }
        TaglibIndex.getInstance().addDelta(new TaglibIndexDelta(this.fProject, record, deltaKind));
    }

    void updateTLD(IResource tld, int deltaKind) {
        this.updateTLD(tld.getFullPath().toString(), this.createTLDRecord(tld), deltaKind);
    }

    void updateWebXML(IResource webxml, int deltaKind) {
        org.w3c.dom.Document document;
        block31: {
            if (webxml.getType() != 1) {
                return;
            }
            InputStream webxmlContents = null;
            document = null;
            try {
                try {
                    webxmlContents = ((IFile)webxml).getContents(false);
                    DocumentProvider provider = new DocumentProvider();
                    provider.setInputStream(webxmlContents);
                    provider.setValidating(false);
                    provider.setRootElementName("web-app");
                    provider.setBaseReference(webxml.getParent().getFullPath().toString());
                    document = provider.getDocument(false);
                }
                catch (CoreException e) {
                    Logger.log(204, EMPTY_STRING, e);
                    if (webxmlContents != null) {
                        try {
                            webxmlContents.close();
                        }
                        catch (IOException e1) {
                            Logger.log(204, null, e1);
                        }
                    }
                    break block31;
                }
            }
            catch (Throwable throwable) {
                if (webxmlContents != null) {
                    try {
                        webxmlContents.close();
                    }
                    catch (IOException e1) {
                        Logger.log(204, null, e1);
                    }
                }
                throw throwable;
            }
            if (webxmlContents != null) {
                try {
                    webxmlContents.close();
                }
                catch (IOException e1) {
                    Logger.log(204, null, e1);
                }
            }
        }
        if (document == null) {
            return;
        }
        if (_debugIndexCreation) {
            Logger.log(1, "creating records for " + String.valueOf(webxml.getFullPath()));
        }
        WebXMLRecord webxmlRecord = new WebXMLRecord();
        webxmlRecord.path = webxml.getFullPath();
        this.fWebXMLReferences.put(webxmlRecord.getWebXML().toString(), webxmlRecord);
        NodeList taglibs = document.getElementsByTagName("taglib");
        int iTaglib = 0;
        while (iTaglib < taglibs.getLength()) {
            IFile resource;
            String taglibUri = this.readTextofChild(taglibs.item(iTaglib), "taglib-uri").trim();
            String taglibLocation = this.readTextofChild(taglibs.item(iTaglib), "taglib-location").trim();
            Object path = null;
            path = taglibLocation.startsWith("/") ? FacetModuleCoreSupport.resolve((IPath)new Path(webxml.getFullPath().toString()), taglibLocation) : new Path(URIHelper.normalize((String)taglibLocation, (String)webxml.getFullPath().toString(), (String)this.getLocalRoot(webxml.getFullPath().toString())));
            if (path.segmentCount() > 1 && (resource = ResourcesPlugin.getWorkspace().getRoot().getFile(path)).isAccessible()) {
                ITaglibRecord record = null;
                if ("jar".equalsIgnoreCase(resource.getFileExtension())) {
                    JarRecord jarRecord = this.createJARRecord((IResource)resource);
                    String[] entries = JarUtilities.getEntryNames((IResource)resource);
                    int jEntry = 0;
                    while (jEntry < entries.length) {
                        if (entries[jEntry].endsWith(".tld") && entries[jEntry].equals("META-INF/taglib.tld")) {
                            jarRecord.has11TLD = true;
                            InputStream contents = JarUtilities.getInputStream((IResource)resource, (String)entries[jEntry]);
                            if (contents != null) {
                                TaglibInfo info;
                                jarRecord.info = info = this.extractInfo(resource.getFullPath().toString(), contents);
                                try {
                                    contents.close();
                                }
                                catch (IOException e) {
                                    Logger.log(204, null, e);
                                }
                            }
                        }
                        ++jEntry;
                    }
                    record = jarRecord;
                    if (jarRecord.info == null) {
                        jarRecord.info = new TaglibInfo();
                    }
                    jarRecord.info.uri = taglibUri;
                    jarRecord.isMappedInWebXML = true;
                    if (_debugIndexCreation) {
                        Logger.log(1, "created web.xml record for " + taglibUri + "@" + String.valueOf(jarRecord.getLocation()));
                    }
                } else {
                    TLDRecord tldRecord;
                    record = tldRecord = this.createTLDRecord((IResource)resource);
                    if (tldRecord.info != null) {
                        tldRecord.info.uri = taglibUri;
                    }
                    if (_debugIndexCreation) {
                        Logger.log(1, "created web.xml record for " + taglibUri + "@" + String.valueOf(tldRecord.getPath()));
                    }
                }
                if (record != null) {
                    webxmlRecord.tldRecords.add(record);
                    this.getImplicitReferences(webxml.getFullPath().toString()).put(taglibUri, record);
                    TaglibIndex.getInstance().addDelta(new TaglibIndexDelta(this.fProject, record, deltaKind));
                }
            }
            ++iTaglib;
        }
    }

    class BuildPathJob
    extends Job {
        public BuildPathJob() {
            super("Updating Tag Library Index");
            this.setSystem(true);
            this.setUser(false);
        }

        protected IStatus run(IProgressMonitor monitor) {
            try {
                ProjectDescription.this.LOCK.acquire();
                PackageFragmentRootDelta[] removes = ProjectDescription.this.fPackageFragmentRootsRemoved.values().toArray(new PackageFragmentRootDelta[ProjectDescription.this.fPackageFragmentRootsRemoved.size()]);
                int i = 0;
                while (i < removes.length) {
                    ProjectDescription.this.handleElementChanged(removes[i].elementPath, removes[i].deltaKind, removes[i].isExported);
                    ++i;
                }
                ProjectDescription.this.fPackageFragmentRootsRemoved.clear();
                if (monitor.isCanceled()) {
                    IStatus iStatus = Status.OK_STATUS;
                    return iStatus;
                }
                PackageFragmentRootDelta[] changes = ProjectDescription.this.fPackageFragmentRootsChanged.values().toArray(new PackageFragmentRootDelta[ProjectDescription.this.fPackageFragmentRootsChanged.size()]);
                int i2 = 0;
                while (i2 < changes.length) {
                    ProjectDescription.this.handleElementChanged(changes[i2].elementPath, changes[i2].deltaKind, changes[i2].isExported);
                    ++i2;
                }
                ProjectDescription.this.fPackageFragmentRootsChanged.clear();
                if (monitor.isCanceled()) {
                    IStatus iStatus = Status.OK_STATUS;
                    return iStatus;
                }
                PackageFragmentRootDelta[] adds = ProjectDescription.this.fPackageFragmentRootsAdded.values().toArray(new PackageFragmentRootDelta[ProjectDescription.this.fPackageFragmentRootsAdded.size()]);
                int i3 = 0;
                while (i3 < adds.length) {
                    ProjectDescription.this.handleElementChanged(adds[i3].elementPath, adds[i3].deltaKind, adds[i3].isExported);
                    ++i3;
                }
                ProjectDescription.this.fPackageFragmentRootsAdded.clear();
            }
            finally {
                ProjectDescription.this.LOCK.release();
            }
            TaglibIndex.getInstance().fireCurrentDelta((Object)this);
            return Status.OK_STATUS;
        }
    }

    class DeltaVisitor
    implements IResourceDeltaVisitor {
        DeltaVisitor() {
        }

        public boolean visit(IResourceDelta delta) throws CoreException {
            IResource resource = delta.getResource();
            if (resource.getType() == 1) {
                if (delta.getKind() == 4 && (delta.getFlags() == 0x100000 || delta.getFlags() == 131072)) {
                    return true;
                }
                if (resource.getName().endsWith(".tld")) {
                    if (delta.getKind() == 2) {
                        ProjectDescription.this.removeTLD(resource);
                    } else {
                        ProjectDescription.this.updateTLD(resource, delta.getKind());
                    }
                } else if (resource.getName().endsWith(".jar")) {
                    if (delta.getKind() == 2) {
                        ProjectDescription.this.removeJAR(resource);
                    } else {
                        ProjectDescription.this.updateJAR(resource, delta.getKind());
                    }
                } else if ("tag".equalsIgnoreCase(resource.getFileExtension()) || "tagx".equalsIgnoreCase(resource.getFileExtension())) {
                    if (delta.getKind() == 2) {
                        ProjectDescription.this.removeTag(resource);
                    } else {
                        ProjectDescription.this.updateTag(resource, delta.getKind());
                    }
                } else if (resource.getName().equals(ProjectDescription.WEB_XML) && resource.getParent().getName().equals(ProjectDescription.WEB_INF)) {
                    if (delta.getKind() == 2) {
                        ProjectDescription.this.removeWebXML(resource);
                    } else {
                        ProjectDescription.this.updateWebXML(resource, delta.getKind());
                    }
                }
            }
            return resource.getName().length() != 0 && resource.getName().charAt(0) != '.';
        }
    }

    class Indexer
    implements IResourceProxyVisitor {
        Indexer() {
        }

        public boolean visit(IResourceProxy proxy) throws CoreException {
            String name;
            if (proxy.isDerived()) {
                return false;
            }
            boolean visitMembers = true;
            if (proxy.getType() == 1) {
                if (proxy.getName().endsWith(".tld")) {
                    ProjectDescription.this.updateTLD(proxy.requestResource(), 1);
                } else if (proxy.getName().endsWith(".jar")) {
                    try {
                        ProjectDescription.this.updateJAR(proxy.requestResource(), 1);
                    }
                    catch (Exception exception) {}
                } else if (proxy.getName().endsWith(".tag") || proxy.getName().endsWith(".tagx")) {
                    ProjectDescription.this.updateTagDir((IResource)proxy.requestResource().getParent(), 1);
                    visitMembers = false;
                } else if (proxy.getName().equals(ProjectDescription.WEB_XML) && proxy.requestResource().getParent().getName().equals(ProjectDescription.WEB_INF)) {
                    ProjectDescription.this.updateWebXML(proxy.requestResource(), 1);
                }
            }
            return (name = proxy.getName()).length() != 0 && (name.charAt(0) != '.' || proxy.getType() == 4) && visitMembers && !proxy.isDerived();
        }
    }

    static class JarRecord
    implements IJarRecord {
        boolean has11TLD;
        TaglibInfo info;
        boolean isExported = true;
        boolean isMappedInWebXML;
        boolean isConsistent = false;
        IPath location;
        Collection urlRecords;

        JarRecord() {
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof JarRecord)) {
                return false;
            }
            return ((JarRecord)obj).location.equals((Object)this.location) && ((JarRecord)obj).has11TLD == this.has11TLD && ((JarRecord)obj).info.equals(this.info);
        }

        @Override
        public ITaglibDescriptor getDescriptor() {
            return this.info != null ? this.info : new TaglibInfo();
        }

        @Override
        public IPath getLocation() {
            return this.location;
        }

        @Override
        public int getRecordType() {
            return 2;
        }

        @Override
        public String getShortName() {
            if (this.info == null) {
                return null;
            }
            return this.info.shortName;
        }

        @Override
        public String getURI() {
            if (this.info == null) {
                return null;
            }
            return this.info.uri;
        }

        public Collection getURLRecords() {
            return this.urlRecords;
        }

        public String toString() {
            StringBuffer s = new StringBuffer("JarRecord: ");
            s.append(this.location);
            if (this.urlRecords.size() > 0) {
                s.append('\n');
                Iterator it = this.urlRecords.iterator();
                while (it.hasNext()) {
                    s.append(it.next());
                    s.append('\n');
                }
            }
            return s.toString();
        }
    }

    class PackageFragmentRootDelta {
        int deltaKind;
        IPath elementPath;
        boolean isExported;

        PackageFragmentRootDelta(IPath path, int kind, boolean exported) {
            this.elementPath = path;
            this.deltaKind = kind;
            this.isExported = exported;
        }
    }

    static class TLDRecord
    implements ITLDRecord {
        TaglibInfo info;
        IPath path;

        TLDRecord() {
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof TLDRecord)) {
                return false;
            }
            return ((TLDRecord)obj).path.equals((Object)this.path) && ((TLDRecord)obj).getURI().equals(this.getURI()) && (((TLDRecord)obj).info == null && this.info == null || ((TLDRecord)obj).info.equals(this.info));
        }

        @Override
        public ITaglibDescriptor getDescriptor() {
            return this.info != null ? this.info : new TaglibInfo();
        }

        @Override
        public IPath getPath() {
            return this.path;
        }

        @Override
        public int getRecordType() {
            return 1;
        }

        @Override
        public String getShortName() {
            if (this.info == null) {
                return null;
            }
            return this.info.shortName;
        }

        @Override
        public String getURI() {
            if (this.info == null) {
                return null;
            }
            return this.info.uri;
        }

        public String toString() {
            return "TLDRecord: " + this.getURI() + " <-> " + String.valueOf(this.path);
        }
    }

    static class TagDirRecord
    implements ITagDirRecord {
        TaglibInfo info;
        IPath path;
        List tags = new ArrayList(0);

        TagDirRecord() {
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof TagDirRecord)) {
                return false;
            }
            return ((TagDirRecord)obj).path.equals((Object)this.path) && ((TagDirRecord)obj).info.equals(this.info);
        }

        @Override
        public ITaglibDescriptor getDescriptor() {
            return this.info != null ? this.info : (this.info = new TaglibInfo());
        }

        @Override
        public IPath getPath() {
            return this.path;
        }

        @Override
        public int getRecordType() {
            return 8;
        }

        public String[] getTagFilenames() {
            return this.tags.toArray(new String[this.tags.size()]);
        }

        public String toString() {
            return "TagdirRecord: " + String.valueOf(this.path) + " <-> " + this.info.shortName;
        }
    }

    static class TaglibInfo
    implements ITaglibDescriptor {
        String description = "";
        String displayName = "";
        String jspVersion = "";
        String largeIcon = "";
        String shortName = "";
        String smallIcon = "";
        String tlibVersion = "";
        String uri = "";

        public boolean equals(Object obj) {
            if (!(obj instanceof TaglibInfo)) {
                return false;
            }
            return ((TaglibInfo)obj).jspVersion.equals(this.jspVersion) && ((TaglibInfo)obj).description.equals(this.description) && ((TaglibInfo)obj).largeIcon.equals(this.largeIcon) && ((TaglibInfo)obj).shortName.equals(this.shortName) && ((TaglibInfo)obj).smallIcon.equals(this.smallIcon) && ((TaglibInfo)obj).tlibVersion.equals(this.tlibVersion) && ((TaglibInfo)obj).uri.equals(this.uri);
        }

        @Override
        public String getDescription() {
            return this.description;
        }

        @Override
        public String getDisplayName() {
            return this.displayName;
        }

        @Override
        public String getJSPVersion() {
            return this.jspVersion;
        }

        @Override
        public String getLargeIcon() {
            return this.largeIcon;
        }

        @Override
        public String getShortName() {
            return this.shortName;
        }

        @Override
        public String getSmallIcon() {
            return this.smallIcon;
        }

        @Override
        public String getTlibVersion() {
            return this.tlibVersion;
        }

        @Override
        public String getURI() {
            return this.uri;
        }

        public String toString() {
            return "TaglibInfo|" + this.uri + "|" + this.shortName + "|" + this.tlibVersion + "|" + this.smallIcon + "|" + this.largeIcon + "|" + this.jspVersion + "|" + this.description;
        }
    }

    private class TaglibSorter
    extends Sorter {
        Collator collator = Collator.getInstance();

        TaglibSorter() {
        }

        public boolean compare(Object elementOne, Object elementTwo) {
            return this.collator.compare(this.getTaglibPath((ITaglibRecord)elementOne), this.getTaglibPath((ITaglibRecord)elementTwo)) < 0;
        }

        private String getTaglibPath(ITaglibRecord record) {
            switch (record.getRecordType()) {
                case 2: {
                    return ((JarRecord)record).getLocation().toString();
                }
                case 8: {
                    return ((TagDirRecord)record).getPath().toString();
                }
                case 1: {
                    return ((TLDRecord)record).getPath().toString();
                }
                case 4: {
                    return ((URLRecord)record).getBaseLocation();
                }
            }
            return ProjectDescription.EMPTY_STRING;
        }
    }

    static class URLRecord
    implements IURLRecord {
        String baseLocation;
        TaglibInfo info;
        boolean isExported = true;
        URL url;

        public boolean equals(Object obj) {
            if (!(obj instanceof URLRecord)) {
                return false;
            }
            return ((URLRecord)obj).baseLocation.equals(this.baseLocation) && ((URLRecord)obj).url.equals(this.url) && ((URLRecord)obj).info.equals(this.info);
        }

        public int hashCode() {
            return this.baseLocation.hashCode() + this.url.hashCode() + (this.isExported ? 1 : 0);
        }

        @Override
        public String getBaseLocation() {
            return this.baseLocation;
        }

        @Override
        public ITaglibDescriptor getDescriptor() {
            return this.info != null ? this.info : new TaglibInfo();
        }

        @Override
        public int getRecordType() {
            return 4;
        }

        @Override
        public String getShortName() {
            if (this.info == null) {
                return null;
            }
            return this.info.shortName;
        }

        @Override
        public String getURI() {
            if (this.info == null) {
                return ProjectDescription.EMPTY_STRING;
            }
            return this.info.uri;
        }

        @Override
        public URL getURL() {
            return this.url;
        }

        public String toString() {
            return "URLRecord: (exported=" + this.isExported + ") " + this.baseLocation + " <-> " + this.getURI();
        }
    }

    static class WebXMLRecord {
        TaglibInfo info;
        IPath path;
        List tldRecords = new ArrayList(0);

        WebXMLRecord() {
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof WebXMLRecord)) {
                return false;
            }
            return ((WebXMLRecord)obj).path.equals((Object)this.path) && ((WebXMLRecord)obj).info.equals(this.info);
        }

        public String getPrefix() {
            if (this.info == null) {
                return null;
            }
            return this.info.shortName;
        }

        public List getTLDRecords() {
            return this.tldRecords;
        }

        public IPath getWebXML() {
            return this.path;
        }

        public String toString() {
            StringBuffer s = new StringBuffer("WebXMLRecord: ");
            s.append(this.path);
            if (this.tldRecords.size() > 0) {
                s.append('\n');
                int i = 0;
                while (i < this.tldRecords.size()) {
                    s.append(this.tldRecords.get(i));
                    s.append('\n');
                    ++i;
                }
            }
            return s.toString();
        }
    }
}

