/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.resources.undo.snapshot;

import org.eclipse.core.internal.resources.undo.snapshot.ContainerSnapshot;
import org.eclipse.core.internal.resources.undo.snapshot.ResourceSnapshotMessages;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;

public class ProjectSnapshot
extends ContainerSnapshot<IProject> {
    private IProjectDescription projectDescription;
    private boolean openOnCreate = true;

    public ProjectSnapshot(IProject project) {
        super(project);
        Assert.isLegal((boolean)project.exists());
        if (project.isOpen()) {
            try {
                this.projectDescription = project.getDescription();
            }
            catch (CoreException coreException) {}
        } else {
            this.openOnCreate = false;
        }
    }

    public ProjectSnapshot(IProjectDescription projectDescription) {
        this.projectDescription = projectDescription;
    }

    @Override
    public IProject createResourceHandle() {
        return ResourcesPlugin.getWorkspace().getRoot().getProject(this.getName());
    }

    @Override
    public void createExistentResourceFromHandle(IProgressMonitor monitor) throws CoreException {
        IProject projectHandle = this.createResourceHandle();
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)200);
        if (projectHandle.exists()) {
            return;
        }
        subMonitor.setTaskName(ResourceSnapshotMessages.FolderDescription_NewFolderProgress);
        if (this.projectDescription == null) {
            projectHandle.create((IProgressMonitor)subMonitor.split(100));
        } else {
            projectHandle.create(this.projectDescription, (IProgressMonitor)subMonitor.split(100));
        }
        if (this.openOnCreate) {
            projectHandle.open(0, (IProgressMonitor)subMonitor.split(100));
        }
    }

    @Override
    public String getName() {
        if (this.projectDescription != null) {
            return this.projectDescription.getName();
        }
        return super.getName();
    }

    @Override
    public boolean verifyExistence(boolean checkMembers) {
        IProject projectHandle = this.createResourceHandle();
        if (projectHandle.isAccessible()) {
            return super.verifyExistence(checkMembers);
        }
        return super.verifyExistence(false);
    }
}

