/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.fix;

import java.util.ArrayList;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.internal.corext.fix.SwitchExpressionsFixCore;
import org.eclipse.jdt.internal.ui.fix.AbstractCleanUp;
import org.eclipse.jdt.internal.ui.fix.MultiFixMessages;
import org.eclipse.jdt.ui.cleanup.CleanUpContext;
import org.eclipse.jdt.ui.cleanup.CleanUpRequirements;
import org.eclipse.jdt.ui.cleanup.ICleanUpFix;

public class SwitchExpressionsCleanUpCore
extends AbstractCleanUp {
    public SwitchExpressionsCleanUpCore(Map<String, String> options) {
        super(options);
    }

    public SwitchExpressionsCleanUpCore() {
    }

    @Override
    public CleanUpRequirements getRequirements() {
        return new CleanUpRequirements(this.requireAST(), false, false, null);
    }

    public boolean requireAST() {
        return this.isEnabled("cleanup.convert_to_switch_expressions");
    }

    @Override
    public ICleanUpFix createFix(CleanUpContext context) throws CoreException {
        CompilationUnit compilationUnit = context.getAST();
        if (compilationUnit == null) {
            return null;
        }
        boolean convertToSwitchExpressions = this.isEnabled("cleanup.convert_to_switch_expressions");
        if (!convertToSwitchExpressions) {
            return null;
        }
        return SwitchExpressionsFixCore.createCleanUp(compilationUnit);
    }

    @Override
    public String[] getStepDescriptions() {
        ArrayList<String> result = new ArrayList<String>();
        if (this.isEnabled("cleanup.convert_to_switch_expressions")) {
            result.add(MultiFixMessages.SwitchExpressionsCleanUp_ConvertToSwitchExpressions_description);
        }
        return result.toArray(new String[0]);
    }

    @Override
    public String getPreview() {
        if (this.isEnabled("cleanup.convert_to_switch_expressions")) {
            return "int i = switch(j) {\n    case 1 -> 3;\n    case 2 -> 4;\n    default -> 0;\n};\n\n\n\n\n\n\n\n\n";
        }
        return "int i;\nswitch(j) {\n    case 1:\n        i = 3;\n        break;\n    case 2:\n        i = 4;\n        break;\n    default:\n        i = 0;\n        break;\n}\n\n";
    }
}

