/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tips.core;

import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.function.Predicate;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.tips.core.ITipManager;
import org.eclipse.tips.core.Messages;
import org.eclipse.tips.core.Tip;
import org.eclipse.tips.core.TipImage;
import org.eclipse.tips.core.internal.FinalTip;
import org.eclipse.tips.core.internal.LogUtil;

public abstract class TipProvider {
    public static final String PROP_READY = "PR";
    private ITipManager fTipManager;
    private int fTipIndex;
    private final List<Tip> fTips = new ArrayList<Tip>();
    private Tip fCurrentTip;
    private boolean fReady;
    private final PropertyChangeSupport fChangeSupport = new PropertyChangeSupport(this);
    private final Tip fFinalTip = new FinalTip(this.getID());
    private String fExpression;
    private final Predicate<Tip> fUnreadTipPredicate = pTip -> {
        if (this.getManager().mustServeReadTips()) {
            return true;
        }
        return !this.getManager().isRead((Tip)pTip);
    };

    public abstract void dispose();

    public abstract String getDescription();

    public abstract String getID();

    public abstract TipImage getImage();

    public synchronized Tip getCurrentTip() {
        if (this.fCurrentTip == null) {
            return this.getNextTip();
        }
        return this.fCurrentTip;
    }

    public synchronized Tip getNextTip() {
        List<Tip> list = this.getTips(this.fUnreadTipPredicate);
        if (list.isEmpty()) {
            return this.setCurrentTip(this.fFinalTip);
        }
        if (this.fCurrentTip != null && (this.getManager().mustServeReadTips() || this.getManager().isRead(this.fCurrentTip))) {
            ++this.fTipIndex;
        }
        if (this.fTipIndex >= list.size()) {
            this.fTipIndex = 0;
        }
        return this.setCurrentTip(list.get(this.fTipIndex));
    }

    public Tip getPreviousTip() {
        List<Tip> list = this.getTips(this.fUnreadTipPredicate);
        if (list.isEmpty()) {
            return this.setCurrentTip(this.fFinalTip);
        }
        --this.fTipIndex;
        if (this.fTipIndex < 0) {
            this.fTipIndex = list.size() - 1;
        }
        return this.setCurrentTip(list.get(this.fTipIndex));
    }

    public synchronized ITipManager getManager() {
        return this.fTipManager;
    }

    public final boolean isReady() {
        return this.fReady;
    }

    public abstract IStatus loadNewTips(IProgressMonitor var1);

    private synchronized Tip setCurrentTip(Tip pTip) {
        this.fCurrentTip = pTip;
        return this.fCurrentTip;
    }

    public synchronized TipProvider setManager(ITipManager tipManager) {
        this.fTipManager = tipManager;
        return this;
    }

    public List<Tip> getTips() {
        return this.getTips(this.fUnreadTipPredicate);
    }

    public synchronized List<Tip> getTips(Predicate<Tip> predicate) {
        if (predicate != null) {
            return this.fTips.stream().filter(predicate).sorted(Comparator.comparing(Tip::getCreationDate).reversed()).toList();
        }
        return Collections.unmodifiableList(this.fTips);
    }

    public TipProvider setTips(List<Tip> tips) {
        this.getManager().log(LogUtil.info(Messages.TipProvider_0));
        this.doSetTips(tips, true);
        this.fReady = true;
        this.fChangeSupport.firePropertyChange(PROP_READY, false, true);
        return this;
    }

    public TipProvider addTips(List<Tip> tips) {
        this.doSetTips(tips, false);
        this.fReady = true;
        this.fChangeSupport.firePropertyChange(PROP_READY, false, true);
        return this;
    }

    private synchronized void doSetTips(List<Tip> tips, boolean replace) {
        if (replace) {
            this.fTips.clear();
        }
        this.fTips.addAll(tips);
    }

    public PropertyChangeSupport getChangeSupport() {
        return this.fChangeSupport;
    }

    public String getExpression() {
        return this.fExpression;
    }

    public void setExpression(String expression) {
        this.fExpression = expression;
    }
}

