/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.fix;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.IfStatement;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.core.refactoring.CompilationUnitChange;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.internal.corext.dom.ASTSemanticMatcher;
import org.eclipse.jdt.internal.corext.fix.CompilationUnitRewriteOperationsFixCore;
import org.eclipse.jdt.internal.corext.fix.LinkedProposalModelCore;
import org.eclipse.jdt.internal.corext.refactoring.structure.CompilationUnitRewrite;
import org.eclipse.jdt.internal.ui.fix.AbstractMultiFix;
import org.eclipse.jdt.internal.ui.fix.MultiFixMessages;
import org.eclipse.jdt.ui.cleanup.CleanUpRequirements;
import org.eclipse.jdt.ui.cleanup.ICleanUpFix;
import org.eclipse.jdt.ui.text.java.IProblemLocation;
import org.eclipse.text.edits.TextEditGroup;

public class RedundantIfConditionCleanUp
extends AbstractMultiFix
implements ICleanUpFix {
    public RedundantIfConditionCleanUp() {
        this(Collections.emptyMap());
    }

    public RedundantIfConditionCleanUp(Map<String, String> options) {
        super(options);
    }

    @Override
    public CleanUpRequirements getRequirements() {
        boolean requireAST = this.isEnabled("cleanup.if_condition");
        return new CleanUpRequirements(requireAST, false, false, null);
    }

    @Override
    public String[] getStepDescriptions() {
        if (this.isEnabled("cleanup.if_condition")) {
            return new String[]{MultiFixMessages.RedundantIfConditionCleanup_description};
        }
        return new String[0];
    }

    @Override
    public String getPreview() {
        StringBuilder bld = new StringBuilder();
        bld.append("if (isValid) {\n");
        bld.append("  return 0;\n");
        if (this.isEnabled("cleanup.if_condition")) {
            bld.append("} else {\n");
        } else {
            bld.append("} else if (!isValid) {\n");
        }
        bld.append("  return -1;\n");
        bld.append("}\n");
        return bld.toString();
    }

    @Override
    protected ICleanUpFix createFix(CompilationUnit unit) throws CoreException {
        if (!this.isEnabled("cleanup.if_condition")) {
            return null;
        }
        final ArrayList rewriteOperations = new ArrayList();
        unit.accept(new ASTVisitor(){

            public boolean visit(IfStatement node) {
                IfStatement secondIf = ASTNodes.as(node.getElseStatement(), IfStatement.class);
                if (!(secondIf == null || secondIf.getElseStatement() != null && ASTNodes.isExceptionExpected((ASTNode)node) || ASTNodes.fallsThrough(node.getThenStatement()) && ASTNodes.fallsThrough(secondIf.getThenStatement()) || !ASTNodes.isPassive((ASTNode)node.getExpression()) || !ASTNodes.isPassive((ASTNode)secondIf.getExpression()) || !ASTSemanticMatcher.INSTANCE.matchNegative((ASTNode)node.getExpression(), secondIf.getExpression()))) {
                    rewriteOperations.add(new RedundantIfConditionOperation(secondIf));
                    return false;
                }
                return true;
            }
        });
        if (rewriteOperations.isEmpty()) {
            return null;
        }
        return new CompilationUnitRewriteOperationsFixCore(MultiFixMessages.RedundantIfConditionCleanup_description, unit, rewriteOperations.toArray(new CompilationUnitRewriteOperationsFixCore.CompilationUnitRewriteOperationWithSourceRange[0]));
    }

    @Override
    public CompilationUnitChange createChange(IProgressMonitor progressMonitor) throws CoreException {
        return null;
    }

    @Override
    public boolean canFix(ICompilationUnit compilationUnit, IProblemLocation problem) {
        return false;
    }

    @Override
    protected ICleanUpFix createFix(CompilationUnit unit, IProblemLocation[] problems) throws CoreException {
        return null;
    }

    private static class RedundantIfConditionOperation
    extends CompilationUnitRewriteOperationsFixCore.CompilationUnitRewriteOperationWithSourceRange {
        private final IfStatement secondIf;

        public RedundantIfConditionOperation(IfStatement secondIf) {
            this.secondIf = secondIf;
        }

        @Override
        public void rewriteASTInternal(CompilationUnitRewrite cuRewrite, LinkedProposalModelCore linkedModel) throws CoreException {
            ASTRewrite rewrite = cuRewrite.getASTRewrite();
            TextEditGroup group = this.createTextEditGroup(MultiFixMessages.RedundantIfConditionCleanup_description, cuRewrite);
            ASTNodes.replaceButKeepComment(rewrite, (ASTNode)this.secondIf, (ASTNode)ASTNodes.createMoveTarget(rewrite, this.secondIf.getThenStatement()), group);
        }
    }
}

