/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.reviews.ui.compare;

import java.lang.reflect.Method;
import org.eclipse.compare.internal.MergeSourceViewer;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.mylyn.reviews.core.model.IFileVersion;

public class CompareUtil {
    public static byte[] getContent(IFileVersion version) {
        String content = version.getContent();
        if (content != null) {
            return content.getBytes();
        }
        byte[] binaryContent = version.getBinaryContent();
        return binaryContent != null ? binaryContent : new byte[]{};
    }

    static SourceViewer getSourceViewer(MergeSourceViewer sourceViewer) {
        if (SourceViewer.class.isInstance(sourceViewer)) {
            return (SourceViewer)SourceViewer.class.cast(sourceViewer);
        }
        try {
            Method getSourceViewerRefl = MergeSourceViewer.class.getDeclaredMethod("getSourceViewer", new Class[0]);
            getSourceViewerRefl.setAccessible(true);
            Object returnValue = getSourceViewerRefl.invoke((Object)sourceViewer, new Object[0]);
            if (returnValue instanceof SourceViewer) {
                return (SourceViewer)returnValue;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }
}

