/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epp.internal.mpc.core.transport.httpclient;

import org.apache.hc.client5.http.auth.AuthScope;
import org.apache.hc.client5.http.auth.Credentials;
import org.apache.hc.client5.http.auth.CredentialsStore;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.eclipse.epp.internal.mpc.core.transport.httpclient.ChainedCredentialsProvider;

public class SynchronizedCredentialsProvider
implements CredentialsStore {
    private final CredentialsStore delegate;
    private final Object lock;

    public SynchronizedCredentialsProvider(CredentialsStore delegate) {
        this.delegate = delegate;
        Object lock = SynchronizedCredentialsProvider.findLock(delegate);
        this.lock = lock == null ? this : lock;
    }

    private static Object findLock(CredentialsStore credentialsProvider) {
        if (credentialsProvider instanceof SynchronizedCredentialsProvider) {
            return ((SynchronizedCredentialsProvider)credentialsProvider).lock;
        }
        if (credentialsProvider instanceof ChainedCredentialsProvider) {
            ChainedCredentialsProvider chain = (ChainedCredentialsProvider)credentialsProvider;
            Object lock = SynchronizedCredentialsProvider.findLock(chain.getSecond());
            if (lock != null) {
                return lock;
            }
            return SynchronizedCredentialsProvider.findLock(chain.getFirst());
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCredentials(AuthScope authscope, Credentials credentials) {
        Object object = this.lock;
        synchronized (object) {
            this.delegate.setCredentials(authscope, credentials);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Credentials getCredentials(AuthScope authscope, HttpContext context) {
        Object object = this.lock;
        synchronized (object) {
            return this.delegate.getCredentials(authscope, context);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Object object = this.lock;
        synchronized (object) {
            this.delegate.clear();
        }
    }

    public CredentialsStore getDelegate() {
        return this.delegate;
    }
}

