/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swtbot.generator.ui;

import java.util.List;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swtbot.generator.framework.GenerationRule;
import org.eclipse.swtbot.generator.framework.Generator;
import org.eclipse.swtbot.generator.ui.BotGeneratorEventDispatcher;
import org.eclipse.ui.internal.WorkbenchImages;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RecorderDialog
extends TitleAreaDialog {
    private BotGeneratorEventDispatcher recorder;
    private List<Generator> availableGenerators;
    private Text generatedCode;

    public RecorderDialog(Shell parentShell, BotGeneratorEventDispatcher recorder, List<Generator> availableGenerators) {
        super(parentShell);
        this.setShellStyle(3184);
        this.setBlockOnOpen(false);
        this.recorder = recorder;
        this.availableGenerators = availableGenerators;
    }

    protected Control createDialogArea(Composite parent) {
        this.getShell().setText("SWTBot Test Recorder");
        this.setTitle("SWTBot Test Recorder");
        this.setMessage("This dialog will track the generated code while you're recording your UI scenario.");
        Composite container = (Composite)super.createDialogArea(parent);
        container.setLayoutData((Object)new GridData(4, 4, true, true));
        container.setLayout((Layout)new GridLayout(1, false));
        Composite generatorSelectionContainer = new Composite(container, 0);
        generatorSelectionContainer.setLayout((Layout)new GridLayout(2, false));
        Label selectorLabel = new Label(generatorSelectionContainer, 0);
        selectorLabel.setText("Target Bot API:");
        selectorLabel.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        ComboViewer comboViewer = new ComboViewer(generatorSelectionContainer);
        comboViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        comboViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object o) {
                return ((Generator)o).getLabel();
            }
        });
        comboViewer.setInput(this.availableGenerators);
        comboViewer.setSelection((ISelection)new StructuredSelection((Object)this.recorder.getCurrentGenerator()));
        comboViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                Generator newGenerator = (Generator)((IStructuredSelection)event.getSelection()).getFirstElement();
                RecorderDialog.this.recorder.setGenerator(newGenerator);
            }
        });
        this.generatedCode = new Text(container, 2818);
        this.generatedCode.setText("// Generated code goes there\n");
        this.generatedCode.setLayoutData((Object)new GridData(4, 4, true, true));
        Composite actionsComposite = new Composite(container, 0);
        actionsComposite.setLayout((Layout)new RowLayout(256));
        final Button recordPauseButton = new Button(actionsComposite, 8);
        recordPauseButton.setText(this.recorder.isRecording() ? "Pause" : "Start Recording");
        Button copyButton = new Button(actionsComposite, 8);
        copyButton.setToolTipText("Copy");
        copyButton.setImage(WorkbenchImages.getImage((String)"IMG_TOOL_COPY"));
        recordPauseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RecorderDialog.this.recorder.switchRecording();
                recordPauseButton.setText(RecorderDialog.this.recorder.isRecording() ? "Pause" : "Start Recording");
            }
        });
        this.recorder.addListener(new BotGeneratorEventDispatcher.CodeGenerationListener(){

            public void handleCodeGenerated(GenerationRule code) {
                for (String action : code.getActions()) {
                    RecorderDialog.this.generatedCode.setText(String.valueOf(RecorderDialog.this.generatedCode.getText()) + action + ";\n");
                }
            }
        });
        copyButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Clipboard cb = new Clipboard(Display.getCurrent());
                TextTransfer textTransfer = TextTransfer.getInstance();
                cb.setContents(new Object[]{RecorderDialog.this.generatedCode.getText()}, new Transfer[]{textTransfer});
                cb.dispose();
            }
        });
        return container;
    }

    public void createButtonsForButtonBar(Composite parent) {
    }

    protected Point getInitialSize() {
        return new Point(450, 650);
    }

    public Text getGeneratedCodeText() {
        return this.generatedCode;
    }

    public BotGeneratorEventDispatcher getRecorderGenerator() {
        return this.recorder;
    }
}

