/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal.handlers;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IRegistryEventListener;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.ls.core.internal.IDelegateCommandHandler;
import org.eclipse.jdt.ls.core.internal.JSONUtility;
import org.eclipse.jdt.ls.core.internal.JavaLanguageServerPlugin;
import org.eclipse.lsp4j.ExecuteCommandParams;
import org.eclipse.lsp4j.jsonrpc.ResponseErrorException;
import org.eclipse.lsp4j.jsonrpc.messages.ResponseError;
import org.eclipse.lsp4j.jsonrpc.messages.ResponseErrorCode;

public class WorkspaceExecuteCommandHandler
implements IRegistryEventListener {
    private static WorkspaceExecuteCommandHandler instance = null;
    private static final String EXTENSION_POINT_ID = "org.eclipse.jdt.ls.core.delegateCommandHandler";
    private static final String COMMAND = "command";
    private static final String STATIC = "static";
    private static final String CLASS = "class";
    private static final String ID = "id";
    private Map<String, DelegateCommandHandlerDescriptor> fgContributedCommandHandlers;

    public static WorkspaceExecuteCommandHandler getInstance() {
        if (instance == null) {
            instance = new WorkspaceExecuteCommandHandler();
        }
        return instance;
    }

    private synchronized Collection<DelegateCommandHandlerDescriptor> getDelegateCommandHandlerDescriptors() {
        if (this.fgContributedCommandHandlers == null) {
            IConfigurationElement[] elements = Platform.getExtensionRegistry().getConfigurationElementsFor(EXTENSION_POINT_ID);
            this.fgContributedCommandHandlers = Stream.of(elements).collect(Collectors.toMap(DelegateCommandHandlerDescriptor::createId, DelegateCommandHandlerDescriptor::new, (value1, value2) -> value2));
            Platform.getExtensionRegistry().addListener((IRegistryEventListener)this);
        }
        return this.fgContributedCommandHandlers.values();
    }

    public Set<String> getStaticCommands() {
        Collection<DelegateCommandHandlerDescriptor> handlers = this.getDelegateCommandHandlerDescriptors();
        HashSet<String> commands = new HashSet<String>();
        for (DelegateCommandHandlerDescriptor handler : handlers) {
            commands.addAll(handler.getStaticCommands());
        }
        return commands;
    }

    public Set<String> getNonStaticCommands() {
        Collection<DelegateCommandHandlerDescriptor> handlers = this.getDelegateCommandHandlerDescriptors();
        HashSet<String> commands = new HashSet<String>();
        for (DelegateCommandHandlerDescriptor handler : handlers) {
            commands.addAll(handler.getNonStaticCommands());
        }
        return commands;
    }

    public Set<String> getAllCommands() {
        Collection<DelegateCommandHandlerDescriptor> handlers = this.getDelegateCommandHandlerDescriptors();
        HashSet<String> commands = new HashSet<String>();
        for (DelegateCommandHandlerDescriptor handler : handlers) {
            commands.addAll(handler.getAllCommands());
        }
        return commands;
    }

    public Object executeCommand(final ExecuteCommandParams params, final IProgressMonitor monitor) {
        if (params == null || params.getCommand() == null) {
            String errorMessage = "The workspace/executeCommand has empty params or command";
            JavaLanguageServerPlugin.logError(errorMessage);
            throw new ResponseErrorException(new ResponseError(ResponseErrorCode.InvalidParams, errorMessage, null));
        }
        Collection<DelegateCommandHandlerDescriptor> handlers = this.getDelegateCommandHandlerDescriptors();
        final Collection candidates = handlers.stream().filter(desc -> desc.getAllCommands().contains(params.getCommand())).collect(Collectors.toSet());
        if (candidates.size() > 1) {
            IllegalStateException ex = new IllegalStateException(String.format("Found multiple delegateCommandHandlers (%s) matching command %s", candidates, params.getCommand()));
            throw new ResponseErrorException(new ResponseError(ResponseErrorCode.InternalError, ex.getMessage(), (Object)ex));
        }
        if (monitor.isCanceled()) {
            return "";
        }
        if (candidates.isEmpty()) {
            throw new ResponseErrorException(new ResponseError(ResponseErrorCode.MethodNotFound, String.format("No delegateCommandHandler for %s", params.getCommand()), null));
        }
        final Object[] resultValues = new Object[1];
        SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

            public void run() throws Exception {
                IDelegateCommandHandler delegateCommandHandler = ((DelegateCommandHandlerDescriptor)candidates.iterator().next()).getDelegateCommandHandler();
                if (delegateCommandHandler != null) {
                    List<Object> args = Collections.emptyList();
                    if (params.getArguments() != null) {
                        args = params.getArguments().stream().map(element -> JSONUtility.toModel(element, Object.class)).collect(Collectors.toList());
                    }
                    resultValues[0] = delegateCommandHandler.executeCommand(params.getCommand(), args, monitor);
                }
            }

            public void handleException(Throwable ex) {
                Status status = new Status(4, "org.eclipse.jdt.ls.core", 0, "Error in calling delegate command handler", ex);
                JavaLanguageServerPlugin.log((IStatus)status);
                if (ex instanceof ResponseErrorException) {
                    throw (ResponseErrorException)ex;
                }
                throw new ResponseErrorException(new ResponseError(ResponseErrorCode.UnknownErrorCode, ex.getMessage(), (Object)ex));
            }
        });
        return resultValues[0];
    }

    public synchronized void added(IExtension[] extensions) {
        Map<String, DelegateCommandHandlerDescriptor> addedDescriptors = Stream.of(extensions).filter(extension -> extension.getExtensionPointUniqueIdentifier().equals(EXTENSION_POINT_ID)).flatMap(extension -> Stream.of(extension.getConfigurationElements())).collect(Collectors.toMap(DelegateCommandHandlerDescriptor::createId, DelegateCommandHandlerDescriptor::new, (value1, value2) -> value2));
        this.fgContributedCommandHandlers.putAll(addedDescriptors);
    }

    public synchronized void removed(IExtension[] extensions) {
        Stream.of(extensions).filter(extension -> extension.getExtensionPointUniqueIdentifier().equals(EXTENSION_POINT_ID)).flatMap(extension -> Stream.of(extension.getConfigurationElements())).map(DelegateCommandHandlerDescriptor::createId).forEach(this.fgContributedCommandHandlers::remove);
    }

    public void added(IExtensionPoint[] extensionPoints) {
    }

    public void removed(IExtensionPoint[] extensionPoints) {
    }

    private static class DelegateCommandHandlerDescriptor {
        private final IConfigurationElement fConfigurationElement;
        private Set<String> fStaticCommandIds = new HashSet<String>();
        private Set<String> fNonStaticCommandIds = new HashSet<String>();
        private Set<String> fAllCommands = new HashSet<String>();
        private IDelegateCommandHandler fDelegateCommandHandlerInstance;

        public DelegateCommandHandlerDescriptor(IConfigurationElement element) {
            this.fConfigurationElement = element;
            IConfigurationElement[] children = this.fConfigurationElement.getChildren(WorkspaceExecuteCommandHandler.COMMAND);
            Stream.of(children).forEach(c -> {
                String id = c.getAttribute(WorkspaceExecuteCommandHandler.ID);
                if (Boolean.valueOf(c.getAttribute(WorkspaceExecuteCommandHandler.STATIC)).booleanValue()) {
                    this.fStaticCommandIds.add(id);
                } else {
                    this.fNonStaticCommandIds.add(id);
                }
                this.fAllCommands.add(id);
            });
            this.fDelegateCommandHandlerInstance = null;
            JavaLanguageServerPlugin.logInfo("Static Commands: " + this.fStaticCommandIds);
            JavaLanguageServerPlugin.logInfo("Non-Static Commands: " + this.fNonStaticCommandIds);
        }

        public Set<String> getStaticCommands() {
            return this.fStaticCommandIds;
        }

        public Set<String> getNonStaticCommands() {
            return this.fNonStaticCommandIds;
        }

        public Set<String> getAllCommands() {
            return this.fAllCommands;
        }

        public synchronized IDelegateCommandHandler getDelegateCommandHandler() {
            block4: {
                if (this.fDelegateCommandHandlerInstance == null) {
                    try {
                        Object extension = this.fConfigurationElement.createExecutableExtension(WorkspaceExecuteCommandHandler.CLASS);
                        if (extension instanceof IDelegateCommandHandler) {
                            this.fDelegateCommandHandlerInstance = (IDelegateCommandHandler)extension;
                            break block4;
                        }
                        String message = "Invalid extension to org.eclipse.jdt.ls.core.delegateCommandHandler. Must implements org.eclipse.jdt.ls.core.internal.IDelegateCommandHandler";
                        JavaLanguageServerPlugin.logError(message);
                        return null;
                    }
                    catch (CoreException e) {
                        JavaLanguageServerPlugin.logException("Unable to create delegate command handler ", e);
                        return null;
                    }
                }
            }
            return this.fDelegateCommandHandlerInstance;
        }

        public static String createId(IConfigurationElement element) {
            return String.valueOf(element.getNamespaceIdentifier()) + "#" + element.getAttribute(WorkspaceExecuteCommandHandler.CLASS);
        }
    }
}

