"use strict";
/********************************************************************************
 * Copyright (C) 2018 Ericsson and others.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 *
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is available at
 * https://www.gnu.org/software/classpath/license.html.
 *
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 ********************************************************************************/
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.AboutDialog = exports.AboutDialogProps = exports.ABOUT_EXTENSIONS_CLASS = exports.ABOUT_CONTENT_CLASS = void 0;
const React = require("react");
const inversify_1 = require("inversify");
const dialogs_1 = require("./dialogs");
const react_dialog_1 = require("./dialogs/react-dialog");
const application_protocol_1 = require("../common/application-protocol");
const frontend_application_config_provider_1 = require("./frontend-application-config-provider");
exports.ABOUT_CONTENT_CLASS = 'theia-aboutDialog';
exports.ABOUT_EXTENSIONS_CLASS = 'theia-aboutExtensions';
let AboutDialogProps = class AboutDialogProps extends dialogs_1.DialogProps {
};
AboutDialogProps = __decorate([
    inversify_1.injectable()
], AboutDialogProps);
exports.AboutDialogProps = AboutDialogProps;
let AboutDialog = class AboutDialog extends react_dialog_1.ReactDialog {
    constructor(props) {
        super({
            title: frontend_application_config_provider_1.FrontendApplicationConfigProvider.get().applicationName,
        });
        this.props = props;
        this.extensionsInfos = [];
        this.appendAcceptButton('Ok');
    }
    async init() {
        this.applicationInfo = await this.appServer.getApplicationInfo();
        this.extensionsInfos = await this.appServer.getExtensionsInfos();
        this.update();
    }
    renderHeader() {
        const applicationInfo = this.applicationInfo;
        return applicationInfo && React.createElement("h3", null,
            applicationInfo.name,
            " ",
            applicationInfo.version);
    }
    renderExtensions() {
        const extensionsInfos = this.extensionsInfos;
        return React.createElement(React.Fragment, null,
            React.createElement("h3", null, "List of extensions"),
            React.createElement("ul", { className: exports.ABOUT_EXTENSIONS_CLASS }, extensionsInfos
                .sort((a, b) => a.name.toLowerCase().localeCompare(b.name.toLowerCase()))
                .map((extension) => React.createElement("li", { key: extension.name },
                extension.name,
                " ",
                extension.version))));
    }
    render() {
        return React.createElement("div", { className: exports.ABOUT_CONTENT_CLASS },
            this.renderHeader(),
            this.renderExtensions());
    }
    onAfterAttach(msg) {
        super.onAfterAttach(msg);
        this.update();
    }
    get value() { return undefined; }
};
__decorate([
    inversify_1.inject(application_protocol_1.ApplicationServer),
    __metadata("design:type", Object)
], AboutDialog.prototype, "appServer", void 0);
__decorate([
    inversify_1.postConstruct(),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", []),
    __metadata("design:returntype", Promise)
], AboutDialog.prototype, "init", null);
AboutDialog = __decorate([
    inversify_1.injectable(),
    __param(0, inversify_1.inject(AboutDialogProps)),
    __metadata("design:paramtypes", [AboutDialogProps])
], AboutDialog);
exports.AboutDialog = AboutDialog;
//# sourceMappingURL=about-dialog.js.map