"use strict";
/********************************************************************************
 * Copyright (C) 2019 TypeFox and others.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 *
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is available at
 * https://www.gnu.org/software/classpath/license.html.
 *
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 ********************************************************************************/
Object.defineProperty(exports, "__esModule", { value: true });
exports.NodeFileUpload = void 0;
const path = require("path");
const crypto = require("crypto");
const fs = require("@theia/core/shared/fs-extra");
const buffer_1 = require("buffer");
const file_uri_1 = require("@theia/core/lib/node/file-uri");
/**
 * @deprecated since 1.17.0
 */
class NodeFileUpload {
    constructor(uri, size) {
        this.uri = uri;
        this.size = size;
        this._uploadedBytes = 0;
        this.fsPath = file_uri_1.FileUri.fsPath(uri);
        this.id = 'theia_upload_' + crypto.randomBytes(16).toString('hex');
        this.uploadPath = path.join(path.dirname(this.fsPath), this.id);
    }
    get uploadedBytes() {
        return this._uploadedBytes;
    }
    async create() {
        await fs.outputFile(this.uploadPath, '');
    }
    async append(chunk) {
        await fs.appendFile(this.uploadPath, buffer_1.Buffer.from(chunk));
        this._uploadedBytes += chunk.byteLength;
    }
    async rename() {
        await fs.move(this.uploadPath, this.fsPath, { overwrite: true });
        this.dispose = () => Promise.resolve();
    }
    dispose() {
        fs.unlink(this.uploadPath).catch(() => { });
    }
}
exports.NodeFileUpload = NodeFileUpload;
//# sourceMappingURL=node-file-upload.js.map