/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
import './media/quickInput.css';
import * as dom from '../../../browser/dom';
import { InputBox } from '../../../browser/ui/inputbox/inputBox';
import { Disposable } from '../../../common/lifecycle';
import { StandardKeyboardEvent } from '../../../browser/keyboardEvent';
import Severity from '../../../common/severity';
import { StandardMouseEvent } from '../../../browser/mouseEvent';
var $ = dom.$;
var QuickInputBox = /** @class */ (function (_super) {
    __extends(QuickInputBox, _super);
    function QuickInputBox(parent) {
        var _this = _super.call(this) || this;
        _this.parent = parent;
        _this.onKeyDown = function (handler) {
            return dom.addDisposableListener(_this.inputBox.inputElement, dom.EventType.KEY_DOWN, function (e) {
                handler(new StandardKeyboardEvent(e));
            });
        };
        _this.onMouseDown = function (handler) {
            return dom.addDisposableListener(_this.inputBox.inputElement, dom.EventType.MOUSE_DOWN, function (e) {
                handler(new StandardMouseEvent(e));
            });
        };
        _this.onDidChange = function (handler) {
            return _this.inputBox.onDidChange(handler);
        };
        _this.container = dom.append(_this.parent, $('.quick-input-box'));
        _this.inputBox = _this._register(new InputBox(_this.container, undefined));
        return _this;
    }
    Object.defineProperty(QuickInputBox.prototype, "value", {
        get: function () {
            return this.inputBox.value;
        },
        set: function (value) {
            this.inputBox.value = value;
        },
        enumerable: false,
        configurable: true
    });
    QuickInputBox.prototype.select = function (range) {
        if (range === void 0) { range = null; }
        this.inputBox.select(range);
    };
    QuickInputBox.prototype.isSelectionAtEnd = function () {
        return this.inputBox.isSelectionAtEnd();
    };
    QuickInputBox.prototype.setPlaceholder = function (placeholder) {
        this.inputBox.setPlaceHolder(placeholder);
    };
    Object.defineProperty(QuickInputBox.prototype, "placeholder", {
        get: function () {
            return this.inputBox.inputElement.getAttribute('placeholder') || '';
        },
        set: function (placeholder) {
            this.inputBox.setPlaceHolder(placeholder);
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(QuickInputBox.prototype, "ariaLabel", {
        get: function () {
            return this.inputBox.getAriaLabel();
        },
        set: function (ariaLabel) {
            this.inputBox.setAriaLabel(ariaLabel);
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(QuickInputBox.prototype, "password", {
        get: function () {
            return this.inputBox.inputElement.type === 'password';
        },
        set: function (password) {
            this.inputBox.inputElement.type = password ? 'password' : 'text';
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(QuickInputBox.prototype, "enabled", {
        set: function (enabled) {
            this.inputBox.setEnabled(enabled);
        },
        enumerable: false,
        configurable: true
    });
    QuickInputBox.prototype.hasFocus = function () {
        return this.inputBox.hasFocus();
    };
    QuickInputBox.prototype.setAttribute = function (name, value) {
        this.inputBox.inputElement.setAttribute(name, value);
    };
    QuickInputBox.prototype.removeAttribute = function (name) {
        this.inputBox.inputElement.removeAttribute(name);
    };
    QuickInputBox.prototype.showDecoration = function (decoration) {
        if (decoration === Severity.Ignore) {
            this.inputBox.hideMessage();
        }
        else {
            this.inputBox.showMessage({ type: decoration === Severity.Info ? 1 /* INFO */ : decoration === Severity.Warning ? 2 /* WARNING */ : 3 /* ERROR */, content: '' });
        }
    };
    QuickInputBox.prototype.stylesForType = function (decoration) {
        return this.inputBox.stylesForType(decoration === Severity.Info ? 1 /* INFO */ : decoration === Severity.Warning ? 2 /* WARNING */ : 3 /* ERROR */);
    };
    QuickInputBox.prototype.setFocus = function () {
        this.inputBox.focus();
    };
    QuickInputBox.prototype.layout = function () {
        this.inputBox.layout();
    };
    QuickInputBox.prototype.style = function (styles) {
        this.inputBox.style(styles);
    };
    return QuickInputBox;
}(Disposable));
export { QuickInputBox };
