"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.StatusBarItemImpl = void 0;
const types_impl_1 = require("../types-impl");
const coreutils_1 = require("@theia/core/shared/@phosphor/coreutils");
class StatusBarItemImpl {
    constructor(_proxy, alignment = types_impl_1.StatusBarAlignment.Left, priority = 0) {
        this.id = StatusBarItemImpl.nextId();
        this._proxy = _proxy;
        this._alignment = alignment;
        this._priority = priority;
    }
    get alignment() {
        return this._alignment;
    }
    get priority() {
        return this._priority;
    }
    get text() {
        return this._text;
    }
    get tooltip() {
        return this._tooltip;
    }
    get color() {
        return this._color;
    }
    get command() {
        return this._command;
    }
    set text(text) {
        this._text = text;
        this.update();
    }
    set tooltip(tooltip) {
        this._tooltip = tooltip;
        this.update();
    }
    set color(color) {
        this._color = color;
        this.update();
    }
    set command(command) {
        this._command = command;
        this.update();
    }
    show() {
        this._isVisible = true;
        this.update();
    }
    hide() {
        if (this._timeoutHandle) {
            clearTimeout(this._timeoutHandle);
        }
        this._proxy.$dispose(this.id);
        this._isVisible = false;
    }
    update() {
        if (!this._isVisible) {
            return;
        }
        if (this._timeoutHandle) {
            clearTimeout(this._timeoutHandle);
        }
        // Defer the update so that multiple changes to setters don't cause a redraw each
        this._timeoutHandle = setTimeout(() => {
            this._timeoutHandle = undefined;
            const commandId = typeof this.command === 'object' ? this.command.command : this.command;
            const args = typeof this.command === 'object' ? this.command.arguments : undefined;
            // Set to status bar
            this._proxy.$setMessage(this.id, this.text, this.priority, this.alignment, typeof this.color === 'string' ? this.color : this.color && this.color.id, this.tooltip, commandId, args);
        }, 0);
    }
    dispose() {
        this.hide();
    }
    static nextId() {
        return StatusBarItemImpl.ID_PREFIX + ':' + coreutils_1.UUID.uuid4();
    }
}
exports.StatusBarItemImpl = StatusBarItemImpl;
StatusBarItemImpl.ID_PREFIX = 'plugin-status-bar-item';
//# sourceMappingURL=status-bar-item.js.map