"use strict";
/********************************************************************************
 * Copyright (C) 2020 Ericsson and others.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 *
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is available at
 * https://www.gnu.org/software/classpath/license.html.
 *
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 ********************************************************************************/
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var PreferencesSearchbarWidget_1;
Object.defineProperty(exports, "__esModule", { value: true });
exports.PreferencesSearchbarWidget = void 0;
const browser_1 = require("@theia/core/lib/browser");
const inversify_1 = require("@theia/core/shared/inversify");
const React = require("@theia/core/shared/react");
const debounce = require("@theia/core/shared/lodash.debounce");
const core_1 = require("@theia/core");
let PreferencesSearchbarWidget = PreferencesSearchbarWidget_1 = class PreferencesSearchbarWidget extends browser_1.ReactWidget {
    constructor() {
        super(...arguments);
        this.onFilterStringChangedEmitter = new core_1.Emitter();
        this.onFilterChanged = this.onFilterStringChangedEmitter.event;
        this.searchbarRef = React.createRef();
        this.resultsCount = 0;
        this.handleSearch = (e) => {
            this.search(e.target.value);
        };
        this.search = debounce((value) => {
            this.onFilterStringChangedEmitter.fire(value);
            this.update();
        }, 200);
        /**
         * Clears the search input and all search results.
         * @param e on-click mouse event.
         */
        this.clearSearchResults = (e) => {
            const search = document.getElementById(PreferencesSearchbarWidget_1.SEARCHBAR_ID);
            if (search) {
                search.value = '';
                this.search(search.value);
                this.update();
            }
        };
    }
    init() {
        this.onRender.push(core_1.Disposable.create(() => this.focus()));
        this.id = PreferencesSearchbarWidget_1.ID;
        this.title.label = PreferencesSearchbarWidget_1.LABEL;
        this.update();
    }
    focus() {
        if (this.searchbarRef.current) {
            this.searchbarRef.current.focus();
        }
    }
    /**
     * Renders all search bar options.
     */
    renderOptionContainer() {
        const resultsCount = this.renderResultsCountOption();
        const clearAllOption = this.renderClearAllOption();
        return React.createElement("div", { className: "option-buttons" },
            " ",
            resultsCount,
            " ",
            clearAllOption,
            " ");
    }
    /**
     * Renders a badge displaying search results count.
     */
    renderResultsCountOption() {
        const resultsFound = `${this.resultsCount === 0 ? 'No' : this.resultsCount} ${this.resultsCount === 1 ? 'Setting Found' : 'Settings Found'}`;
        return this.searchTermExists() ?
            (React.createElement("span", { className: "results-found", title: resultsFound }, resultsFound))
            : '';
    }
    /**
     * Renders a clear all button.
     */
    renderClearAllOption() {
        return React.createElement("span", { className: `clear-all option ${(this.searchTermExists() ? 'enabled' : '')}`, title: "Clear Search Results", onClick: this.clearSearchResults });
    }
    /**
     * Determines whether the search input currently has a value.
     * @returns true, if the search input currently has a value; false, otherwise.
     */
    searchTermExists() {
        var _a;
        return !!((_a = this.searchbarRef.current) === null || _a === void 0 ? void 0 : _a.value);
    }
    getSearchTerm() {
        const search = document.getElementById(PreferencesSearchbarWidget_1.SEARCHBAR_ID);
        return search === null || search === void 0 ? void 0 : search.value;
    }
    updateSearchTerm(searchTerm) {
        const search = document.getElementById(PreferencesSearchbarWidget_1.SEARCHBAR_ID);
        if (!search) {
            return;
        }
        search.value = searchTerm;
        this.search(search.value);
        this.update();
    }
    render() {
        const optionContainer = this.renderOptionContainer();
        return (React.createElement("div", { className: 'settings-header' },
            React.createElement("div", { className: "settings-search-container" },
                React.createElement("input", { type: "text", id: PreferencesSearchbarWidget_1.SEARCHBAR_ID, spellCheck: false, placeholder: "Search Settings", className: "settings-search-input theia-input", onChange: this.handleSearch, ref: this.searchbarRef }),
                optionContainer)));
    }
    /**
     * Updates the search result count.
     * @param count the result count.
     */
    updateResultsCount(count) {
        this.resultsCount = count;
        this.update();
    }
    storeState() {
        return {
            searchTerm: this.getSearchTerm()
        };
    }
    restoreState(oldState) {
        const searchInputExists = this.onDidChangeVisibility(() => {
            this.updateSearchTerm(oldState.searchTerm || '');
            searchInputExists.dispose();
        });
    }
};
PreferencesSearchbarWidget.ID = 'settings.header';
PreferencesSearchbarWidget.LABEL = 'Settings Header';
PreferencesSearchbarWidget.SEARCHBAR_ID = 'preference-searchbar';
__decorate([
    inversify_1.postConstruct(),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", []),
    __metadata("design:returntype", void 0)
], PreferencesSearchbarWidget.prototype, "init", null);
PreferencesSearchbarWidget = PreferencesSearchbarWidget_1 = __decorate([
    inversify_1.injectable()
], PreferencesSearchbarWidget);
exports.PreferencesSearchbarWidget = PreferencesSearchbarWidget;
//# sourceMappingURL=preference-searchbar-widget.js.map