"use strict";
/********************************************************************************
 * Copyright (C) 2018 Ericsson and others.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 *
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is available at
 * https://www.gnu.org/software/classpath/license.html.
 *
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 ********************************************************************************/
Object.defineProperty(exports, "__esModule", { value: true });
exports.getTemporaryWorkspaceFileUri = exports.VSCODE_EXT = exports.THEIA_EXT = void 0;
// TODO get rid of util files, replace with methods in a responsible class
const uri_1 = require("@theia/core/lib/common/uri");
exports.THEIA_EXT = 'theia-workspace';
exports.VSCODE_EXT = 'code-workspace';
/**
 * @deprecated since 1.4.0 - because of https://github.com/eclipse-theia/theia/wiki/Coding-Guidelines#di-function-export, use `WorkspaceService.getUntitledWorkspace` instead
 */
async function getTemporaryWorkspaceFileUri(envVariableServer) {
    const configDirUri = await envVariableServer.getConfigDirUri();
    return new uri_1.default(configDirUri).resolve(`Untitled.${exports.THEIA_EXT}`);
}
exports.getTemporaryWorkspaceFileUri = getTemporaryWorkspaceFileUri;
//# sourceMappingURL=utils.js.map