"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : new P(function (resolve) { resolve(result.value); }).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (_) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
var __read = (this && this.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};
var __spread = (this && this.__spread) || function () {
    for (var ar = [], i = 0; i < arguments.length; i++) ar = ar.concat(__read(arguments[i]));
    return ar;
};
var _this = this;
Object.defineProperty(exports, "__esModule", { value: true });
var path = require("path");
var temp = require("temp");
var fs = require("fs");
var chai_1 = require("chai");
var stage_1 = require("./stage");
var status_1 = require("./status");
var status_2 = require("../model/status");
var test_helper_1 = require("./test-helper");
var track = temp.track();
describe('stage', function () { return __awaiter(_this, void 0, void 0, function () {
    var _this = this;
    return __generator(this, function (_a) {
        after(function () { return __awaiter(_this, void 0, void 0, function () {
            return __generator(this, function (_a) {
                track.cleanupSync();
                return [2 /*return*/];
            });
        }); });
        describe('stage', function () { return __awaiter(_this, void 0, void 0, function () {
            var _this = this;
            return __generator(this, function (_a) {
                it('missing', function () { return __awaiter(_this, void 0, void 0, function () {
                    var error_1;
                    return __generator(this, function (_a) {
                        switch (_a.label) {
                            case 0:
                                _a.trys.push([0, 2, , 3]);
                                return [4 /*yield*/, stage_1.stage('/does/not/exist', [])];
                            case 1:
                                _a.sent();
                                throw new Error('Expected error when getting status from a non-existing repository.');
                            case 2:
                                error_1 = _a.sent();
                                chai_1.expect(error_1.message).to.be.equal('Unable to find path to repository on disk.');
                                return [3 /*break*/, 3];
                            case 3: return [2 /*return*/];
                        }
                    });
                }); });
                it('new', function () { return __awaiter(_this, void 0, void 0, function () {
                    var repositoryPath, filePaths, beforeStatus, files, afterStatus;
                    return __generator(this, function (_a) {
                        switch (_a.label) {
                            case 0: return [4 /*yield*/, test_helper_1.createTestRepository(track.mkdirSync())];
                            case 1:
                                repositoryPath = _a.sent();
                                filePaths = test_helper_1.add(repositoryPath, { path: 'X.txt' });
                                return [4 /*yield*/, status_1.getStatus(repositoryPath)];
                            case 2:
                                beforeStatus = _a.sent();
                                files = beforeStatus.workingDirectory.files;
                                chai_1.expect(files).to.have.lengthOf(1);
                                chai_1.expect(files[0].path).to.be.equal(path.relative(repositoryPath, filePaths[0]));
                                chai_1.expect(files[0].status).to.be.equal(status_2.FileStatus.New);
                                chai_1.expect(files[0].staged).to.be.false;
                                return [4 /*yield*/, stage_1.stage(repositoryPath, filePaths)];
                            case 3:
                                _a.sent();
                                return [4 /*yield*/, status_1.getStatus(repositoryPath)];
                            case 4:
                                afterStatus = _a.sent();
                                files = afterStatus.workingDirectory.files;
                                chai_1.expect(files).to.have.lengthOf(1);
                                chai_1.expect(files[0].path).to.be.equal(path.relative(repositoryPath, filePaths[0]));
                                chai_1.expect(files[0].status).to.be.equal(status_2.FileStatus.New);
                                chai_1.expect(files[0].staged).to.be.true;
                                return [2 /*return*/];
                        }
                    });
                }); });
                it('deleted', function () { return __awaiter(_this, void 0, void 0, function () {
                    var repositoryPath, filePaths, beforeStatus, files, afterStatus;
                    return __generator(this, function (_a) {
                        switch (_a.label) {
                            case 0: return [4 /*yield*/, test_helper_1.createTestRepository(track.mkdirSync())];
                            case 1:
                                repositoryPath = _a.sent();
                                filePaths = test_helper_1.remove(repositoryPath, 'A.txt');
                                return [4 /*yield*/, status_1.getStatus(repositoryPath)];
                            case 2:
                                beforeStatus = _a.sent();
                                files = beforeStatus.workingDirectory.files;
                                chai_1.expect(files).to.have.lengthOf(1);
                                chai_1.expect(files[0].path).to.be.equal(path.relative(repositoryPath, filePaths[0]));
                                chai_1.expect(files[0].status).to.be.equal(status_2.FileStatus.Deleted);
                                return [4 /*yield*/, stage_1.stage(repositoryPath, filePaths)];
                            case 3:
                                _a.sent();
                                return [4 /*yield*/, status_1.getStatus(repositoryPath)];
                            case 4:
                                afterStatus = _a.sent();
                                files = afterStatus.workingDirectory.files;
                                chai_1.expect(files).to.have.lengthOf(1);
                                chai_1.expect(files[0].path).to.be.equal(path.relative(repositoryPath, filePaths[0]));
                                chai_1.expect(files[0].status).to.be.equal(status_2.FileStatus.Deleted);
                                chai_1.expect(files[0].staged).to.be.true;
                                return [2 /*return*/];
                        }
                    });
                }); });
                it('modified', function () { return __awaiter(_this, void 0, void 0, function () {
                    var repositoryPath, filePaths, beforeStatus, files, afterStatus;
                    return __generator(this, function (_a) {
                        switch (_a.label) {
                            case 0: return [4 /*yield*/, test_helper_1.createTestRepository(track.mkdirSync())];
                            case 1:
                                repositoryPath = _a.sent();
                                filePaths = test_helper_1.modify(repositoryPath, { path: 'A.txt', data: 'content' });
                                return [4 /*yield*/, status_1.getStatus(repositoryPath)];
                            case 2:
                                beforeStatus = _a.sent();
                                files = beforeStatus.workingDirectory.files;
                                chai_1.expect(files).to.have.lengthOf(1);
                                chai_1.expect(files[0].path).to.be.equal(path.relative(repositoryPath, filePaths[0]));
                                chai_1.expect(files[0].status).to.be.equal(status_2.FileStatus.Modified);
                                return [4 /*yield*/, stage_1.stage(repositoryPath, filePaths)];
                            case 3:
                                _a.sent();
                                return [4 /*yield*/, status_1.getStatus(repositoryPath)];
                            case 4:
                                afterStatus = _a.sent();
                                files = afterStatus.workingDirectory.files;
                                chai_1.expect(files).to.have.lengthOf(1);
                                chai_1.expect(files[0].path).to.be.equal(path.relative(repositoryPath, filePaths[0]));
                                chai_1.expect(files[0].status).to.be.equal(status_2.FileStatus.Modified);
                                chai_1.expect(files[0].staged).to.be.true;
                                return [2 /*return*/];
                        }
                    });
                }); });
                it('stage multiple files', function () { return __awaiter(_this, void 0, void 0, function () {
                    var repositoryPath, filePaths, beforeStatus, files, afterStatus;
                    return __generator(this, function (_a) {
                        switch (_a.label) {
                            case 0: return [4 /*yield*/, test_helper_1.createTestRepository(track.mkdirSync())];
                            case 1:
                                repositoryPath = _a.sent();
                                filePaths = test_helper_1.add(repositoryPath, [{ path: 'X.txt' }, { path: 'Y.txt' }]);
                                return [4 /*yield*/, status_1.getStatus(repositoryPath)];
                            case 2:
                                beforeStatus = _a.sent();
                                files = beforeStatus.workingDirectory.files;
                                chai_1.expect(files).to.have.lengthOf(2);
                                chai_1.expect(files[0].path).to.be.equal(path.relative(repositoryPath, filePaths[0]));
                                chai_1.expect(files[0].status).to.be.equal(status_2.FileStatus.New);
                                chai_1.expect(files[0].staged).to.be.false;
                                chai_1.expect(files[1].path).to.be.equal(path.relative(repositoryPath, filePaths[1]));
                                chai_1.expect(files[1].status).to.be.equal(status_2.FileStatus.New);
                                chai_1.expect(files[1].staged).to.be.false;
                                return [4 /*yield*/, stage_1.stage(repositoryPath)];
                            case 3:
                                _a.sent();
                                return [4 /*yield*/, status_1.getStatus(repositoryPath)];
                            case 4:
                                afterStatus = _a.sent();
                                files = afterStatus.workingDirectory.files;
                                chai_1.expect(files).to.have.lengthOf(2);
                                chai_1.expect(files[0].path).to.be.equal(path.relative(repositoryPath, filePaths[0]));
                                chai_1.expect(files[0].status).to.be.equal(status_2.FileStatus.New);
                                chai_1.expect(files[0].staged).to.be.true;
                                chai_1.expect(files[1].path).to.be.equal(path.relative(repositoryPath, filePaths[1]));
                                chai_1.expect(files[1].status).to.be.equal(status_2.FileStatus.New);
                                chai_1.expect(files[1].staged).to.be.true;
                                return [2 /*return*/];
                        }
                    });
                }); });
                return [2 /*return*/];
            });
        }); });
        describe('getStagedFiles', function () { return __awaiter(_this, void 0, void 0, function () {
            var _this = this;
            return __generator(this, function (_a) {
                it('missing', function () { return __awaiter(_this, void 0, void 0, function () {
                    var error_2;
                    return __generator(this, function (_a) {
                        switch (_a.label) {
                            case 0:
                                _a.trys.push([0, 2, , 3]);
                                return [4 /*yield*/, stage_1.getStagedFiles('/does/not/exist')];
                            case 1:
                                _a.sent();
                                throw new Error('Expected error when getting status from a non-existing repository.');
                            case 2:
                                error_2 = _a.sent();
                                chai_1.expect(error_2.message).to.be.equal('Unable to find path to repository on disk.');
                                return [3 /*break*/, 3];
                            case 3: return [2 /*return*/];
                        }
                    });
                }); });
                it('new/deleted/modified', function () { return __awaiter(_this, void 0, void 0, function () {
                    var repositoryPath, toStage, files;
                    return __generator(this, function (_a) {
                        switch (_a.label) {
                            case 0: return [4 /*yield*/, test_helper_1.createTestRepository(track.mkdirSync())];
                            case 1:
                                repositoryPath = _a.sent();
                                toStage = __spread(test_helper_1.add(repositoryPath, { path: 'X.txt', data: 'X' }), test_helper_1.remove(repositoryPath, 'A.txt'), test_helper_1.rename(repositoryPath, { oldPath: 'B.txt', newPath: 'Y.txt' }));
                                return [4 /*yield*/, stage_1.stage(repositoryPath, toStage)];
                            case 2:
                                _a.sent();
                                return [4 /*yield*/, stage_1.getStagedFiles(repositoryPath)];
                            case 3:
                                files = _a.sent();
                                chai_1.expect(files).to.be.lengthOf(3);
                                chai_1.expect(files.map(function (f) { return f.path; })).to.deep.equal(['A.txt', 'X.txt', 'Y.txt']);
                                chai_1.expect(files.map(function (f) { return f.oldPath; }).filter(function (p) { return p; })).to.deep.equal(['B.txt']);
                                return [4 /*yield*/, stage_1.unstage(repositoryPath, toStage.filter(function (f) { return f.endsWith('A.txt'); }))];
                            case 4:
                                _a.sent();
                                return [4 /*yield*/, stage_1.getStagedFiles(repositoryPath)];
                            case 5:
                                files = _a.sent();
                                chai_1.expect(files).to.be.lengthOf(2);
                                chai_1.expect(files.map(function (f) { return f.path; })).to.deep.equal(['X.txt', 'Y.txt']);
                                chai_1.expect(files.map(function (f) { return f.oldPath; }).filter(function (p) { return p; })).to.deep.equal(['B.txt']);
                                return [2 /*return*/];
                        }
                    });
                }); });
                it('modifying a staged file should result in two changes', function () { return __awaiter(_this, void 0, void 0, function () {
                    var repositoryPath, stagedFiles, status, changedFiles;
                    return __generator(this, function (_a) {
                        switch (_a.label) {
                            case 0: return [4 /*yield*/, test_helper_1.createTestRepository(track.mkdirSync())];
                            case 1:
                                repositoryPath = _a.sent();
                                return [4 /*yield*/, stage_1.stage(repositoryPath, test_helper_1.modify(repositoryPath, { path: 'A.txt', data: 'new content' }))];
                            case 2:
                                _a.sent();
                                return [4 /*yield*/, stage_1.getStagedFiles(repositoryPath)];
                            case 3:
                                stagedFiles = _a.sent();
                                chai_1.expect(stagedFiles).to.be.lengthOf(1);
                                chai_1.expect(stagedFiles.map(function (f) { return f.path; })).to.deep.equal(['A.txt']);
                                fs.writeFileSync(path.join(repositoryPath, 'A.txt'), 'yet another new content', 'utf8');
                                chai_1.expect(fs.readFileSync(path.join(repositoryPath, 'A.txt'), 'utf8')).to.be.deep.equal('yet another new content');
                                return [4 /*yield*/, status_1.getStatus(repositoryPath)];
                            case 4:
                                status = _a.sent();
                                changedFiles = status.workingDirectory.files;
                                chai_1.expect(changedFiles).to.be.lengthOf(2);
                                chai_1.expect(changedFiles.map(function (f) { return f.path; })).to.deep.equal(['A.txt', 'A.txt']);
                                chai_1.expect(changedFiles.map(function (f) { return f.staged; }).sort()).to.deep.equal([false, true]);
                                return [2 /*return*/];
                        }
                    });
                }); });
                it('reverting the index state should not modify the working tree', function () { return __awaiter(_this, void 0, void 0, function () {
                    var repositoryPath, stagedFiles, thePath, status, changedFiles, afterStatus, afterChangedFiles;
                    return __generator(this, function (_a) {
                        switch (_a.label) {
                            case 0: return [4 /*yield*/, test_helper_1.createTestRepository(track.mkdirSync())];
                            case 1:
                                repositoryPath = _a.sent();
                                return [4 /*yield*/, stage_1.stage(repositoryPath, test_helper_1.modify(repositoryPath, { path: 'A.txt', data: 'A\nModification in the index' }))];
                            case 2:
                                _a.sent();
                                return [4 /*yield*/, stage_1.getStagedFiles(repositoryPath)];
                            case 3:
                                stagedFiles = _a.sent();
                                chai_1.expect(stagedFiles).to.be.lengthOf(1);
                                chai_1.expect(stagedFiles.map(function (f) { return f.path; })).to.deep.equal(['A.txt']);
                                thePath = test_helper_1.modify(repositoryPath, { path: 'A.txt', data: 'A\nModification in the index\nAnother modification in the working tree' })[0];
                                chai_1.expect(fs.readFileSync(path.join(repositoryPath, 'A.txt'), 'utf8')).to.be.deep.equal('A\nModification in the index\nAnother modification in the working tree');
                                return [4 /*yield*/, status_1.getStatus(repositoryPath)];
                            case 4:
                                status = _a.sent();
                                changedFiles = status.workingDirectory.files;
                                chai_1.expect(changedFiles).to.be.lengthOf(2);
                                chai_1.expect(changedFiles.map(function (f) { return f.path; })).to.deep.equal(['A.txt', 'A.txt']);
                                chai_1.expect(changedFiles.map(function (f) { return f.staged; }).sort()).to.deep.equal([false, true]);
                                return [4 /*yield*/, stage_1.unstage(repositoryPath, thePath, 'HEAD', 'index')];
                            case 5:
                                _a.sent();
                                return [4 /*yield*/, status_1.getStatus(repositoryPath)];
                            case 6:
                                afterStatus = _a.sent();
                                afterChangedFiles = afterStatus.workingDirectory.files;
                                chai_1.expect(afterChangedFiles).to.be.lengthOf(1);
                                chai_1.expect(afterChangedFiles.map(function (f) { return f.path; })).to.deep.equal(['A.txt']);
                                chai_1.expect(afterChangedFiles.map(function (f) { return f.staged; })).to.deep.equal([false]);
                                chai_1.expect(fs.readFileSync(path.join(repositoryPath, 'A.txt'), 'utf8')).to.be.deep.equal('A\nModification in the index\nAnother modification in the working tree');
                                return [2 /*return*/];
                        }
                    });
                }); });
                it('reverting the state in the working tree should not modify the index state', function () { return __awaiter(_this, void 0, void 0, function () {
                    var repositoryPath, stagedFiles, thePath, status, changedFiles, afterStatus, afterChangedFiles;
                    return __generator(this, function (_a) {
                        switch (_a.label) {
                            case 0: return [4 /*yield*/, test_helper_1.createTestRepository(track.mkdirSync())];
                            case 1:
                                repositoryPath = _a.sent();
                                return [4 /*yield*/, stage_1.stage(repositoryPath, test_helper_1.modify(repositoryPath, { path: 'A.txt', data: 'A\nModification in the index' }))];
                            case 2:
                                _a.sent();
                                return [4 /*yield*/, stage_1.getStagedFiles(repositoryPath)];
                            case 3:
                                stagedFiles = _a.sent();
                                chai_1.expect(stagedFiles).to.be.lengthOf(1);
                                chai_1.expect(stagedFiles.map(function (f) { return f.path; })).to.deep.equal(['A.txt']);
                                thePath = test_helper_1.modify(repositoryPath, { path: 'A.txt', data: 'A\nModification in the index\nAnother modification in the working tree' })[0];
                                chai_1.expect(fs.readFileSync(path.join(repositoryPath, 'A.txt'), 'utf8')).to.be.deep.equal('A\nModification in the index\nAnother modification in the working tree');
                                return [4 /*yield*/, status_1.getStatus(repositoryPath)];
                            case 4:
                                status = _a.sent();
                                changedFiles = status.workingDirectory.files;
                                chai_1.expect(changedFiles).to.be.lengthOf(2);
                                chai_1.expect(changedFiles.map(function (f) { return f.path; })).to.deep.equal(['A.txt', 'A.txt']);
                                chai_1.expect(changedFiles.map(function (f) { return f.staged; }).sort()).to.deep.equal([false, true]);
                                return [4 /*yield*/, stage_1.unstage(repositoryPath, thePath, 'HEAD', 'working-tree')];
                            case 5:
                                _a.sent();
                                return [4 /*yield*/, status_1.getStatus(repositoryPath)];
                            case 6:
                                afterStatus = _a.sent();
                                afterChangedFiles = afterStatus.workingDirectory.files;
                                chai_1.expect(afterChangedFiles).to.be.lengthOf(1);
                                chai_1.expect(afterChangedFiles.map(function (f) { return f.path; })).to.deep.equal(['A.txt']);
                                chai_1.expect(afterChangedFiles.map(function (f) { return f.staged; })).to.deep.equal([true]);
                                chai_1.expect(fs.readFileSync(path.join(repositoryPath, 'A.txt'), 'utf8')).to.be.deep.equal('A\nModification in the index');
                                return [2 /*return*/];
                        }
                    });
                }); });
                return [2 /*return*/];
            });
        }); });
        return [2 /*return*/];
    });
}); });
//# sourceMappingURL=stage.spec.js.map