/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __values = (this && this.__values) || function(o) {
    var s = typeof Symbol === "function" && Symbol.iterator, m = s && o[s], i = 0;
    if (m) return m.call(o);
    if (o && typeof o.length === "number") return {
        next: function () {
            if (o && i >= o.length) o = void 0;
            return { value: o && o[i++], done: !o };
        }
    };
    throw new TypeError(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
};
var __read = (this && this.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};
var __spreadArray = (this && this.__spreadArray) || function (to, from) {
    for (var i = 0, il = from.length, j = to.length; i < il; i++, j++)
        to[j] = from[i];
    return to;
};
import { isFalsyOrWhitespace } from '../../../base/common/strings';
import { createDecorator } from '../../instantiation/common/instantiation';
import { userAgent, isMacintosh, isLinux, isWindows, isWeb } from '../../../base/common/platform';
var _userAgent = userAgent || '';
var STATIC_VALUES = new Map();
STATIC_VALUES.set('false', false);
STATIC_VALUES.set('true', true);
STATIC_VALUES.set('isMac', isMacintosh);
STATIC_VALUES.set('isLinux', isLinux);
STATIC_VALUES.set('isWindows', isWindows);
STATIC_VALUES.set('isWeb', isWeb);
STATIC_VALUES.set('isMacNative', isMacintosh && !isWeb);
STATIC_VALUES.set('isEdge', _userAgent.indexOf('Edg/') >= 0);
STATIC_VALUES.set('isFirefox', _userAgent.indexOf('Firefox') >= 0);
STATIC_VALUES.set('isChrome', _userAgent.indexOf('Chrome') >= 0);
STATIC_VALUES.set('isSafari', _userAgent.indexOf('Safari') >= 0);
STATIC_VALUES.set('isIPad', _userAgent.indexOf('iPad') >= 0);
var hasOwnProperty = Object.prototype.hasOwnProperty;
var ContextKeyExpr = /** @class */ (function () {
    function ContextKeyExpr() {
    }
    ContextKeyExpr.false = function () {
        return ContextKeyFalseExpr.INSTANCE;
    };
    ContextKeyExpr.true = function () {
        return ContextKeyTrueExpr.INSTANCE;
    };
    ContextKeyExpr.has = function (key) {
        return ContextKeyDefinedExpr.create(key);
    };
    ContextKeyExpr.equals = function (key, value) {
        return ContextKeyEqualsExpr.create(key, value);
    };
    ContextKeyExpr.notEquals = function (key, value) {
        return ContextKeyNotEqualsExpr.create(key, value);
    };
    ContextKeyExpr.regex = function (key, value) {
        return ContextKeyRegexExpr.create(key, value);
    };
    ContextKeyExpr.in = function (key, value) {
        return ContextKeyInExpr.create(key, value);
    };
    ContextKeyExpr.not = function (key) {
        return ContextKeyNotExpr.create(key);
    };
    ContextKeyExpr.and = function () {
        var expr = [];
        for (var _i = 0; _i < arguments.length; _i++) {
            expr[_i] = arguments[_i];
        }
        return ContextKeyAndExpr.create(expr);
    };
    ContextKeyExpr.or = function () {
        var expr = [];
        for (var _i = 0; _i < arguments.length; _i++) {
            expr[_i] = arguments[_i];
        }
        return ContextKeyOrExpr.create(expr);
    };
    ContextKeyExpr.greater = function (key, value) {
        return ContextKeyGreaterExpr.create(key, value);
    };
    ContextKeyExpr.less = function (key, value) {
        return ContextKeySmallerExpr.create(key, value);
    };
    ContextKeyExpr.deserialize = function (serialized, strict) {
        if (strict === void 0) { strict = false; }
        if (!serialized) {
            return undefined;
        }
        return this._deserializeOrExpression(serialized, strict);
    };
    ContextKeyExpr._deserializeOrExpression = function (serialized, strict) {
        var _this = this;
        var pieces = serialized.split('||');
        return ContextKeyOrExpr.create(pieces.map(function (p) { return _this._deserializeAndExpression(p, strict); }));
    };
    ContextKeyExpr._deserializeAndExpression = function (serialized, strict) {
        var _this = this;
        var pieces = serialized.split('&&');
        return ContextKeyAndExpr.create(pieces.map(function (p) { return _this._deserializeOne(p, strict); }));
    };
    ContextKeyExpr._deserializeOne = function (serializedOne, strict) {
        serializedOne = serializedOne.trim();
        if (serializedOne.indexOf('!=') >= 0) {
            var pieces = serializedOne.split('!=');
            return ContextKeyNotEqualsExpr.create(pieces[0].trim(), this._deserializeValue(pieces[1], strict));
        }
        if (serializedOne.indexOf('==') >= 0) {
            var pieces = serializedOne.split('==');
            return ContextKeyEqualsExpr.create(pieces[0].trim(), this._deserializeValue(pieces[1], strict));
        }
        if (serializedOne.indexOf('=~') >= 0) {
            var pieces = serializedOne.split('=~');
            return ContextKeyRegexExpr.create(pieces[0].trim(), this._deserializeRegexValue(pieces[1], strict));
        }
        if (serializedOne.indexOf(' in ') >= 0) {
            var pieces = serializedOne.split(' in ');
            return ContextKeyInExpr.create(pieces[0].trim(), pieces[1].trim());
        }
        if (/^[^<=>]+>=[^<=>]+$/.test(serializedOne)) {
            var pieces = serializedOne.split('>=');
            return ContextKeyGreaterEqualsExpr.create(pieces[0].trim(), pieces[1].trim());
        }
        if (/^[^<=>]+>[^<=>]+$/.test(serializedOne)) {
            var pieces = serializedOne.split('>');
            return ContextKeyGreaterExpr.create(pieces[0].trim(), pieces[1].trim());
        }
        if (/^[^<=>]+<=[^<=>]+$/.test(serializedOne)) {
            var pieces = serializedOne.split('<=');
            return ContextKeySmallerEqualsExpr.create(pieces[0].trim(), pieces[1].trim());
        }
        if (/^[^<=>]+<[^<=>]+$/.test(serializedOne)) {
            var pieces = serializedOne.split('<');
            return ContextKeySmallerExpr.create(pieces[0].trim(), pieces[1].trim());
        }
        if (/^\!\s*/.test(serializedOne)) {
            return ContextKeyNotExpr.create(serializedOne.substr(1).trim());
        }
        return ContextKeyDefinedExpr.create(serializedOne);
    };
    ContextKeyExpr._deserializeValue = function (serializedValue, strict) {
        serializedValue = serializedValue.trim();
        if (serializedValue === 'true') {
            return true;
        }
        if (serializedValue === 'false') {
            return false;
        }
        var m = /^'([^']*)'$/.exec(serializedValue);
        if (m) {
            return m[1].trim();
        }
        return serializedValue;
    };
    ContextKeyExpr._deserializeRegexValue = function (serializedValue, strict) {
        if (isFalsyOrWhitespace(serializedValue)) {
            if (strict) {
                throw new Error('missing regexp-value for =~-expression');
            }
            else {
                console.warn('missing regexp-value for =~-expression');
            }
            return null;
        }
        var start = serializedValue.indexOf('/');
        var end = serializedValue.lastIndexOf('/');
        if (start === end || start < 0 /* || to < 0 */) {
            if (strict) {
                throw new Error("bad regexp-value '" + serializedValue + "', missing /-enclosure");
            }
            else {
                console.warn("bad regexp-value '" + serializedValue + "', missing /-enclosure");
            }
            return null;
        }
        var value = serializedValue.slice(start + 1, end);
        var caseIgnoreFlag = serializedValue[end + 1] === 'i' ? 'i' : '';
        try {
            return new RegExp(value, caseIgnoreFlag);
        }
        catch (e) {
            if (strict) {
                throw new Error("bad regexp-value '" + serializedValue + "', parse error: " + e);
            }
            else {
                console.warn("bad regexp-value '" + serializedValue + "', parse error: " + e);
            }
            return null;
        }
    };
    return ContextKeyExpr;
}());
export { ContextKeyExpr };
function cmp(a, b) {
    return a.cmp(b);
}
var ContextKeyFalseExpr = /** @class */ (function () {
    function ContextKeyFalseExpr() {
        this.type = 0 /* False */;
    }
    ContextKeyFalseExpr.prototype.cmp = function (other) {
        return this.type - other.type;
    };
    ContextKeyFalseExpr.prototype.equals = function (other) {
        return (other.type === this.type);
    };
    ContextKeyFalseExpr.prototype.evaluate = function (context) {
        return false;
    };
    ContextKeyFalseExpr.prototype.serialize = function () {
        return 'false';
    };
    ContextKeyFalseExpr.prototype.keys = function () {
        return [];
    };
    ContextKeyFalseExpr.prototype.map = function (mapFnc) {
        return this;
    };
    ContextKeyFalseExpr.prototype.negate = function () {
        return ContextKeyTrueExpr.INSTANCE;
    };
    ContextKeyFalseExpr.INSTANCE = new ContextKeyFalseExpr();
    return ContextKeyFalseExpr;
}());
export { ContextKeyFalseExpr };
var ContextKeyTrueExpr = /** @class */ (function () {
    function ContextKeyTrueExpr() {
        this.type = 1 /* True */;
    }
    ContextKeyTrueExpr.prototype.cmp = function (other) {
        return this.type - other.type;
    };
    ContextKeyTrueExpr.prototype.equals = function (other) {
        return (other.type === this.type);
    };
    ContextKeyTrueExpr.prototype.evaluate = function (context) {
        return true;
    };
    ContextKeyTrueExpr.prototype.serialize = function () {
        return 'true';
    };
    ContextKeyTrueExpr.prototype.keys = function () {
        return [];
    };
    ContextKeyTrueExpr.prototype.map = function (mapFnc) {
        return this;
    };
    ContextKeyTrueExpr.prototype.negate = function () {
        return ContextKeyFalseExpr.INSTANCE;
    };
    ContextKeyTrueExpr.INSTANCE = new ContextKeyTrueExpr();
    return ContextKeyTrueExpr;
}());
export { ContextKeyTrueExpr };
var ContextKeyDefinedExpr = /** @class */ (function () {
    function ContextKeyDefinedExpr(key) {
        this.key = key;
        this.type = 2 /* Defined */;
    }
    ContextKeyDefinedExpr.create = function (key) {
        var staticValue = STATIC_VALUES.get(key);
        if (typeof staticValue === 'boolean') {
            return staticValue ? ContextKeyTrueExpr.INSTANCE : ContextKeyFalseExpr.INSTANCE;
        }
        return new ContextKeyDefinedExpr(key);
    };
    ContextKeyDefinedExpr.prototype.cmp = function (other) {
        if (other.type !== this.type) {
            return this.type - other.type;
        }
        return cmp1(this.key, other.key);
    };
    ContextKeyDefinedExpr.prototype.equals = function (other) {
        if (other.type === this.type) {
            return (this.key === other.key);
        }
        return false;
    };
    ContextKeyDefinedExpr.prototype.evaluate = function (context) {
        return (!!context.getValue(this.key));
    };
    ContextKeyDefinedExpr.prototype.serialize = function () {
        return this.key;
    };
    ContextKeyDefinedExpr.prototype.keys = function () {
        return [this.key];
    };
    ContextKeyDefinedExpr.prototype.map = function (mapFnc) {
        return mapFnc.mapDefined(this.key);
    };
    ContextKeyDefinedExpr.prototype.negate = function () {
        return ContextKeyNotExpr.create(this.key);
    };
    return ContextKeyDefinedExpr;
}());
export { ContextKeyDefinedExpr };
var ContextKeyEqualsExpr = /** @class */ (function () {
    function ContextKeyEqualsExpr(key, value) {
        this.key = key;
        this.value = value;
        this.type = 4 /* Equals */;
    }
    ContextKeyEqualsExpr.create = function (key, value) {
        if (typeof value === 'boolean') {
            return (value ? ContextKeyDefinedExpr.create(key) : ContextKeyNotExpr.create(key));
        }
        var staticValue = STATIC_VALUES.get(key);
        if (typeof staticValue === 'boolean') {
            var trueValue = staticValue ? 'true' : 'false';
            return (value === trueValue ? ContextKeyTrueExpr.INSTANCE : ContextKeyFalseExpr.INSTANCE);
        }
        return new ContextKeyEqualsExpr(key, value);
    };
    ContextKeyEqualsExpr.prototype.cmp = function (other) {
        if (other.type !== this.type) {
            return this.type - other.type;
        }
        return cmp2(this.key, this.value, other.key, other.value);
    };
    ContextKeyEqualsExpr.prototype.equals = function (other) {
        if (other.type === this.type) {
            return (this.key === other.key && this.value === other.value);
        }
        return false;
    };
    ContextKeyEqualsExpr.prototype.evaluate = function (context) {
        // Intentional ==
        // eslint-disable-next-line eqeqeq
        return (context.getValue(this.key) == this.value);
    };
    ContextKeyEqualsExpr.prototype.serialize = function () {
        return this.key + " == '" + this.value + "'";
    };
    ContextKeyEqualsExpr.prototype.keys = function () {
        return [this.key];
    };
    ContextKeyEqualsExpr.prototype.map = function (mapFnc) {
        return mapFnc.mapEquals(this.key, this.value);
    };
    ContextKeyEqualsExpr.prototype.negate = function () {
        return ContextKeyNotEqualsExpr.create(this.key, this.value);
    };
    return ContextKeyEqualsExpr;
}());
export { ContextKeyEqualsExpr };
var ContextKeyInExpr = /** @class */ (function () {
    function ContextKeyInExpr(key, valueKey) {
        this.key = key;
        this.valueKey = valueKey;
        this.type = 10 /* In */;
    }
    ContextKeyInExpr.create = function (key, valueKey) {
        return new ContextKeyInExpr(key, valueKey);
    };
    ContextKeyInExpr.prototype.cmp = function (other) {
        if (other.type !== this.type) {
            return this.type - other.type;
        }
        return cmp2(this.key, this.valueKey, other.key, other.valueKey);
    };
    ContextKeyInExpr.prototype.equals = function (other) {
        if (other.type === this.type) {
            return (this.key === other.key && this.valueKey === other.valueKey);
        }
        return false;
    };
    ContextKeyInExpr.prototype.evaluate = function (context) {
        var source = context.getValue(this.valueKey);
        var item = context.getValue(this.key);
        if (Array.isArray(source)) {
            return (source.indexOf(item) >= 0);
        }
        if (typeof item === 'string' && typeof source === 'object' && source !== null) {
            return hasOwnProperty.call(source, item);
        }
        return false;
    };
    ContextKeyInExpr.prototype.serialize = function () {
        return this.key + " in '" + this.valueKey + "'";
    };
    ContextKeyInExpr.prototype.keys = function () {
        return [this.key, this.valueKey];
    };
    ContextKeyInExpr.prototype.map = function (mapFnc) {
        return mapFnc.mapIn(this.key, this.valueKey);
    };
    ContextKeyInExpr.prototype.negate = function () {
        return ContextKeyNotInExpr.create(this);
    };
    return ContextKeyInExpr;
}());
export { ContextKeyInExpr };
var ContextKeyNotInExpr = /** @class */ (function () {
    function ContextKeyNotInExpr(_actual) {
        this._actual = _actual;
        this.type = 11 /* NotIn */;
        //
    }
    ContextKeyNotInExpr.create = function (actual) {
        return new ContextKeyNotInExpr(actual);
    };
    ContextKeyNotInExpr.prototype.cmp = function (other) {
        if (other.type !== this.type) {
            return this.type - other.type;
        }
        return this._actual.cmp(other._actual);
    };
    ContextKeyNotInExpr.prototype.equals = function (other) {
        if (other.type === this.type) {
            return this._actual.equals(other._actual);
        }
        return false;
    };
    ContextKeyNotInExpr.prototype.evaluate = function (context) {
        return !this._actual.evaluate(context);
    };
    ContextKeyNotInExpr.prototype.serialize = function () {
        throw new Error('Method not implemented.');
    };
    ContextKeyNotInExpr.prototype.keys = function () {
        return this._actual.keys();
    };
    ContextKeyNotInExpr.prototype.map = function (mapFnc) {
        return new ContextKeyNotInExpr(this._actual.map(mapFnc));
    };
    ContextKeyNotInExpr.prototype.negate = function () {
        return this._actual;
    };
    return ContextKeyNotInExpr;
}());
export { ContextKeyNotInExpr };
var ContextKeyNotEqualsExpr = /** @class */ (function () {
    function ContextKeyNotEqualsExpr(key, value) {
        this.key = key;
        this.value = value;
        this.type = 5 /* NotEquals */;
    }
    ContextKeyNotEqualsExpr.create = function (key, value) {
        if (typeof value === 'boolean') {
            if (value) {
                return ContextKeyNotExpr.create(key);
            }
            return ContextKeyDefinedExpr.create(key);
        }
        var staticValue = STATIC_VALUES.get(key);
        if (typeof staticValue === 'boolean') {
            var falseValue = staticValue ? 'true' : 'false';
            return (value === falseValue ? ContextKeyFalseExpr.INSTANCE : ContextKeyTrueExpr.INSTANCE);
        }
        return new ContextKeyNotEqualsExpr(key, value);
    };
    ContextKeyNotEqualsExpr.prototype.cmp = function (other) {
        if (other.type !== this.type) {
            return this.type - other.type;
        }
        return cmp2(this.key, this.value, other.key, other.value);
    };
    ContextKeyNotEqualsExpr.prototype.equals = function (other) {
        if (other.type === this.type) {
            return (this.key === other.key && this.value === other.value);
        }
        return false;
    };
    ContextKeyNotEqualsExpr.prototype.evaluate = function (context) {
        // Intentional !=
        // eslint-disable-next-line eqeqeq
        return (context.getValue(this.key) != this.value);
    };
    ContextKeyNotEqualsExpr.prototype.serialize = function () {
        return this.key + " != '" + this.value + "'";
    };
    ContextKeyNotEqualsExpr.prototype.keys = function () {
        return [this.key];
    };
    ContextKeyNotEqualsExpr.prototype.map = function (mapFnc) {
        return mapFnc.mapNotEquals(this.key, this.value);
    };
    ContextKeyNotEqualsExpr.prototype.negate = function () {
        return ContextKeyEqualsExpr.create(this.key, this.value);
    };
    return ContextKeyNotEqualsExpr;
}());
export { ContextKeyNotEqualsExpr };
var ContextKeyNotExpr = /** @class */ (function () {
    function ContextKeyNotExpr(key) {
        this.key = key;
        this.type = 3 /* Not */;
    }
    ContextKeyNotExpr.create = function (key) {
        var staticValue = STATIC_VALUES.get(key);
        if (typeof staticValue === 'boolean') {
            return (staticValue ? ContextKeyFalseExpr.INSTANCE : ContextKeyTrueExpr.INSTANCE);
        }
        return new ContextKeyNotExpr(key);
    };
    ContextKeyNotExpr.prototype.cmp = function (other) {
        if (other.type !== this.type) {
            return this.type - other.type;
        }
        return cmp1(this.key, other.key);
    };
    ContextKeyNotExpr.prototype.equals = function (other) {
        if (other.type === this.type) {
            return (this.key === other.key);
        }
        return false;
    };
    ContextKeyNotExpr.prototype.evaluate = function (context) {
        return (!context.getValue(this.key));
    };
    ContextKeyNotExpr.prototype.serialize = function () {
        return "!" + this.key;
    };
    ContextKeyNotExpr.prototype.keys = function () {
        return [this.key];
    };
    ContextKeyNotExpr.prototype.map = function (mapFnc) {
        return mapFnc.mapNot(this.key);
    };
    ContextKeyNotExpr.prototype.negate = function () {
        return ContextKeyDefinedExpr.create(this.key);
    };
    return ContextKeyNotExpr;
}());
export { ContextKeyNotExpr };
var ContextKeyGreaterExpr = /** @class */ (function () {
    function ContextKeyGreaterExpr(key, value) {
        this.key = key;
        this.value = value;
        this.type = 12 /* Greater */;
    }
    ContextKeyGreaterExpr.create = function (key, value) {
        return new ContextKeyGreaterExpr(key, value);
    };
    ContextKeyGreaterExpr.prototype.cmp = function (other) {
        if (other.type !== this.type) {
            return this.type - other.type;
        }
        return cmp2(this.key, this.value, other.key, other.value);
    };
    ContextKeyGreaterExpr.prototype.equals = function (other) {
        if (other.type === this.type) {
            return (this.key === other.key && this.value === other.value);
        }
        return false;
    };
    ContextKeyGreaterExpr.prototype.evaluate = function (context) {
        return (parseFloat(context.getValue(this.key)) > parseFloat(this.value));
    };
    ContextKeyGreaterExpr.prototype.serialize = function () {
        return this.key + " > " + this.value;
    };
    ContextKeyGreaterExpr.prototype.keys = function () {
        return [this.key];
    };
    ContextKeyGreaterExpr.prototype.map = function (mapFnc) {
        return mapFnc.mapGreater(this.key, this.value);
    };
    ContextKeyGreaterExpr.prototype.negate = function () {
        return ContextKeySmallerEqualsExpr.create(this.key, this.value);
    };
    return ContextKeyGreaterExpr;
}());
export { ContextKeyGreaterExpr };
var ContextKeyGreaterEqualsExpr = /** @class */ (function () {
    function ContextKeyGreaterEqualsExpr(key, value) {
        this.key = key;
        this.value = value;
        this.type = 13 /* GreaterEquals */;
    }
    ContextKeyGreaterEqualsExpr.create = function (key, value) {
        return new ContextKeyGreaterEqualsExpr(key, value);
    };
    ContextKeyGreaterEqualsExpr.prototype.cmp = function (other) {
        if (other.type !== this.type) {
            return this.type - other.type;
        }
        return cmp2(this.key, this.value, other.key, other.value);
    };
    ContextKeyGreaterEqualsExpr.prototype.equals = function (other) {
        if (other.type === this.type) {
            return (this.key === other.key && this.value === other.value);
        }
        return false;
    };
    ContextKeyGreaterEqualsExpr.prototype.evaluate = function (context) {
        return (parseFloat(context.getValue(this.key)) >= parseFloat(this.value));
    };
    ContextKeyGreaterEqualsExpr.prototype.serialize = function () {
        return this.key + " >= " + this.value;
    };
    ContextKeyGreaterEqualsExpr.prototype.keys = function () {
        return [this.key];
    };
    ContextKeyGreaterEqualsExpr.prototype.map = function (mapFnc) {
        return mapFnc.mapGreaterEquals(this.key, this.value);
    };
    ContextKeyGreaterEqualsExpr.prototype.negate = function () {
        return ContextKeySmallerExpr.create(this.key, this.value);
    };
    return ContextKeyGreaterEqualsExpr;
}());
export { ContextKeyGreaterEqualsExpr };
var ContextKeySmallerExpr = /** @class */ (function () {
    function ContextKeySmallerExpr(key, value) {
        this.key = key;
        this.value = value;
        this.type = 14 /* Smaller */;
    }
    ContextKeySmallerExpr.create = function (key, value) {
        return new ContextKeySmallerExpr(key, value);
    };
    ContextKeySmallerExpr.prototype.cmp = function (other) {
        if (other.type !== this.type) {
            return this.type - other.type;
        }
        return cmp2(this.key, this.value, other.key, other.value);
    };
    ContextKeySmallerExpr.prototype.equals = function (other) {
        if (other.type === this.type) {
            return (this.key === other.key && this.value === other.value);
        }
        return false;
    };
    ContextKeySmallerExpr.prototype.evaluate = function (context) {
        return (parseFloat(context.getValue(this.key)) < parseFloat(this.value));
    };
    ContextKeySmallerExpr.prototype.serialize = function () {
        return this.key + " < " + this.value;
    };
    ContextKeySmallerExpr.prototype.keys = function () {
        return [this.key];
    };
    ContextKeySmallerExpr.prototype.map = function (mapFnc) {
        return mapFnc.mapSmaller(this.key, this.value);
    };
    ContextKeySmallerExpr.prototype.negate = function () {
        return ContextKeyGreaterEqualsExpr.create(this.key, this.value);
    };
    return ContextKeySmallerExpr;
}());
export { ContextKeySmallerExpr };
var ContextKeySmallerEqualsExpr = /** @class */ (function () {
    function ContextKeySmallerEqualsExpr(key, value) {
        this.key = key;
        this.value = value;
        this.type = 15 /* SmallerEquals */;
    }
    ContextKeySmallerEqualsExpr.create = function (key, value) {
        return new ContextKeySmallerEqualsExpr(key, value);
    };
    ContextKeySmallerEqualsExpr.prototype.cmp = function (other) {
        if (other.type !== this.type) {
            return this.type - other.type;
        }
        return cmp2(this.key, this.value, other.key, other.value);
    };
    ContextKeySmallerEqualsExpr.prototype.equals = function (other) {
        if (other.type === this.type) {
            return (this.key === other.key && this.value === other.value);
        }
        return false;
    };
    ContextKeySmallerEqualsExpr.prototype.evaluate = function (context) {
        return (parseFloat(context.getValue(this.key)) <= parseFloat(this.value));
    };
    ContextKeySmallerEqualsExpr.prototype.serialize = function () {
        return this.key + " <= " + this.value;
    };
    ContextKeySmallerEqualsExpr.prototype.keys = function () {
        return [this.key];
    };
    ContextKeySmallerEqualsExpr.prototype.map = function (mapFnc) {
        return mapFnc.mapSmallerEquals(this.key, this.value);
    };
    ContextKeySmallerEqualsExpr.prototype.negate = function () {
        return ContextKeyGreaterExpr.create(this.key, this.value);
    };
    return ContextKeySmallerEqualsExpr;
}());
export { ContextKeySmallerEqualsExpr };
var ContextKeyRegexExpr = /** @class */ (function () {
    function ContextKeyRegexExpr(key, regexp) {
        this.key = key;
        this.regexp = regexp;
        this.type = 7 /* Regex */;
        //
    }
    ContextKeyRegexExpr.create = function (key, regexp) {
        return new ContextKeyRegexExpr(key, regexp);
    };
    ContextKeyRegexExpr.prototype.cmp = function (other) {
        if (other.type !== this.type) {
            return this.type - other.type;
        }
        if (this.key < other.key) {
            return -1;
        }
        if (this.key > other.key) {
            return 1;
        }
        var thisSource = this.regexp ? this.regexp.source : '';
        var otherSource = other.regexp ? other.regexp.source : '';
        if (thisSource < otherSource) {
            return -1;
        }
        if (thisSource > otherSource) {
            return 1;
        }
        return 0;
    };
    ContextKeyRegexExpr.prototype.equals = function (other) {
        if (other.type === this.type) {
            var thisSource = this.regexp ? this.regexp.source : '';
            var otherSource = other.regexp ? other.regexp.source : '';
            return (this.key === other.key && thisSource === otherSource);
        }
        return false;
    };
    ContextKeyRegexExpr.prototype.evaluate = function (context) {
        var value = context.getValue(this.key);
        return this.regexp ? this.regexp.test(value) : false;
    };
    ContextKeyRegexExpr.prototype.serialize = function () {
        var value = this.regexp
            ? "/" + this.regexp.source + "/" + (this.regexp.ignoreCase ? 'i' : '')
            : '/invalid/';
        return this.key + " =~ " + value;
    };
    ContextKeyRegexExpr.prototype.keys = function () {
        return [this.key];
    };
    ContextKeyRegexExpr.prototype.map = function (mapFnc) {
        return mapFnc.mapRegex(this.key, this.regexp);
    };
    ContextKeyRegexExpr.prototype.negate = function () {
        return ContextKeyNotRegexExpr.create(this);
    };
    return ContextKeyRegexExpr;
}());
export { ContextKeyRegexExpr };
var ContextKeyNotRegexExpr = /** @class */ (function () {
    function ContextKeyNotRegexExpr(_actual) {
        this._actual = _actual;
        this.type = 8 /* NotRegex */;
        //
    }
    ContextKeyNotRegexExpr.create = function (actual) {
        return new ContextKeyNotRegexExpr(actual);
    };
    ContextKeyNotRegexExpr.prototype.cmp = function (other) {
        if (other.type !== this.type) {
            return this.type - other.type;
        }
        return this._actual.cmp(other._actual);
    };
    ContextKeyNotRegexExpr.prototype.equals = function (other) {
        if (other.type === this.type) {
            return this._actual.equals(other._actual);
        }
        return false;
    };
    ContextKeyNotRegexExpr.prototype.evaluate = function (context) {
        return !this._actual.evaluate(context);
    };
    ContextKeyNotRegexExpr.prototype.serialize = function () {
        throw new Error('Method not implemented.');
    };
    ContextKeyNotRegexExpr.prototype.keys = function () {
        return this._actual.keys();
    };
    ContextKeyNotRegexExpr.prototype.map = function (mapFnc) {
        return new ContextKeyNotRegexExpr(this._actual.map(mapFnc));
    };
    ContextKeyNotRegexExpr.prototype.negate = function () {
        return this._actual;
    };
    return ContextKeyNotRegexExpr;
}());
export { ContextKeyNotRegexExpr };
var ContextKeyAndExpr = /** @class */ (function () {
    function ContextKeyAndExpr(expr) {
        this.expr = expr;
        this.type = 6 /* And */;
    }
    ContextKeyAndExpr.create = function (_expr) {
        return ContextKeyAndExpr._normalizeArr(_expr);
    };
    ContextKeyAndExpr.prototype.cmp = function (other) {
        if (other.type !== this.type) {
            return this.type - other.type;
        }
        if (this.expr.length < other.expr.length) {
            return -1;
        }
        if (this.expr.length > other.expr.length) {
            return 1;
        }
        for (var i = 0, len = this.expr.length; i < len; i++) {
            var r = cmp(this.expr[i], other.expr[i]);
            if (r !== 0) {
                return r;
            }
        }
        return 0;
    };
    ContextKeyAndExpr.prototype.equals = function (other) {
        if (other.type === this.type) {
            if (this.expr.length !== other.expr.length) {
                return false;
            }
            for (var i = 0, len = this.expr.length; i < len; i++) {
                if (!this.expr[i].equals(other.expr[i])) {
                    return false;
                }
            }
            return true;
        }
        return false;
    };
    ContextKeyAndExpr.prototype.evaluate = function (context) {
        for (var i = 0, len = this.expr.length; i < len; i++) {
            if (!this.expr[i].evaluate(context)) {
                return false;
            }
        }
        return true;
    };
    ContextKeyAndExpr._normalizeArr = function (arr) {
        var e_1, _a;
        var expr = [];
        var hasTrue = false;
        try {
            for (var arr_1 = __values(arr), arr_1_1 = arr_1.next(); !arr_1_1.done; arr_1_1 = arr_1.next()) {
                var e = arr_1_1.value;
                if (!e) {
                    continue;
                }
                if (e.type === 1 /* True */) {
                    // anything && true ==> anything
                    hasTrue = true;
                    continue;
                }
                if (e.type === 0 /* False */) {
                    // anything && false ==> false
                    return ContextKeyFalseExpr.INSTANCE;
                }
                if (e.type === 6 /* And */) {
                    expr.push.apply(expr, __spreadArray([], __read(e.expr)));
                    continue;
                }
                expr.push(e);
            }
        }
        catch (e_1_1) { e_1 = { error: e_1_1 }; }
        finally {
            try {
                if (arr_1_1 && !arr_1_1.done && (_a = arr_1.return)) _a.call(arr_1);
            }
            finally { if (e_1) throw e_1.error; }
        }
        if (expr.length === 0 && hasTrue) {
            return ContextKeyTrueExpr.INSTANCE;
        }
        if (expr.length === 0) {
            return undefined;
        }
        if (expr.length === 1) {
            return expr[0];
        }
        expr.sort(cmp);
        var _loop_1 = function () {
            var lastElement = expr[expr.length - 1];
            if (lastElement.type !== 9 /* Or */) {
                return "break";
            }
            // pop the last element
            expr.pop();
            // pop the second to last element
            var secondToLastElement = expr.pop();
            // distribute `lastElement` over `secondToLastElement`
            var resultElement = ContextKeyOrExpr.create(lastElement.expr.map(function (el) { return ContextKeyAndExpr.create([el, secondToLastElement]); }));
            if (resultElement) {
                expr.push(resultElement);
                expr.sort(cmp);
            }
        };
        // We must distribute any OR expression because we don't support parens
        // OR extensions will be at the end (due to sorting rules)
        while (expr.length > 1) {
            var state_1 = _loop_1();
            if (state_1 === "break")
                break;
        }
        if (expr.length === 1) {
            return expr[0];
        }
        return new ContextKeyAndExpr(expr);
    };
    ContextKeyAndExpr.prototype.serialize = function () {
        return this.expr.map(function (e) { return e.serialize(); }).join(' && ');
    };
    ContextKeyAndExpr.prototype.keys = function () {
        var e_2, _a;
        var result = [];
        try {
            for (var _b = __values(this.expr), _c = _b.next(); !_c.done; _c = _b.next()) {
                var expr = _c.value;
                result.push.apply(result, __spreadArray([], __read(expr.keys())));
            }
        }
        catch (e_2_1) { e_2 = { error: e_2_1 }; }
        finally {
            try {
                if (_c && !_c.done && (_a = _b.return)) _a.call(_b);
            }
            finally { if (e_2) throw e_2.error; }
        }
        return result;
    };
    ContextKeyAndExpr.prototype.map = function (mapFnc) {
        return new ContextKeyAndExpr(this.expr.map(function (expr) { return expr.map(mapFnc); }));
    };
    ContextKeyAndExpr.prototype.negate = function () {
        var e_3, _a;
        var result = [];
        try {
            for (var _b = __values(this.expr), _c = _b.next(); !_c.done; _c = _b.next()) {
                var expr = _c.value;
                result.push(expr.negate());
            }
        }
        catch (e_3_1) { e_3 = { error: e_3_1 }; }
        finally {
            try {
                if (_c && !_c.done && (_a = _b.return)) _a.call(_b);
            }
            finally { if (e_3) throw e_3.error; }
        }
        return ContextKeyOrExpr.create(result);
    };
    return ContextKeyAndExpr;
}());
export { ContextKeyAndExpr };
var ContextKeyOrExpr = /** @class */ (function () {
    function ContextKeyOrExpr(expr) {
        this.expr = expr;
        this.type = 9 /* Or */;
    }
    ContextKeyOrExpr.create = function (_expr) {
        var expr = ContextKeyOrExpr._normalizeArr(_expr);
        if (expr.length === 0) {
            return undefined;
        }
        if (expr.length === 1) {
            return expr[0];
        }
        return new ContextKeyOrExpr(expr);
    };
    ContextKeyOrExpr.prototype.cmp = function (other) {
        if (other.type !== this.type) {
            return this.type - other.type;
        }
        if (this.expr.length < other.expr.length) {
            return -1;
        }
        if (this.expr.length > other.expr.length) {
            return 1;
        }
        for (var i = 0, len = this.expr.length; i < len; i++) {
            var r = cmp(this.expr[i], other.expr[i]);
            if (r !== 0) {
                return r;
            }
        }
        return 0;
    };
    ContextKeyOrExpr.prototype.equals = function (other) {
        if (other.type === this.type) {
            if (this.expr.length !== other.expr.length) {
                return false;
            }
            for (var i = 0, len = this.expr.length; i < len; i++) {
                if (!this.expr[i].equals(other.expr[i])) {
                    return false;
                }
            }
            return true;
        }
        return false;
    };
    ContextKeyOrExpr.prototype.evaluate = function (context) {
        for (var i = 0, len = this.expr.length; i < len; i++) {
            if (this.expr[i].evaluate(context)) {
                return true;
            }
        }
        return false;
    };
    ContextKeyOrExpr._normalizeArr = function (arr) {
        var expr = [];
        var hasFalse = false;
        if (arr) {
            for (var i = 0, len = arr.length; i < len; i++) {
                var e = arr[i];
                if (!e) {
                    continue;
                }
                if (e.type === 0 /* False */) {
                    // anything || false ==> anything
                    hasFalse = true;
                    continue;
                }
                if (e.type === 1 /* True */) {
                    // anything || true ==> true
                    return [ContextKeyTrueExpr.INSTANCE];
                }
                if (e.type === 9 /* Or */) {
                    expr = expr.concat(e.expr);
                    continue;
                }
                expr.push(e);
            }
            if (expr.length === 0 && hasFalse) {
                return [ContextKeyFalseExpr.INSTANCE];
            }
            expr.sort(cmp);
        }
        return expr;
    };
    ContextKeyOrExpr.prototype.serialize = function () {
        return this.expr.map(function (e) { return e.serialize(); }).join(' || ');
    };
    ContextKeyOrExpr.prototype.keys = function () {
        var e_4, _a;
        var result = [];
        try {
            for (var _b = __values(this.expr), _c = _b.next(); !_c.done; _c = _b.next()) {
                var expr = _c.value;
                result.push.apply(result, __spreadArray([], __read(expr.keys())));
            }
        }
        catch (e_4_1) { e_4 = { error: e_4_1 }; }
        finally {
            try {
                if (_c && !_c.done && (_a = _b.return)) _a.call(_b);
            }
            finally { if (e_4) throw e_4.error; }
        }
        return result;
    };
    ContextKeyOrExpr.prototype.map = function (mapFnc) {
        return new ContextKeyOrExpr(this.expr.map(function (expr) { return expr.map(mapFnc); }));
    };
    ContextKeyOrExpr.prototype.negate = function () {
        var e_5, _a, e_6, _b, e_7, _c;
        var result = [];
        try {
            for (var _d = __values(this.expr), _e = _d.next(); !_e.done; _e = _d.next()) {
                var expr = _e.value;
                result.push(expr.negate());
            }
        }
        catch (e_5_1) { e_5 = { error: e_5_1 }; }
        finally {
            try {
                if (_e && !_e.done && (_a = _d.return)) _a.call(_d);
            }
            finally { if (e_5) throw e_5.error; }
        }
        var terminals = function (node) {
            if (node.type === 9 /* Or */) {
                return node.expr;
            }
            return [node];
        };
        // We don't support parens, so here we distribute the AND over the OR terminals
        // We always take the first 2 AND pairs and distribute them
        while (result.length > 1) {
            var LEFT = result.shift();
            var RIGHT = result.shift();
            var all = [];
            try {
                for (var _f = (e_6 = void 0, __values(terminals(LEFT))), _g = _f.next(); !_g.done; _g = _f.next()) {
                    var left = _g.value;
                    try {
                        for (var _h = (e_7 = void 0, __values(terminals(RIGHT))), _j = _h.next(); !_j.done; _j = _h.next()) {
                            var right = _j.value;
                            all.push(ContextKeyExpr.and(left, right));
                        }
                    }
                    catch (e_7_1) { e_7 = { error: e_7_1 }; }
                    finally {
                        try {
                            if (_j && !_j.done && (_c = _h.return)) _c.call(_h);
                        }
                        finally { if (e_7) throw e_7.error; }
                    }
                }
            }
            catch (e_6_1) { e_6 = { error: e_6_1 }; }
            finally {
                try {
                    if (_g && !_g.done && (_b = _f.return)) _b.call(_f);
                }
                finally { if (e_6) throw e_6.error; }
            }
            result.unshift(ContextKeyExpr.or.apply(ContextKeyExpr, __spreadArray([], __read(all))));
        }
        return result[0];
    };
    return ContextKeyOrExpr;
}());
export { ContextKeyOrExpr };
var RawContextKey = /** @class */ (function (_super) {
    __extends(RawContextKey, _super);
    function RawContextKey(key, defaultValue, metaOrHide) {
        var _this = _super.call(this, key) || this;
        _this.key = key;
        _this._defaultValue = defaultValue;
        // collect all context keys into a central place
        if (typeof metaOrHide === 'object') {
            RawContextKey._info.push(__assign(__assign({}, metaOrHide), { key: key }));
        }
        else if (metaOrHide !== true) {
            RawContextKey._info.push({ key: key, description: metaOrHide, type: defaultValue !== null && defaultValue !== undefined ? typeof defaultValue : undefined });
        }
        return _this;
    }
    RawContextKey.all = function () {
        return RawContextKey._info.values();
    };
    RawContextKey.prototype.bindTo = function (target) {
        return target.createKey(this.key, this._defaultValue);
    };
    RawContextKey.prototype.getValue = function (target) {
        return target.getContextKeyValue(this.key);
    };
    RawContextKey.prototype.toNegated = function () {
        return ContextKeyExpr.not(this.key);
    };
    RawContextKey.prototype.isEqualTo = function (value) {
        return ContextKeyExpr.equals(this.key, value);
    };
    RawContextKey.prototype.notEqualsTo = function (value) {
        return ContextKeyExpr.notEquals(this.key, value);
    };
    RawContextKey._info = [];
    return RawContextKey;
}(ContextKeyDefinedExpr));
export { RawContextKey };
export var IContextKeyService = createDecorator('contextKeyService');
export var SET_CONTEXT_COMMAND_ID = 'setContext';
function cmp1(key1, key2) {
    if (key1 < key2) {
        return -1;
    }
    if (key1 > key2) {
        return 1;
    }
    return 0;
}
function cmp2(key1, value1, key2, value2) {
    if (key1 < key2) {
        return -1;
    }
    if (key1 > key2) {
        return 1;
    }
    if (value1 < value2) {
        return -1;
    }
    if (value1 > value2) {
        return 1;
    }
    return 0;
}
