/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
import { ContextView } from '../../../base/browser/ui/contextview/contextview';
import { Disposable, toDisposable } from '../../../base/common/lifecycle';
import { ILayoutService } from '../../layout/browser/layoutService';
var ContextViewService = /** @class */ (function (_super) {
    __extends(ContextViewService, _super);
    function ContextViewService(layoutService) {
        var _this = _super.call(this) || this;
        _this.layoutService = layoutService;
        _this.currentViewDisposable = Disposable.None;
        _this.container = layoutService.container;
        _this.contextView = _this._register(new ContextView(_this.container, 1 /* ABSOLUTE */));
        _this.layout();
        _this._register(layoutService.onDidLayout(function () { return _this.layout(); }));
        return _this;
    }
    // ContextView
    ContextViewService.prototype.setContainer = function (container, domPosition) {
        this.contextView.setContainer(container, domPosition || 1 /* ABSOLUTE */);
    };
    ContextViewService.prototype.showContextView = function (delegate, container, shadowRoot) {
        var _this = this;
        if (container) {
            if (container !== this.container) {
                this.container = container;
                this.setContainer(container, shadowRoot ? 3 /* FIXED_SHADOW */ : 2 /* FIXED */);
            }
        }
        else {
            if (this.container !== this.layoutService.container) {
                this.container = this.layoutService.container;
                this.setContainer(this.container, 1 /* ABSOLUTE */);
            }
        }
        this.contextView.show(delegate);
        var disposable = toDisposable(function () {
            if (_this.currentViewDisposable === disposable) {
                _this.hideContextView();
            }
        });
        this.currentViewDisposable = disposable;
        return disposable;
    };
    ContextViewService.prototype.getContextViewElement = function () {
        return this.contextView.getViewElement();
    };
    ContextViewService.prototype.layout = function () {
        this.contextView.layout();
    };
    ContextViewService.prototype.hideContextView = function (data) {
        this.contextView.hide(data);
    };
    ContextViewService = __decorate([
        __param(0, ILayoutService)
    ], ContextViewService);
    return ContextViewService;
}(Disposable));
export { ContextViewService };
