/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/
var __read = (this && this.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};
var __spreadArray = (this && this.__spreadArray) || function (to, from) {
    for (var i = 0, il = from.length, j = to.length; i < il; i++, j++)
        to[j] = from[i];
    return to;
};
import { Event, Emitter } from './event';
var Sequence = /** @class */ (function () {
    function Sequence() {
        this.elements = [];
        this._onDidSplice = new Emitter();
        this.onDidSplice = this._onDidSplice.event;
    }
    Sequence.prototype.splice = function (start, deleteCount, toInsert) {
        var _a;
        if (toInsert === void 0) { toInsert = []; }
        (_a = this.elements).splice.apply(_a, __spreadArray([start, deleteCount], __read(toInsert)));
        this._onDidSplice.fire({ start: start, deleteCount: deleteCount, toInsert: toInsert });
    };
    return Sequence;
}());
export { Sequence };
var SimpleSequence = /** @class */ (function () {
    function SimpleSequence(elements, onDidAdd, onDidRemove) {
        var _this = this;
        this._elements = __spreadArray([], __read(elements));
        this.onDidSplice = Event.any(Event.map(onDidAdd, function (e) { return ({ start: _this.elements.length, deleteCount: 0, toInsert: [e] }); }), Event.map(Event.filter(Event.map(onDidRemove, function (e) { return _this.elements.indexOf(e); }), function (i) { return i > -1; }), function (i) { return ({ start: i, deleteCount: 1, toInsert: [] }); }));
        this.disposable = this.onDidSplice(function (_a) {
            var _b;
            var start = _a.start, deleteCount = _a.deleteCount, toInsert = _a.toInsert;
            return (_b = _this._elements).splice.apply(_b, __spreadArray([start, deleteCount], __read(toInsert)));
        });
    }
    Object.defineProperty(SimpleSequence.prototype, "elements", {
        get: function () { return this._elements; },
        enumerable: false,
        configurable: true
    });
    SimpleSequence.prototype.dispose = function () {
        this.disposable.dispose();
    };
    return SimpleSequence;
}());
export { SimpleSequence };
