/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/
var __values = (this && this.__values) || function(o) {
    var s = typeof Symbol === "function" && Symbol.iterator, m = s && o[s], i = 0;
    if (m) return m.call(o);
    if (o && typeof o.length === "number") return {
        next: function () {
            if (o && i >= o.length) o = void 0;
            return { value: o && o[i++], done: !o };
        }
    };
    throw new TypeError(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
};
import { sanitizeRanges } from './syntaxRangeProvider';
export var ID_INIT_PROVIDER = 'init';
var InitializingRangeProvider = /** @class */ (function () {
    function InitializingRangeProvider(editorModel, initialRanges, onTimeout, timeoutTime) {
        this.editorModel = editorModel;
        this.id = ID_INIT_PROVIDER;
        if (initialRanges.length) {
            var toDecorationRange = function (range) {
                return {
                    range: {
                        startLineNumber: range.startLineNumber,
                        startColumn: 0,
                        endLineNumber: range.endLineNumber,
                        endColumn: editorModel.getLineLength(range.endLineNumber)
                    },
                    options: {
                        stickiness: 1 /* NeverGrowsWhenTypingAtEdges */
                    }
                };
            };
            this.decorationIds = editorModel.deltaDecorations([], initialRanges.map(toDecorationRange));
            this.timeout = setTimeout(onTimeout, timeoutTime);
        }
    }
    InitializingRangeProvider.prototype.dispose = function () {
        if (this.decorationIds) {
            this.editorModel.deltaDecorations(this.decorationIds, []);
            this.decorationIds = undefined;
        }
        if (typeof this.timeout === 'number') {
            clearTimeout(this.timeout);
            this.timeout = undefined;
        }
    };
    InitializingRangeProvider.prototype.compute = function (cancelationToken) {
        var e_1, _a;
        var foldingRangeData = [];
        if (this.decorationIds) {
            try {
                for (var _b = __values(this.decorationIds), _c = _b.next(); !_c.done; _c = _b.next()) {
                    var id = _c.value;
                    var range = this.editorModel.getDecorationRange(id);
                    if (range) {
                        foldingRangeData.push({ start: range.startLineNumber, end: range.endLineNumber, rank: 1 });
                    }
                }
            }
            catch (e_1_1) { e_1 = { error: e_1_1 }; }
            finally {
                try {
                    if (_c && !_c.done && (_a = _b.return)) _a.call(_b);
                }
                finally { if (e_1) throw e_1.error; }
            }
        }
        return Promise.resolve(sanitizeRanges(foldingRangeData, Number.MAX_VALUE));
    };
    return InitializingRangeProvider;
}());
export { InitializingRangeProvider };
