"use strict";
/********************************************************************************
 * Copyright (C) 2015-2021 Red Hat, Inc.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 *
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is available at
 * https://www.gnu.org/software/classpath/license.html.
 *
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 ********************************************************************************/
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.VsCodePluginScanner = void 0;
const path = require("path");
const inversify_1 = require("@theia/core/shared/inversify");
const plugin_ext_1 = require("@theia/plugin-ext");
const scanner_theia_1 = require("@theia/plugin-ext/lib/hosted/node/scanners/scanner-theia");
let VsCodePluginScanner = class VsCodePluginScanner extends scanner_theia_1.TheiaPluginScanner {
    constructor() {
        super(...arguments);
        this.VSCODE_TYPE = 'vscode';
        this.VSCODE_PREFIX = 'vscode:extension/';
    }
    get apiType() {
        return this.VSCODE_TYPE;
    }
    getModel(plugin) {
        // publisher can be empty on vscode extension development
        const publisher = plugin.publisher || '';
        const result = {
            packagePath: plugin.packagePath,
            packageUri: this.pluginUriFactory.createUri(plugin).toString(),
            // see id definition: https://github.com/microsoft/vscode/blob/15916055fe0cb9411a5f36119b3b012458fe0a1d/src/vs/platform/extensions/common/extensions.ts#L167-L169
            id: `${publisher.toLowerCase()}.${plugin.name.toLowerCase()}`,
            name: plugin.name,
            publisher: publisher,
            version: plugin.version,
            displayName: plugin.displayName,
            description: plugin.description,
            engine: {
                type: this.VSCODE_TYPE,
                version: plugin.engines[this.VSCODE_TYPE]
            },
            entryPoint: {
                backend: plugin.main
            },
            iconUrl: plugin.icon && plugin_ext_1.PluginPackage.toPluginUrl(plugin, plugin.icon),
            readmeUrl: plugin_ext_1.PluginPackage.toPluginUrl(plugin, './README.md'),
            licenseUrl: plugin_ext_1.PluginPackage.toPluginUrl(plugin, './LICENSE')
        };
        return result;
    }
    /**
     * Maps extension dependencies to deployable extension dependencies.
     */
    getDependencies(plugin) {
        // Store the list of dependencies.
        const dependencies = new Map();
        // Iterate through the list of dependencies from `extensionDependencies` and `extensionPack`.
        for (const dependency of [plugin.extensionDependencies, plugin.extensionPack]) {
            if (dependency !== undefined) {
                // Iterate over the list of dependencies present, and add them to the collection.
                dependency.forEach((dep) => {
                    const dependencyId = dep.toLowerCase();
                    dependencies.set(dependencyId, this.VSCODE_PREFIX + dependencyId);
                });
            }
        }
        // Return the map of dependencies if present, else `undefined`.
        return dependencies.size > 0 ? dependencies : undefined;
    }
    getLifecycle(plugin) {
        return {
            startMethod: 'activate',
            stopMethod: 'deactivate',
            backendInitPath: path.join(__dirname, 'plugin-vscode-init'),
        };
    }
};
VsCodePluginScanner = __decorate([
    inversify_1.injectable()
], VsCodePluginScanner);
exports.VsCodePluginScanner = VsCodePluginScanner;
//# sourceMappingURL=scanner-vscode.js.map