"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.OutputChannelImpl = void 0;
class OutputChannelImpl {
    constructor(name, proxy, pluginInfo) {
        this.name = name;
        this.proxy = proxy;
        this.pluginInfo = pluginInfo;
    }
    dispose() {
        if (!this.disposed) {
            this.proxy.$dispose(this.name).then(() => {
                this.disposed = true;
            });
        }
    }
    append(value) {
        this.validate();
        this.proxy.$append(this.name, value, this.pluginInfo);
    }
    appendLine(value) {
        this.validate();
        this.append(value + '\n');
    }
    clear() {
        this.validate();
        this.proxy.$clear(this.name);
    }
    show(preserveFocus) {
        this.validate();
        this.proxy.$reveal(this.name, !!preserveFocus);
    }
    hide() {
        this.validate();
        this.proxy.$close(this.name);
    }
    validate() {
        if (this.disposed) {
            throw new Error('Channel has been closed');
        }
    }
}
exports.OutputChannelImpl = OutputChannelImpl;
//# sourceMappingURL=output-channel-item.js.map