/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal.handlers;

import java.util.Arrays;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.NodeFinder;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.manipulation.CoreASTProvider;
import org.eclipse.jdt.ls.core.internal.JDTUtils;
import org.eclipse.jdt.ls.core.internal.JavaLanguageServerPlugin;
import org.eclipse.jdt.ls.core.internal.handlers.JsonRpcHelpers;
import org.eclipse.lsp4j.Location;
import org.eclipse.lsp4j.TextDocumentPositionParams;

public class NavigateToTypeDefinitionHandler {
    public List<? extends Location> typeDefinition(TextDocumentPositionParams position, IProgressMonitor monitor) {
        ITypeRoot unit = JDTUtils.resolveTypeRoot(position.getTextDocument().getUri());
        Location location = null;
        if (unit != null && !monitor.isCanceled()) {
            location = this.computeTypeDefinitionNavigation(unit, position.getPosition().getLine(), position.getPosition().getCharacter(), monitor);
        }
        return location == null ? null : Arrays.asList(location);
    }

    private Location computeTypeDefinitionNavigation(ITypeRoot unit, int line, int column, IProgressMonitor monitor) {
        int offset;
        CompilationUnit ast;
        block10: {
            ast = CoreASTProvider.getInstance().getAST(unit, CoreASTProvider.WAIT_YES, monitor);
            offset = JsonRpcHelpers.toOffset(unit.getBuffer(), line, column);
            if (ast != null && offset >= 0) break block10;
            return null;
        }
        try {
            IBinding resolvedBinding;
            NodeFinder finder = new NodeFinder((ASTNode)ast, offset, 0);
            ASTNode coveringNode = finder.getCoveringNode();
            if (coveringNode instanceof SimpleName && (resolvedBinding = ((SimpleName)coveringNode).resolveBinding()) != null) {
                ITypeBinding typeBinding = null;
                if (resolvedBinding instanceof IVariableBinding) {
                    typeBinding = ((IVariableBinding)resolvedBinding).getType();
                } else if (resolvedBinding instanceof ITypeBinding) {
                    typeBinding = (ITypeBinding)resolvedBinding;
                }
                if (typeBinding != null && typeBinding.getJavaElement() != null) {
                    IJavaElement element = typeBinding.getJavaElement();
                    ICompilationUnit compilationUnit = (ICompilationUnit)element.getAncestor(5);
                    IClassFile cf = (IClassFile)element.getAncestor(6);
                    if (compilationUnit != null || cf != null && cf.getSourceRange() != null) {
                        return JDTUtils.toLocation(element);
                    }
                    if (element instanceof IMember && ((IMember)element).getClassFile() != null) {
                        return JDTUtils.toLocation(((IMember)element).getClassFile());
                    }
                }
            }
        }
        catch (CoreException e) {
            JavaLanguageServerPlugin.logException("Problem computing typeDefinition for" + unit.getElementName(), e);
        }
        return null;
    }
}

