"use strict";
// *****************************************************************************
// Copyright (C) 2018 Red Hat, Inc. and others.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
// *****************************************************************************
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.createUntitledURI = exports.UntitledResource = exports.UntitledResourceResolver = void 0;
const event_1 = require("@theia/core/lib/common/event");
const inversify_1 = require("@theia/core/shared/inversify");
const uri_1 = require("@theia/core/lib/common/uri");
const uri_components_1 = require("../../../common/uri-components");
const monaco = require("@theia/monaco-editor-core");
let index = 0;
let UntitledResourceResolver = class UntitledResourceResolver {
    constructor() {
        this.resources = new Map();
    }
    async resolve(uri) {
        if (uri.scheme !== uri_components_1.Schemes.untitled) {
            throw new Error('The given uri is not untitled file uri: ' + uri);
        }
        else {
            const untitledResource = this.resources.get(uri.toString());
            if (!untitledResource) {
                return this.createUntitledResource('', '', uri);
            }
            else {
                return untitledResource;
            }
        }
    }
    async createUntitledResource(content, language, uri) {
        let extension;
        if (language) {
            for (const lang of monaco.languages.getLanguages()) {
                if (lang.id === language) {
                    if (lang.extensions) {
                        extension = lang.extensions[0];
                        break;
                    }
                }
            }
        }
        return new UntitledResource(this.resources, uri ? uri : new uri_1.default().withScheme(uri_components_1.Schemes.untitled).withPath(`/Untitled-${index++}${extension ? extension : ''}`), content);
    }
};
UntitledResourceResolver = __decorate([
    (0, inversify_1.injectable)()
], UntitledResourceResolver);
exports.UntitledResourceResolver = UntitledResourceResolver;
class UntitledResource {
    constructor(resources, uri, content) {
        this.resources = resources;
        this.uri = uri;
        this.content = content;
        this.onDidChangeContentsEmitter = new event_1.Emitter();
        this.onDidChangeContents = this.onDidChangeContentsEmitter.event;
        this.resources.set(this.uri.toString(), this);
    }
    dispose() {
        this.resources.delete(this.uri.toString());
        this.onDidChangeContentsEmitter.dispose();
    }
    async readContents(options) {
        if (this.content) {
            return this.content;
        }
        else {
            return '';
        }
    }
    async saveContents(content, options) {
        // This function must exist to ensure readOnly is false for the Monaco editor.
        // However it should not be called because saving 'untitled' is always processed as 'Save As'.
        throw Error('never');
    }
    fireDidChangeContents() {
        this.onDidChangeContentsEmitter.fire(undefined);
    }
    get version() {
        return undefined;
    }
    get encoding() {
        return undefined;
    }
}
exports.UntitledResource = UntitledResource;
function createUntitledURI(language) {
    let extension;
    if (language) {
        for (const lang of monaco.languages.getLanguages()) {
            if (lang.id === language) {
                if (lang.extensions) {
                    extension = lang.extensions[0];
                    break;
                }
            }
        }
    }
    return new uri_1.default().withScheme(uri_components_1.Schemes.untitled).withPath(`/Untitled-${index++}${extension ? extension : ''}`);
}
exports.createUntitledURI = createUntitledURI;
//# sourceMappingURL=untitled-resource.js.map