"use strict";
// *****************************************************************************
// Copyright (C) 2017 TypeFox and others.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
// *****************************************************************************
Object.defineProperty(exports, "__esModule", { value: true });
exports.frontendApplicationModule = exports.bindPreferenceService = exports.bindMessageService = exports.bindResourceProvider = void 0;
require("../../src/browser/style/index.css");
require('../../src/browser/style/materialcolors.css').use();
require("font-awesome/css/font-awesome.min.css");
require("file-icons-js/css/style.css");
require("@vscode/codicons/dist/codicon.css");
const inversify_1 = require("inversify");
const common_1 = require("../common");
const keybinding_1 = require("./keybinding");
const frontend_application_1 = require("./frontend-application");
const opener_service_1 = require("./opener-service");
const http_open_handler_1 = require("./http-open-handler");
const common_frontend_contribution_1 = require("./common-frontend-contribution");
const storage_service_1 = require("./storage-service");
const widget_manager_1 = require("./widget-manager");
const shell_1 = require("./shell");
const status_bar_1 = require("./status-bar/status-bar");
const label_parser_1 = require("./label-parser");
const label_provider_1 = require("./label-provider");
const preferences_1 = require("./preferences");
const context_menu_renderer_1 = require("./context-menu-renderer");
const theming_1 = require("./theming");
const connection_status_service_1 = require("./connection-status-service");
const diff_uris_1 = require("./diff-uris");
const application_protocol_1 = require("../common/application-protocol");
const messaging_1 = require("./messaging");
const about_dialog_1 = require("./about-dialog");
const env_variables_1 = require("./../common/env-variables");
const frontend_application_state_1 = require("./frontend-application-state");
const json_schema_store_1 = require("./json-schema-store");
const tab_bar_toolbar_1 = require("./shell/tab-bar-toolbar");
const core_preferences_1 = require("./core-preferences");
const context_key_service_1 = require("./context-key-service");
const resource_context_key_1 = require("./resource-context-key");
const keyboard_layout_service_1 = require("./keyboard/keyboard-layout-service");
const mime_service_1 = require("./mime-service");
const application_shell_mouse_tracker_1 = require("./shell/application-shell-mouse-tracker");
const view_container_1 = require("./view-container");
const quick_view_service_1 = require("./quick-input/quick-view-service");
const dialogs_1 = require("./dialogs");
const progress_location_service_1 = require("./progress-location-service");
const progress_service_protocol_1 = require("../common/progress-service-protocol");
const progress_service_1 = require("../common/progress-service");
const progress_client_1 = require("./progress-client");
const progress_status_bar_item_1 = require("./progress-status-bar-item");
const tab_bar_decorator_1 = require("./shell/tab-bar-decorator");
const context_menu_context_1 = require("./menu/context-menu-context");
const frontend_application_bindings_1 = require("./frontend-application-bindings");
Object.defineProperty(exports, "bindResourceProvider", { enumerable: true, get: function () { return frontend_application_bindings_1.bindResourceProvider; } });
Object.defineProperty(exports, "bindMessageService", { enumerable: true, get: function () { return frontend_application_bindings_1.bindMessageService; } });
Object.defineProperty(exports, "bindPreferenceService", { enumerable: true, get: function () { return frontend_application_bindings_1.bindPreferenceService; } });
const color_registry_1 = require("./color-registry");
const color_application_contribution_1 = require("./color-application-contribution");
const external_uri_service_1 = require("./external-uri-service");
const icon_theme_service_1 = require("./icon-theme-service");
const icon_theme_contribution_1 = require("./icon-theme-contribution");
const tree_label_provider_1 = require("./tree/tree-label-provider");
const progress_bar_1 = require("./progress-bar");
const progress_bar_factory_1 = require("./progress-bar-factory");
const command_open_handler_1 = require("./command-open-handler");
const language_service_1 = require("./language-service");
const encoding_registry_1 = require("./encoding-registry");
const encoding_service_1 = require("../common/encoding-service");
const authentication_service_1 = require("../browser/authentication-service");
const decorations_service_1 = require("./decorations-service");
const keytar_protocol_1 = require("../common/keytar-protocol");
const credentials_service_1 = require("./credentials-service");
const contribution_filter_1 = require("../common/contribution-filter");
const quick_command_frontend_contribution_1 = require("./quick-input/quick-command-frontend-contribution");
const quick_pick_service_1 = require("../common/quick-pick-service");
const quick_input_1 = require("./quick-input");
const sidebar_bottom_menu_widget_1 = require("./shell/sidebar-bottom-menu-widget");
const window_contribution_1 = require("./window-contribution");
const breadcrumbs_1 = require("./breadcrumbs");
const widgets_1 = require("./widgets");
const tooltip_service_1 = require("./tooltip-service");
const performance_1 = require("./performance");
const save_resource_service_1 = require("./save-resource-service");
const user_working_directory_provider_1 = require("./user-working-directory-provider");
color_application_contribution_1.ColorApplicationContribution.initBackground();
exports.frontendApplicationModule = new inversify_1.ContainerModule((bind, unbind, isBound, rebind) => {
    bind(icon_theme_service_1.NoneIconTheme).toSelf().inSingletonScope();
    bind(label_provider_1.LabelProviderContribution).toService(icon_theme_service_1.NoneIconTheme);
    bind(icon_theme_service_1.IconThemeService).toSelf().inSingletonScope();
    (0, common_1.bindContributionProvider)(bind, icon_theme_contribution_1.IconThemeContribution);
    bind(icon_theme_contribution_1.DefaultFileIconThemeContribution).toSelf().inSingletonScope();
    bind(icon_theme_contribution_1.IconThemeContribution).toService(icon_theme_contribution_1.DefaultFileIconThemeContribution);
    bind(icon_theme_contribution_1.IconThemeApplicationContribution).toSelf().inSingletonScope();
    bind(frontend_application_1.FrontendApplicationContribution).toService(icon_theme_contribution_1.IconThemeApplicationContribution);
    bind(color_registry_1.ColorRegistry).toSelf().inSingletonScope();
    (0, common_1.bindContributionProvider)(bind, color_application_contribution_1.ColorContribution);
    bind(color_application_contribution_1.ColorApplicationContribution).toSelf().inSingletonScope();
    bind(frontend_application_1.FrontendApplicationContribution).toService(color_application_contribution_1.ColorApplicationContribution);
    bind(frontend_application_1.FrontendApplication).toSelf().inSingletonScope();
    bind(frontend_application_state_1.FrontendApplicationStateService).toSelf().inSingletonScope();
    bind(frontend_application_1.DefaultFrontendApplicationContribution).toSelf();
    (0, common_1.bindContributionProvider)(bind, frontend_application_1.FrontendApplicationContribution);
    bind(shell_1.ApplicationShellOptions).toConstantValue({});
    bind(shell_1.ApplicationShell).toSelf().inSingletonScope();
    bind(shell_1.SidePanelHandlerFactory).toAutoFactory(shell_1.SidePanelHandler);
    bind(shell_1.SidePanelHandler).toSelf();
    bind(shell_1.SidebarTopMenuWidgetFactory).toAutoFactory(shell_1.SidebarMenuWidget);
    bind(shell_1.SidebarMenuWidget).toSelf();
    bind(sidebar_bottom_menu_widget_1.SidebarBottomMenuWidget).toSelf();
    bind(shell_1.SidebarBottomMenuWidgetFactory).toAutoFactory(sidebar_bottom_menu_widget_1.SidebarBottomMenuWidget);
    bind(shell_1.SplitPositionHandler).toSelf().inSingletonScope();
    (0, common_1.bindContributionProvider)(bind, tab_bar_toolbar_1.TabBarToolbarContribution);
    bind(tab_bar_toolbar_1.TabBarToolbarRegistry).toSelf().inSingletonScope();
    bind(frontend_application_1.FrontendApplicationContribution).toService(tab_bar_toolbar_1.TabBarToolbarRegistry);
    bind(tab_bar_toolbar_1.TabBarToolbarFactory).toFactory(context => () => {
        const container = context.container.createChild();
        container.bind(tab_bar_toolbar_1.TabBarToolbar).toSelf().inSingletonScope();
        return container.get(tab_bar_toolbar_1.TabBarToolbar);
    });
    bind(shell_1.DockPanelRendererFactory).toFactory(context => () => context.container.get(shell_1.DockPanelRenderer));
    bind(shell_1.DockPanelRenderer).toSelf();
    bind(shell_1.TabBarRendererFactory).toFactory(({ container }) => () => {
        const contextMenuRenderer = container.get(context_menu_renderer_1.ContextMenuRenderer);
        const tabBarDecoratorService = container.get(tab_bar_decorator_1.TabBarDecoratorService);
        const iconThemeService = container.get(icon_theme_service_1.IconThemeService);
        const selectionService = container.get(common_1.SelectionService);
        const commandService = container.get(common_1.CommandService);
        return new shell_1.TabBarRenderer(contextMenuRenderer, tabBarDecoratorService, iconThemeService, selectionService, commandService);
    });
    (0, common_1.bindContributionProvider)(bind, tab_bar_decorator_1.TabBarDecorator);
    bind(tab_bar_decorator_1.TabBarDecoratorService).toSelf().inSingletonScope();
    bind(frontend_application_1.FrontendApplicationContribution).toService(tab_bar_decorator_1.TabBarDecoratorService);
    (0, common_1.bindContributionProvider)(bind, opener_service_1.OpenHandler);
    bind(opener_service_1.DefaultOpenerService).toSelf().inSingletonScope();
    bind(opener_service_1.OpenerService).toService(opener_service_1.DefaultOpenerService);
    bind(external_uri_service_1.ExternalUriService).toSelf().inSingletonScope();
    bind(http_open_handler_1.HttpOpenHandler).toSelf().inSingletonScope();
    bind(opener_service_1.OpenHandler).toService(http_open_handler_1.HttpOpenHandler);
    bind(command_open_handler_1.CommandOpenHandler).toSelf().inSingletonScope();
    bind(opener_service_1.OpenHandler).toService(command_open_handler_1.CommandOpenHandler);
    bind(tooltip_service_1.TooltipServiceImpl).toSelf().inSingletonScope();
    bind(tooltip_service_1.TooltipService).toService(tooltip_service_1.TooltipServiceImpl);
    (0, common_1.bindContributionProvider)(bind, shell_1.ApplicationShellLayoutMigration);
    bind(shell_1.ApplicationShellLayoutMigration).toConstantValue({
        layoutVersion: 2.0,
        onWillInflateLayout({ layoutVersion }) {
            throw shell_1.ApplicationShellLayoutMigrationError.create(`It is not possible to migrate layout of version ${layoutVersion} to version ${this.layoutVersion}.`);
        }
    });
    (0, common_1.bindContributionProvider)(bind, widget_manager_1.WidgetFactory);
    bind(widget_manager_1.WidgetManager).toSelf().inSingletonScope();
    bind(shell_1.ShellLayoutRestorer).toSelf().inSingletonScope();
    bind(common_1.CommandContribution).toService(shell_1.ShellLayoutRestorer);
    (0, frontend_application_bindings_1.bindResourceProvider)(bind);
    bind(common_1.InMemoryResources).toSelf().inSingletonScope();
    bind(common_1.ResourceResolver).toService(common_1.InMemoryResources);
    bind(common_1.InMemoryTextResourceResolver).toSelf().inSingletonScope();
    bind(common_1.ResourceResolver).toService(common_1.InMemoryTextResourceResolver);
    bind(common_1.SelectionService).toSelf().inSingletonScope();
    bind(common_1.CommandRegistry).toSelf().inSingletonScope().onActivation(({ container }, registry) => {
        messaging_1.WebSocketConnectionProvider.createProxy(container, common_1.commandServicePath, registry);
        return registry;
    });
    bind(common_1.CommandService).toService(common_1.CommandRegistry);
    (0, common_1.bindContributionProvider)(bind, common_1.CommandContribution);
    bind(context_key_service_1.ContextKeyService).to(context_key_service_1.ContextKeyServiceDummyImpl).inSingletonScope();
    bind(common_1.MenuModelRegistry).toSelf().inSingletonScope();
    (0, common_1.bindContributionProvider)(bind, common_1.MenuContribution);
    bind(keyboard_layout_service_1.KeyboardLayoutService).toSelf().inSingletonScope();
    bind(keybinding_1.KeybindingRegistry).toSelf().inSingletonScope();
    (0, common_1.bindContributionProvider)(bind, keybinding_1.KeybindingContext);
    (0, common_1.bindContributionProvider)(bind, keybinding_1.KeybindingContribution);
    (0, frontend_application_bindings_1.bindMessageService)(bind).onActivation(({ container }, messages) => {
        const client = container.get(common_1.MessageClient);
        messaging_1.WebSocketConnectionProvider.createProxy(container, common_1.messageServicePath, client);
        return messages;
    });
    bind(language_service_1.LanguageService).toSelf().inSingletonScope();
    bind(encoding_service_1.EncodingService).toSelf().inSingletonScope();
    bind(encoding_registry_1.EncodingRegistry).toSelf().inSingletonScope();
    bind(resource_context_key_1.ResourceContextKey).toSelf().inSingletonScope();
    bind(common_frontend_contribution_1.CommonFrontendContribution).toSelf().inSingletonScope();
    [frontend_application_1.FrontendApplicationContribution, common_1.CommandContribution, keybinding_1.KeybindingContribution, common_1.MenuContribution, color_application_contribution_1.ColorContribution].forEach(serviceIdentifier => bind(serviceIdentifier).toService(common_frontend_contribution_1.CommonFrontendContribution));
    bind(quick_command_frontend_contribution_1.QuickCommandFrontendContribution).toSelf().inSingletonScope();
    [common_1.CommandContribution, keybinding_1.KeybindingContribution, common_1.MenuContribution].forEach(serviceIdentifier => bind(serviceIdentifier).toService(quick_command_frontend_contribution_1.QuickCommandFrontendContribution));
    bind(quick_input_1.QuickCommandService).toSelf().inSingletonScope();
    bind(quick_input_1.QuickAccessContribution).toService(quick_input_1.QuickCommandService);
    bind(quick_input_1.QuickHelpService).toSelf().inSingletonScope();
    bind(quick_input_1.QuickAccessContribution).toService(quick_input_1.QuickHelpService);
    bind(quick_pick_service_1.QuickPickService).to(quick_input_1.QuickPickServiceImpl).inSingletonScope().onActivation(({ container }, quickPickService) => {
        messaging_1.WebSocketConnectionProvider.createProxy(container, quick_pick_service_1.quickPickServicePath, quickPickService);
        return quickPickService;
    });
    (0, common_1.bindContributionProvider)(bind, quick_input_1.QuickAccessContribution);
    bind(quick_input_1.QuickInputFrontendContribution).toSelf().inSingletonScope();
    bind(frontend_application_1.FrontendApplicationContribution).toService(quick_input_1.QuickInputFrontendContribution);
    bind(storage_service_1.LocalStorageService).toSelf().inSingletonScope();
    bind(storage_service_1.StorageService).toService(storage_service_1.LocalStorageService);
    bind(status_bar_1.StatusBarImpl).toSelf().inSingletonScope();
    bind(status_bar_1.StatusBar).toService(status_bar_1.StatusBarImpl);
    bind(label_parser_1.LabelParser).toSelf().inSingletonScope();
    (0, common_1.bindContributionProvider)(bind, label_provider_1.LabelProviderContribution);
    bind(label_provider_1.LabelProvider).toSelf().inSingletonScope();
    bind(frontend_application_1.FrontendApplicationContribution).toService(label_provider_1.LabelProvider);
    bind(label_provider_1.DefaultUriLabelProviderContribution).toSelf().inSingletonScope();
    bind(label_provider_1.LabelProviderContribution).toService(label_provider_1.DefaultUriLabelProviderContribution);
    bind(label_provider_1.LabelProviderContribution).to(diff_uris_1.DiffUriLabelProviderContribution).inSingletonScope();
    bind(tree_label_provider_1.TreeLabelProvider).toSelf().inSingletonScope();
    bind(label_provider_1.LabelProviderContribution).toService(tree_label_provider_1.TreeLabelProvider);
    (0, frontend_application_bindings_1.bindPreferenceService)(bind);
    bind(frontend_application_1.FrontendApplicationContribution).toService(preferences_1.PreferenceService);
    (0, common_1.bindContributionProvider)(bind, json_schema_store_1.JsonSchemaContribution);
    bind(json_schema_store_1.JsonSchemaStore).toSelf().inSingletonScope();
    bind(frontend_application_1.FrontendApplicationContribution).toService(json_schema_store_1.JsonSchemaStore);
    bind(json_schema_store_1.DefaultJsonSchemaContribution).toSelf().inSingletonScope();
    bind(json_schema_store_1.JsonSchemaContribution).toService(json_schema_store_1.DefaultJsonSchemaContribution);
    bind(connection_status_service_1.PingService).toDynamicValue(ctx => {
        // let's reuse a simple and cheap service from this package
        const envServer = ctx.container.get(env_variables_1.EnvVariablesServer);
        return {
            ping() {
                return envServer.getValue('does_not_matter');
            }
        };
    });
    bind(connection_status_service_1.FrontendConnectionStatusService).toSelf().inSingletonScope();
    bind(connection_status_service_1.ConnectionStatusService).toService(connection_status_service_1.FrontendConnectionStatusService);
    bind(frontend_application_1.FrontendApplicationContribution).toService(connection_status_service_1.FrontendConnectionStatusService);
    bind(connection_status_service_1.ApplicationConnectionStatusContribution).toSelf().inSingletonScope();
    bind(frontend_application_1.FrontendApplicationContribution).toService(connection_status_service_1.ApplicationConnectionStatusContribution);
    bind(application_protocol_1.ApplicationServer).toDynamicValue(ctx => {
        const provider = ctx.container.get(messaging_1.WebSocketConnectionProvider);
        return provider.createProxy(application_protocol_1.applicationPath);
    }).inSingletonScope();
    bind(about_dialog_1.AboutDialog).toSelf().inSingletonScope();
    bind(about_dialog_1.AboutDialogProps).toConstantValue({ title: 'Theia' });
    bind(env_variables_1.EnvVariablesServer).toDynamicValue(ctx => {
        const connection = ctx.container.get(messaging_1.WebSocketConnectionProvider);
        return connection.createProxy(env_variables_1.envVariablesPath);
    }).inSingletonScope();
    bind(theming_1.ThemeService).toDynamicValue(() => theming_1.ThemeService.get());
    (0, core_preferences_1.bindCorePreferences)(bind);
    bind(mime_service_1.MimeService).toSelf().inSingletonScope();
    bind(application_shell_mouse_tracker_1.ApplicationShellMouseTracker).toSelf().inSingletonScope();
    bind(frontend_application_1.FrontendApplicationContribution).toService(application_shell_mouse_tracker_1.ApplicationShellMouseTracker);
    bind(view_container_1.ViewContainer.Factory).toFactory(context => (options) => {
        const container = context.container.createChild();
        container.bind(view_container_1.ViewContainerIdentifier).toConstantValue(options);
        container.bind(view_container_1.ViewContainer).toSelf().inSingletonScope();
        return container.get(view_container_1.ViewContainer);
    });
    bind(quick_view_service_1.QuickViewService).toSelf().inSingletonScope();
    bind(quick_input_1.QuickAccessContribution).toService(quick_view_service_1.QuickViewService);
    bind(dialogs_1.DialogOverlayService).toSelf().inSingletonScope();
    bind(frontend_application_1.FrontendApplicationContribution).toService(dialogs_1.DialogOverlayService);
    bind(progress_client_1.DispatchingProgressClient).toSelf().inSingletonScope();
    bind(progress_location_service_1.ProgressLocationService).toSelf().inSingletonScope();
    bind(progress_status_bar_item_1.ProgressStatusBarItem).toSelf().inSingletonScope();
    bind(progress_service_protocol_1.ProgressClient).toService(progress_client_1.DispatchingProgressClient);
    bind(progress_service_1.ProgressService).toSelf().inSingletonScope();
    bind(progress_bar_factory_1.ProgressBarFactory).toFactory(context => (options) => {
        const childContainer = context.container.createChild();
        childContainer.bind(progress_bar_factory_1.ProgressBarOptions).toConstantValue(options);
        childContainer.bind(progress_bar_1.ProgressBar).toSelf().inSingletonScope();
        return childContainer.get(progress_bar_1.ProgressBar);
    });
    bind(context_menu_context_1.ContextMenuContext).toSelf().inSingletonScope();
    bind(authentication_service_1.AuthenticationService).to(authentication_service_1.AuthenticationServiceImpl).inSingletonScope();
    bind(decorations_service_1.DecorationsService).to(decorations_service_1.DecorationsServiceImpl).inSingletonScope();
    bind(keytar_protocol_1.KeytarService).toDynamicValue(ctx => {
        const connection = ctx.container.get(messaging_1.WebSocketConnectionProvider);
        return connection.createProxy(keytar_protocol_1.keytarServicePath);
    }).inSingletonScope();
    bind(credentials_service_1.CredentialsService).to(credentials_service_1.CredentialsServiceImpl);
    bind(contribution_filter_1.ContributionFilterRegistry).to(contribution_filter_1.ContributionFilterRegistryImpl).inSingletonScope();
    bind(window_contribution_1.WindowContribution).toSelf().inSingletonScope();
    for (const contribution of [common_1.CommandContribution, keybinding_1.KeybindingContribution, common_1.MenuContribution]) {
        bind(contribution).toService(window_contribution_1.WindowContribution);
    }
    (0, common_1.bindContributionProvider)(bind, breadcrumbs_1.BreadcrumbsContribution);
    bind(breadcrumbs_1.BreadcrumbsService).toSelf().inSingletonScope();
    bind(breadcrumbs_1.BreadcrumbsRenderer).toSelf();
    bind(breadcrumbs_1.BreadcrumbsRendererFactory).toFactory(ctx => () => {
        const childContainer = ctx.container.createChild();
        childContainer.bind(breadcrumbs_1.BreadcrumbRenderer).to(breadcrumbs_1.DefaultBreadcrumbRenderer).inSingletonScope();
        return childContainer.get(breadcrumbs_1.BreadcrumbsRenderer);
    });
    bind(breadcrumbs_1.BreadcrumbPopupContainer).toSelf();
    bind(breadcrumbs_1.BreadcrumbPopupContainerFactory).toFactory(({ container }) => (parent, breadcrumbId, position) => {
        const child = container.createChild();
        child.bind(widgets_1.RendererHost).toConstantValue(parent);
        child.bind(breadcrumbs_1.BreadcrumbID).toConstantValue(breadcrumbId);
        child.bind(context_menu_renderer_1.Coordinate).toConstantValue(position);
        return child.get(breadcrumbs_1.BreadcrumbPopupContainer);
    });
    (0, performance_1.bindFrontendStopwatch)(bind);
    (0, performance_1.bindBackendStopwatch)(bind);
    bind(save_resource_service_1.SaveResourceService).toSelf().inSingletonScope();
    bind(user_working_directory_provider_1.UserWorkingDirectoryProvider).toSelf().inSingletonScope();
});
//# sourceMappingURL=frontend-application-module.js.map