/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.maven.apt.internal.processor;

import java.io.File;
import java.util.Collections;
import java.util.Set;
import org.apache.maven.plugin.MojoExecution;
import org.codehaus.plexus.util.Scanner;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.m2e.core.MavenPlugin;
import org.eclipse.m2e.core.embedder.IMaven;
import org.eclipse.m2e.core.project.configurator.MojoExecutionBuildParticipant;
import org.sonatype.plexus.build.incremental.BuildContext;

public class MavenProcessorBuildParticipant
extends MojoExecutionBuildParticipant {
    public MavenProcessorBuildParticipant(MojoExecution execution) {
        super(execution, true);
    }

    public Set<IProject> build(int kind, IProgressMonitor monitor) throws Exception {
        IMaven maven = MavenPlugin.getMaven();
        BuildContext buildContext = this.getBuildContext();
        monitor.setTaskName("Executing " + this.getMojoExecution().getArtifactId() + ":" + this.getMojoExecution().getGoal());
        if (!buildContext.hasDelta(this.getMavenProjectFacade().getPomFile())) {
            File source = (File)maven.getMojoParameterValue(this.getSession(), this.getMojoExecution(), "sourceDirectory", File.class);
            Scanner ds = buildContext.newScanner(source);
            ds.scan();
            String[] includedFiles = ds.getIncludedFiles();
            if (includedFiles == null || includedFiles.length <= 0) {
                return null;
            }
            if (this.getBuildContext().isIncremental()) {
                boolean interestingFileChanged = false;
                String[] stringArray = includedFiles;
                int n = includedFiles.length;
                int n2 = 0;
                while (n2 < n) {
                    String f = stringArray[n2];
                    if (f.endsWith(".java")) {
                        interestingFileChanged = true;
                        break;
                    }
                    ++n2;
                }
                if (!interestingFileChanged) {
                    return Collections.emptySet();
                }
            }
        }
        Set result = super.build(kind, monitor);
        File generated = (File)maven.getMojoParameterValue(this.getSession(), this.getMojoExecution(), "outputDirectory", File.class);
        if (generated == null) {
            generated = (File)maven.getMojoParameterValue(this.getSession(), this.getMojoExecution(), "defaultOutputDirectory", File.class);
        }
        if (generated != null) {
            buildContext.refresh(generated);
        }
        return result;
    }
}

