"use strict";
// *****************************************************************************
// Copyright (C) 2022 Ericsson and others.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
// *****************************************************************************
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var StatusBarHoverManager_1;
Object.defineProperty(exports, "__esModule", { value: true });
exports.StatusBarHoverManager = void 0;
const inversify_1 = require("inversify");
const common_1 = require("../../common");
const markdown_renderer_1 = require("../markdown-rendering/markdown-renderer");
const preferences_1 = require("../preferences");
let StatusBarHoverManager = StatusBarHoverManager_1 = class StatusBarHoverManager {
    constructor() {
        this.lastHidHover = Date.now();
        this.disposeOnHide = new common_1.DisposableCollection();
    }
    get markdownRenderer() {
        this._markdownRenderer || (this._markdownRenderer = this.markdownRendererFactory());
        return this._markdownRenderer;
    }
    get hoverHost() {
        if (!this._hoverHost) {
            this._hoverHost = document.createElement('div');
            this._hoverHost.classList.add(StatusBarHoverManager_1.hostClassName);
            this._hoverHost.style.position = 'absolute';
        }
        return this._hoverHost;
    }
    requestHover(hover, target) {
        if (target !== this.hoverTarget) {
            this.cancelHover();
            this.pendingTimeout = (0, common_1.disposableTimeout)(() => this.renderHover(hover, target), this.getHoverDelay());
        }
    }
    getHoverDelay() {
        return Date.now() - this.lastHidHover < 200
            ? 0
            : this.preferences.get('workbench.hover.delay', common_1.isOSX ? 1500 : 500);
    }
    async renderHover(hover, target) {
        const host = this.hoverHost;
        this.hoverTarget = target;
        if (hover instanceof HTMLElement) {
            host.appendChild(hover);
        }
        else if (typeof hover === 'string') {
            host.textContent = hover;
        }
        else {
            const content = this.markdownRenderer.render(hover);
            this.disposeOnHide.push(content);
            host.appendChild(content.element);
        }
        this.disposeOnHide.push({ dispose: () => this.lastHidHover = Date.now() });
        document.body.append(host);
        await new Promise(resolve => requestAnimationFrame(resolve)); // Allow the browser to size the host
        const targetDimensions = target.getBoundingClientRect();
        const targetMiddle = targetDimensions.left + (targetDimensions.width / 2);
        const hostDimensions = host.getBoundingClientRect();
        const documentWidth = document.body.getBoundingClientRect().width;
        const middleAlignment = targetMiddle - (hostDimensions.width / 2);
        const furthestRight = Math.min(documentWidth - hostDimensions.width, middleAlignment);
        const left = Math.max(0, furthestRight);
        host.style.setProperty('--theia-status-bar-hover-before-left', `${targetMiddle - left - 5}px`); // Centered on the status bar element.
        host.style.bottom = `${targetDimensions.height + 5}px`;
        host.style.left = `${left}px`;
        this.listenForMouseOut();
    }
    listenForMouseOut() {
        const handleMouseMove = (e) => {
            var _a;
            if (e.target instanceof Node && !this.hoverHost.contains(e.target) && !((_a = this.hoverTarget) === null || _a === void 0 ? void 0 : _a.contains(e.target))) {
                this.cancelHover();
            }
        };
        document.addEventListener('mousemove', handleMouseMove);
        this.disposeOnHide.push({ dispose: () => document.removeEventListener('mousemove', handleMouseMove) });
    }
    cancelHover() {
        var _a;
        (_a = this.pendingTimeout) === null || _a === void 0 ? void 0 : _a.dispose();
        this.unRenderHover();
        this.disposeOnHide.dispose();
        this.hoverTarget = undefined;
    }
    unRenderHover() {
        this.hoverHost.remove();
        this.hoverHost.replaceChildren();
    }
};
StatusBarHoverManager.hostClassName = 'theia-status-bar-hover';
StatusBarHoverManager.styleSheetId = 'theia-status-bar-hover-style';
__decorate([
    (0, inversify_1.inject)(preferences_1.PreferenceService),
    __metadata("design:type", Object)
], StatusBarHoverManager.prototype, "preferences", void 0);
__decorate([
    (0, inversify_1.inject)(markdown_renderer_1.MarkdownRendererFactory),
    __metadata("design:type", Function)
], StatusBarHoverManager.prototype, "markdownRendererFactory", void 0);
StatusBarHoverManager = StatusBarHoverManager_1 = __decorate([
    (0, inversify_1.injectable)()
], StatusBarHoverManager);
exports.StatusBarHoverManager = StatusBarHoverManager;
//# sourceMappingURL=status-bar-hover-manager.js.map