"use strict";
// *****************************************************************************
// Copyright (C) 2020 TypeFox and others.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
// *****************************************************************************
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.VSXExtensionResolver = void 0;
const os = require("os");
const path = require("path");
const semver = require("semver");
const fs = require("@theia/core/shared/fs-extra");
const uuid_1 = require("uuid");
const inversify_1 = require("@theia/core/shared/inversify");
const uri_1 = require("@theia/core/lib/common/uri");
const plugin_protocol_1 = require("@theia/plugin-ext/lib/common/plugin-protocol");
const vsx_extension_uri_1 = require("../common/vsx-extension-uri");
const ovsx_client_provider_1 = require("../common/ovsx-client-provider");
const request_1 = require("@theia/core/shared/@theia/request");
let VSXExtensionResolver = class VSXExtensionResolver {
    constructor() {
        this.downloadPath = path.resolve(os.tmpdir(), (0, uuid_1.v4)());
        fs.ensureDirSync(this.downloadPath);
        fs.emptyDirSync(this.downloadPath);
    }
    accept(pluginId) {
        return !!vsx_extension_uri_1.VSXExtensionUri.toId(new uri_1.default(pluginId));
    }
    async resolve(context) {
        const id = vsx_extension_uri_1.VSXExtensionUri.toId(new uri_1.default(context.getOriginId()));
        if (!id) {
            return;
        }
        console.log(`[${id}]: trying to resolve latest version...`);
        const client = await this.clientProvider();
        const extension = await client.getLatestCompatibleExtensionVersion(id);
        if (!extension) {
            return;
        }
        if (extension.error) {
            throw new Error(extension.error);
        }
        const resolvedId = id + '-' + extension.version;
        const downloadUrl = extension.files.download;
        console.log(`[${id}]: resolved to '${resolvedId}'`);
        const existingVersion = this.hasSameOrNewerVersion(id, extension);
        if (existingVersion) {
            console.log(`[${id}]: is already installed with the same or newer version '${existingVersion}'`);
            return;
        }
        const extensionPath = path.resolve(this.downloadPath, path.basename(downloadUrl));
        console.log(`[${resolvedId}]: trying to download from "${downloadUrl}"...`);
        if (!await this.download(downloadUrl, extensionPath)) {
            console.log(`[${resolvedId}]: not found`);
            return;
        }
        console.log(`[${resolvedId}]: downloaded to ${extensionPath}"`);
        context.addPlugin(resolvedId, extensionPath);
    }
    hasSameOrNewerVersion(id, extension) {
        const existingPlugin = this.pluginDeployerHandler.getDeployedPlugin(id);
        if (existingPlugin) {
            const existingVersion = semver.clean(existingPlugin.metadata.model.version);
            const desiredVersion = semver.clean(extension.version);
            if (desiredVersion && existingVersion && semver.gte(existingVersion, desiredVersion)) {
                return existingVersion;
            }
        }
        return undefined;
    }
    async download(downloadUrl, downloadPath) {
        const context = await this.requestService.request({ url: downloadUrl });
        if (context.res.statusCode === 404) {
            return false;
        }
        else if (context.res.statusCode !== 200) {
            throw new Error('Request returned status code: ' + context.res.statusCode);
        }
        else {
            await fs.writeFile(downloadPath, context.buffer);
            return true;
        }
    }
};
__decorate([
    (0, inversify_1.inject)(ovsx_client_provider_1.OVSXClientProvider),
    __metadata("design:type", Function)
], VSXExtensionResolver.prototype, "clientProvider", void 0);
__decorate([
    (0, inversify_1.inject)(plugin_protocol_1.PluginDeployerHandler),
    __metadata("design:type", Object)
], VSXExtensionResolver.prototype, "pluginDeployerHandler", void 0);
__decorate([
    (0, inversify_1.inject)(request_1.RequestService),
    __metadata("design:type", Object)
], VSXExtensionResolver.prototype, "requestService", void 0);
VSXExtensionResolver = __decorate([
    (0, inversify_1.injectable)(),
    __metadata("design:paramtypes", [])
], VSXExtensionResolver);
exports.VSXExtensionResolver = VSXExtensionResolver;
//# sourceMappingURL=vsx-extension-resolver.js.map